/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.feature;

import cofh.api.world.IFeatureGenerator;
import cofh.api.world.IFeatureParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import cofh.lib.world.WorldGenSparseMinableCluster;
import cofh.lib.world.feature.FeatureBase;
import cofh.lib.world.feature.FeatureOreGenUniform;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class UniformParser
implements IFeatureParser {
    private final List<WeightedRandomBlock> defaultMaterial = this.generateDefaultMaterial();

    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(new ItemStack(Blocks.field_150348_b, 1, -1)));
    }

    @Override
    public IFeatureGenerator parseFeature(String string, JsonObject jsonObject, Logger logger) {
        int n;
        int n2;
        String string2;
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        if (!FeatureParser.parseResList(jsonObject.get("block"), arrayList)) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        FeatureBase.GenRestriction genRestriction = FeatureBase.GenRestriction.NONE;
        FeatureBase.GenRestriction genRestriction2 = FeatureBase.GenRestriction.NONE;
        List<WeightedRandomBlock> list = this.defaultMaterial;
        if (jsonObject.has("clusterSize")) {
            n3 = jsonObject.get("clusterSize").getAsInt();
        }
        if (jsonObject.has("numClusters")) {
            n4 = jsonObject.get("numClusters").getAsInt();
        }
        if (n3 <= 0 || n4 <= 0) {
            logger.error("Invalid cluster size or count specified in \"" + string + "\"");
            return null;
        }
        if (jsonObject.has("retrogen")) {
            bl = jsonObject.get("retrogen").getAsBoolean();
        }
        if (jsonObject.has("biomeRestriction")) {
            string2 = jsonObject.get("biomeRestriction").getAsString().toLowerCase();
            if (string2.equals("blacklist")) {
                genRestriction = FeatureBase.GenRestriction.BLACKLIST;
            }
            if (string2.equals("whitelist")) {
                genRestriction = FeatureBase.GenRestriction.WHITELIST;
            }
        }
        if (jsonObject.has("dimensionRestriction")) {
            string2 = jsonObject.get("dimensionRestriction").getAsString().toLowerCase();
            if (string2.equals("blacklist")) {
                genRestriction2 = FeatureBase.GenRestriction.BLACKLIST;
            }
            if (string2.equals("whitelist")) {
                genRestriction2 = FeatureBase.GenRestriction.WHITELIST;
            }
        }
        if (jsonObject.has("material") && !this.parseMaterial(jsonObject, list = new ArrayList<WeightedRandomBlock>())) {
            logger.warn("Invalid material list! Using default list.");
            list = this.defaultMaterial;
        }
        if (this.verifyHeight(n2 = this.parseMinHeight(jsonObject), n = this.parseMaxHeight(jsonObject))) {
            logger.error("Invalid height parameters specified in \"" + string + "\"");
            return null;
        }
        FeatureBase featureBase = this.getFeature(string, this.getGenerator(jsonObject, logger, arrayList, n3, list), list, n4, n2, n, genRestriction, bl, genRestriction2);
        UniformParser.addFeatureRestrictions(featureBase, jsonObject);
        return featureBase;
    }

    protected FeatureBase getFeature(String string, WorldGenerator worldGenerator, List<WeightedRandomBlock> list, int n, int n2, int n3, FeatureBase.GenRestriction genRestriction, boolean bl, FeatureBase.GenRestriction genRestriction2) {
        return new FeatureOreGenUniform(string, worldGenerator, n, n2, n3, genRestriction, bl, genRestriction2);
    }

    protected int parseMinHeight(JsonObject jsonObject) {
        return jsonObject.get("minHeight").getAsInt();
    }

    protected int parseMaxHeight(JsonObject jsonObject) {
        return jsonObject.get("maxHeight").getAsInt();
    }

    protected boolean verifyHeight(int n, int n2) {
        return n >= n2 || n < 0;
    }

    protected boolean parseMaterial(JsonObject jsonObject, List<WeightedRandomBlock> list) {
        return FeatureParser.parseResList(jsonObject.get("material"), list);
    }

    protected WorldGenerator getGenerator(JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        JsonElement jsonElement = jsonObject.get("template");
        if (jsonElement.isJsonObject()) {
            jsonObject = jsonElement.getAsJsonObject();
            String string = jsonObject.get("generator").getAsString();
            if ("sparse-cluster".equals(string)) {
                return new WorldGenSparseMinableCluster(list, n, list2);
            }
            if (!"cluster".equals(string)) {
                logger.warn("Unknown generator " + string + '!');
            }
            return new WorldGenMinableCluster(list, n, list2);
        }
        return new WorldGenMinableCluster(list, n, list2);
    }

    protected static boolean addFeatureRestrictions(FeatureBase featureBase, JsonObject jsonObject) {
        int n;
        JsonArray jsonArray;
        if (featureBase.biomeRestriction != FeatureBase.GenRestriction.NONE && jsonObject.has("biomes")) {
            jsonArray = jsonObject.getAsJsonArray("biomes");
            for (n = 0; n < jsonArray.size(); ++n) {
                featureBase.addBiome(jsonArray.get(n).getAsString());
            }
        }
        if (featureBase.dimensionRestriction != FeatureBase.GenRestriction.NONE && jsonObject.has("dimensions")) {
            jsonArray = jsonObject.getAsJsonArray("dimensions");
            for (n = 0; n < jsonArray.size(); ++n) {
                featureBase.addDimension(jsonArray.get(n).getAsInt());
            }
        }
        return true;
    }
}

