/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.api.energy.IEnergyStorage;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.MathHelper;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class ElementEnergyStored
extends ElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/Energy.png");
    public static final int DEFAULT_SCALE = 42;
    protected IEnergyStorage storage;

    public ElementEnergyStored(GuiBase guiBase, int n, int n2, IEnergyStorage iEnergyStorage) {
        super(guiBase, n, n2);
        this.storage = iEnergyStorage;
        this.texture = DEFAULT_TEXTURE;
        this.sizeX = 16;
        this.sizeY = 42;
        this.texW = 32;
        this.texH = 64;
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        int n3 = this.getScaled();
        this.drawTexturedModalRect(this.posX, this.posY + 42 - n3, 16, 42 - n3, this.sizeX, n3);
    }

    @Override
    public void drawForeground(int n, int n2) {
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.storage.getMaxEnergyStored() < 0) {
            list.add("Infinite RF");
        } else {
            list.add(this.storage.getEnergyStored() + " / " + this.storage.getMaxEnergyStored() + " RF");
        }
    }

    int getScaled() {
        if (this.storage.getMaxEnergyStored() < 0) {
            return this.sizeY;
        }
        return MathHelper.round(this.storage.getEnergyStored() * this.sizeY / this.storage.getMaxEnergyStored());
    }
}

