/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComparableItemStack {
    public Item item = null;
    public int metadata = -1;
    public int stackSize = -1;
    public int oreID = -1;

    public ComparableItemStack(ItemStack itemStack) {
        if (itemStack != null) {
            this.item = itemStack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(itemStack);
            this.stackSize = itemStack.field_77994_a;
            this.oreID = ItemHelper.oreProxy.getOreID(itemStack);
        }
    }

    public ComparableItemStack(Item item, int n, int n2) {
        this.item = item;
        this.metadata = n;
        this.stackSize = n2;
        this.oreID = ItemHelper.oreProxy.getOreID(this.toItemStack());
    }

    public ComparableItemStack(ComparableItemStack comparableItemStack) {
        this.item = comparableItemStack.item;
        this.metadata = comparableItemStack.metadata;
        this.stackSize = comparableItemStack.stackSize;
        this.oreID = comparableItemStack.oreID;
    }

    public ComparableItemStack(String string) {
        if (ItemHelper.oreNameExists(string)) {
            ItemStack itemStack = ItemHelper.oreProxy.getOre(string);
            this.item = itemStack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(itemStack);
            this.stackSize = 1;
            this.oreID = ItemHelper.oreProxy.getOreID(itemStack);
        }
    }

    public ComparableItemStack set(ItemStack itemStack) {
        if (itemStack != null) {
            this.item = itemStack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(itemStack);
            this.stackSize = itemStack.field_77994_a;
            this.oreID = ItemHelper.oreProxy.getOreID(itemStack);
        } else {
            this.item = null;
            this.metadata = -1;
            this.stackSize = -1;
            this.oreID = -1;
        }
        return this;
    }

    public ComparableItemStack set(ComparableItemStack comparableItemStack) {
        if (comparableItemStack != null) {
            this.item = comparableItemStack.item;
            this.metadata = comparableItemStack.metadata;
            this.stackSize = comparableItemStack.stackSize;
            this.oreID = comparableItemStack.oreID;
        } else {
            this.item = null;
            this.metadata = -1;
            this.stackSize = -1;
            this.oreID = -1;
        }
        return this;
    }

    public boolean isItemEqual(ComparableItemStack comparableItemStack) {
        return comparableItemStack != null && (this.oreID != -1 && this.oreID == comparableItemStack.oreID || this.item == comparableItemStack.item && this.metadata == comparableItemStack.metadata);
    }

    public boolean isStackEqual(ComparableItemStack comparableItemStack) {
        return this.isItemEqual(comparableItemStack) && this.stackSize == comparableItemStack.stackSize;
    }

    public boolean isStackValid() {
        return this.item != null;
    }

    public ItemStack toItemStack() {
        return this.item != null ? new ItemStack(this.item, this.stackSize, this.metadata) : null;
    }

    public ComparableItemStack clone() {
        return new ComparableItemStack(this);
    }

    public int hashCode() {
        return this.oreID != -1 ? this.oreID : this.metadata | Item.func_150891_b((Item)this.item) << 16;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        return this.isItemEqual((ComparableItemStack)object);
    }
}

