/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.lib.util.helpers.BlockHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyHelper {
    public final int RF_PER_MJ = 10;
    public final int RF_PER_EU = 4;

    private EnergyHelper() {
    }

    public static int extractEnergyFromHeldContainer(EntityPlayer entityPlayer, int n, boolean bl) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        return EnergyHelper.isEnergyContainerItem(itemStack) ? ((IEnergyContainerItem)itemStack.func_77973_b()).extractEnergy(itemStack, n, bl) : 0;
    }

    public static int insertEnergyIntoHeldContainer(EntityPlayer entityPlayer, int n, boolean bl) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        return EnergyHelper.isEnergyContainerItem(itemStack) ? ((IEnergyContainerItem)itemStack.func_77973_b()).receiveEnergy(itemStack, n, bl) : 0;
    }

    public static boolean isPlayerHoldingEnergyContainerItem(EntityPlayer entityPlayer) {
        return EnergyHelper.isEnergyContainerItem(entityPlayer.func_71045_bC());
    }

    public static boolean isEnergyContainerItem(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof IEnergyContainerItem;
    }

    public static ItemStack setDefaultEnergyTag(ItemStack itemStack, int n) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74768_a("Energy", n);
        return itemStack;
    }

    public static int extractEnergyFromAdjacentEnergyHandler(TileEntity tileEntity, int n, int n2, boolean bl) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return tileEntity2 instanceof IEnergyHandler ? ((IEnergyHandler)tileEntity2).extractEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], n2, bl) : 0;
    }

    public static int insertEnergyIntoAdjacentEnergyHandler(TileEntity tileEntity, int n, int n2, boolean bl) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return tileEntity2 instanceof IEnergyHandler ? ((IEnergyHandler)tileEntity2).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], n2, bl) : 0;
    }

    public static boolean isAdjacentEnergyHandlerFromSide(TileEntity tileEntity, int n) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return EnergyHelper.isEnergyHandlerFromSide(tileEntity2, ForgeDirection.VALID_DIRECTIONS[n ^ 1]);
    }

    public static boolean isEnergyHandlerFromSide(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return tileEntity instanceof IEnergyHandler ? ((IEnergyHandler)tileEntity).canConnectEnergy(forgeDirection) : false;
    }
}

