/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinableCluster
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final int genClusterSize;
    private final WeightedRandomBlock[] genBlock;

    public static final List<WeightedRandomBlock> fabricateList(WeightedRandomBlock weightedRandomBlock) {
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        arrayList.add(weightedRandomBlock);
        return arrayList;
    }

    public static final List<WeightedRandomBlock> fabricateList(Block block) {
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        arrayList.add(new WeightedRandomBlock(new ItemStack(block, 1, 0)));
        return arrayList;
    }

    public WorldGenMinableCluster(ItemStack itemStack, int n) {
        this(new WeightedRandomBlock(itemStack), n);
    }

    public WorldGenMinableCluster(WeightedRandomBlock weightedRandomBlock, int n) {
        this(WorldGenMinableCluster.fabricateList(weightedRandomBlock), n);
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> list, int n) {
        this(list, n, Blocks.field_150348_b);
    }

    public WorldGenMinableCluster(ItemStack itemStack, int n, Block block) {
        this(new WeightedRandomBlock(itemStack, 1), n, block);
    }

    public WorldGenMinableCluster(WeightedRandomBlock weightedRandomBlock, int n, Block block) {
        this(WorldGenMinableCluster.fabricateList(weightedRandomBlock), n, block);
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> list, int n, Block block) {
        this(list, n, WorldGenMinableCluster.fabricateList(block));
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        this.cluster = list;
        this.genClusterSize = n > 32 ? 32 : n;
        this.genBlock = list2.toArray(new WeightedRandomBlock[list2.size()]);
    }

    public boolean func_76484_a(World world, Random random, int n, int n2, int n3) {
        if (this.genClusterSize < 4) {
            return this.generateTiny(world, random, n, n2, n3);
        }
        float f = random.nextFloat() * (float)Math.PI;
        double d = (float)(n + 8) + MathHelper.func_76126_a((float)f) * (float)this.genClusterSize / 8.0f;
        double d2 = (float)(n + 8) - MathHelper.func_76126_a((float)f) * (float)this.genClusterSize / 8.0f;
        double d3 = (float)(n3 + 8) + MathHelper.func_76134_b((float)f) * (float)this.genClusterSize / 8.0f;
        double d4 = (float)(n3 + 8) - MathHelper.func_76134_b((float)f) * (float)this.genClusterSize / 8.0f;
        double d5 = n2 + random.nextInt(3) - 2;
        double d6 = n2 + random.nextInt(3) - 2;
        boolean bl = false;
        for (int i = 0; i <= this.genClusterSize; ++i) {
            double d7 = d + (d2 - d) * (double)i / (double)this.genClusterSize;
            double d8 = d5 + (d6 - d5) * (double)i / (double)this.genClusterSize;
            double d9 = d3 + (d4 - d3) * (double)i / (double)this.genClusterSize;
            double d10 = random.nextDouble() * (double)this.genClusterSize / 16.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.genClusterSize)) + 1.0f) * d10 + 1.0;
            double d12 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.genClusterSize)) + 1.0f) * d10 + 1.0;
            int n4 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int n5 = MathHelper.func_76128_c((double)(d8 - d12 / 2.0));
            int n6 = MathHelper.func_76128_c((double)(d9 - d11 / 2.0));
            int n7 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int n8 = MathHelper.func_76128_c((double)(d8 + d12 / 2.0));
            int n9 = MathHelper.func_76128_c((double)(d9 + d11 / 2.0));
            for (int j = n4; j <= n7; ++j) {
                double d13 = ((double)j + 0.5 - d7) / (d11 / 2.0);
                if (!(d13 * d13 < 1.0)) continue;
                for (int k = n5; k <= n8; ++k) {
                    double d14 = ((double)k + 0.5 - d8) / (d12 / 2.0);
                    if (!(d13 * d13 + d14 * d14 < 1.0)) continue;
                    for (int i2 = n6; i2 <= n9; ++i2) {
                        double d15 = ((double)i2 + 0.5 - d9) / (d11 / 2.0);
                        if (!(d13 * d13 + d14 * d14 + d15 * d15 < 1.0)) continue;
                        bl |= WorldGenMinableCluster.generateBlock(world, j, k, i2, this.genBlock, this.cluster);
                    }
                }
            }
        }
        return bl;
    }

    public boolean generateTiny(World world, Random random, int n, int n2, int n3) {
        boolean bl = false;
        for (int i = 0; i < this.genClusterSize; ++i) {
            int n4 = n + random.nextInt(2);
            int n5 = n2 + random.nextInt(2);
            int n6 = n3 + random.nextInt(2);
            bl |= WorldGenMinableCluster.generateBlock(world, n4, n5, n6, this.genBlock, this.cluster);
        }
        return bl;
    }

    public static boolean generateBlock(World world, int n, int n2, int n3, WeightedRandomBlock[] weightedRandomBlockArray, List<WeightedRandomBlock> list) {
        boolean bl = false;
        Block block = world.func_147439_a(n, n2, n3);
        for (WeightedRandomBlock weightedRandomBlock : weightedRandomBlockArray) {
            if (-1 != weightedRandomBlock.metadata && weightedRandomBlock.metadata != world.func_72805_g(n, n2, n3) || !block.isReplaceableOreGen(world, n, n2, n3, weightedRandomBlock.block)) continue;
            WeightedRandomBlock weightedRandomBlock2 = (WeightedRandomBlock)WeightedRandom.func_76271_a((Random)world.field_73012_v, list);
            bl |= world.func_147465_d(n, n2, n3, weightedRandomBlock2.block, weightedRandomBlock2.metadata, 2);
            break;
        }
        return bl;
    }
}

