/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSparseMinableCluster
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final int genClusterSize;
    private final WeightedRandomBlock[] genBlock;

    public WorldGenSparseMinableCluster(ItemStack itemStack, int n) {
        this(new WeightedRandomBlock(itemStack), n);
    }

    public WorldGenSparseMinableCluster(WeightedRandomBlock weightedRandomBlock, int n) {
        this(WorldGenMinableCluster.fabricateList(weightedRandomBlock), n);
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> list, int n) {
        this(list, n, Blocks.field_150348_b);
    }

    public WorldGenSparseMinableCluster(ItemStack itemStack, int n, Block block) {
        this(new WeightedRandomBlock(itemStack, 1), n, block);
    }

    public WorldGenSparseMinableCluster(WeightedRandomBlock weightedRandomBlock, int n, Block block) {
        this(WorldGenMinableCluster.fabricateList(weightedRandomBlock), n, block);
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> list, int n, Block block) {
        this(list, n, WorldGenMinableCluster.fabricateList(block));
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        this.cluster = list;
        this.genClusterSize = n > 32 ? 32 : n;
        this.genBlock = list2.toArray(new WeightedRandomBlock[list2.size()]);
    }

    public boolean func_76484_a(World world, Random random, int n, int n2, int n3) {
        int n4 = this.genClusterSize;
        float f = random.nextFloat() * (float)Math.PI;
        float f2 = n2 + random.nextInt(3) - 2;
        float f3 = n2 + random.nextInt(3) - 2;
        if (n4 == 1 && f2 > f3) {
            ++n4;
        }
        if (n4 == 2 && f > 1.5707964f) {
            ++n4;
        }
        float f4 = (float)(n + 8) + MathHelper.func_76126_a((float)f) * (float)n4 / 8.0f;
        float f5 = (float)(n + 8) - MathHelper.func_76126_a((float)f) * (float)n4 / 8.0f;
        float f6 = (float)(n3 + 8) + MathHelper.func_76134_b((float)f) * (float)n4 / 8.0f;
        float f7 = (float)(n3 + 8) - MathHelper.func_76134_b((float)f) * (float)n4 / 8.0f;
        f5 -= f4;
        f3 -= f2;
        f7 -= f6;
        for (int i = 0; i <= n4; ++i) {
            float f8 = f4 + f5 * (float)i / (float)n4;
            float f9 = f2 + f3 * (float)i / (float)n4;
            float f10 = f6 + f7 * (float)i / (float)n4;
            float f11 = (float)random.nextDouble() * (float)n4 / 16.0f;
            float f12 = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)n4)) + 1.0f) * f11 + 1.0f) * 0.5f;
            float f13 = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)n4)) + 1.0f) * f11 + 1.0f) * 0.5f;
            int n5 = MathHelper.func_76141_d((float)(f8 - f12));
            int n6 = MathHelper.func_76141_d((float)(f9 - f13));
            int n7 = MathHelper.func_76141_d((float)(f10 - f12));
            int n8 = MathHelper.func_76141_d((float)(f8 + f12));
            int n9 = MathHelper.func_76141_d((float)(f9 + f13));
            int n10 = MathHelper.func_76141_d((float)(f10 + f12));
            for (int j = n5; j <= n8; ++j) {
                float f14 = ((float)j + 0.5f - f8) / f12;
                if ((f14 *= f14) >= 1.0f) continue;
                for (int k = n6; k <= n9; ++k) {
                    float f15;
                    float f16 = ((float)k + 0.5f - f9) / f13;
                    if ((f15 = (f16 *= f16) + f14) >= 1.0f) continue;
                    for (int i2 = n7; i2 <= n10; ++i2) {
                        float f17 = ((float)i2 + 0.5f - f10) / f12;
                        f14 *= f17;
                        if (f17 + f15 >= 1.0f) continue;
                        WorldGenMinableCluster.generateBlock(world, j, k, i2, this.genBlock, this.cluster);
                    }
                }
            }
        }
        return true;
    }
}

