/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.api.world.IFeatureGenerator;
import gnu.trove.set.hash.THashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;

public abstract class FeatureBase
implements IFeatureGenerator {
    public final String name;
    public final GenRestriction biomeRestriction;
    public final GenRestriction dimensionRestriction;
    public final boolean regen;
    protected final Set<String> biomes = new THashSet();
    protected final Set<Integer> dimensions = new THashSet();

    public FeatureBase(String string, boolean bl) {
        this(string, GenRestriction.NONE, bl, GenRestriction.NONE);
    }

    public FeatureBase(String string, boolean bl, GenRestriction genRestriction) {
        this(string, GenRestriction.NONE, bl, genRestriction);
    }

    public FeatureBase(String string, GenRestriction genRestriction, boolean bl) {
        this(string, genRestriction, bl, GenRestriction.NONE);
    }

    public FeatureBase(String string, GenRestriction genRestriction, boolean bl, GenRestriction genRestriction2) {
        this.name = string;
        this.biomeRestriction = genRestriction;
        this.dimensionRestriction = genRestriction2;
        this.regen = bl;
    }

    public FeatureBase addBiome(String string) {
        this.biomes.add(string);
        return this;
    }

    public FeatureBase addDimension(int n) {
        this.dimensions.add(n);
        return this;
    }

    @Override
    public final String getFeatureName() {
        return this.name;
    }

    @Override
    public abstract boolean generateFeature(Random var1, int var2, int var3, World var4, boolean var5);

    public static enum GenRestriction {
        NONE,
        BLACKLIST,
        WHITELIST;

    }
}

