/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod.updater;

import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.ModVersion;
import cofh.mod.updater.ReleaseVersion;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.spi.AbstractLogger;

public class UpdateCheckThread
extends Thread {
    private final String _releaseUrl;
    private final IUpdatableMod _mod;
    private boolean _checkComplete = false;
    private boolean _newVerAvailable = false;
    private boolean _criticalUpdate = false;
    private ModVersion _newVer;

    public UpdateCheckThread(IUpdatableMod iUpdatableMod) {
        this(iUpdatableMod, null);
    }

    public UpdateCheckThread(IUpdatableMod iUpdatableMod, String string) {
        super("CoFHUpdater");
        this._mod = iUpdatableMod;
        if (string == null) {
            string = "https://raw.github.com/skyboy/" + iUpdatableMod.getModId() + "/master/VERSION";
        }
        this._releaseUrl = string;
    }

    @Override
    public void run() {
        try {
            String string = this._mod.getModName();
            ModVersion modVersion = ModVersion.parse(string, this._mod.getModVersion());
            URL uRL = new URL(this._releaseUrl);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            ModVersion modVersion2 = ModVersion.parse(string, bufferedReader.readLine());
            ModVersion modVersion3 = ModVersion.parse(string, bufferedReader.readLine());
            bufferedReader.close();
            if (modVersion2 != null) {
                this._newVer = modVersion2;
                boolean bl = this._newVerAvailable = modVersion.compareTo(modVersion2) < 0;
                if (this._newVerAvailable) {
                    this._mod.getLogger().info("An updated version of " + this._mod.getModName() + " is available: " + modVersion2 + ".");
                    if (modVersion.minecraftVersion().compareTo(modVersion2.minecraftVersion()) < 0) {
                        ReleaseVersion releaseVersion = modVersion2.minecraftVersion();
                        ReleaseVersion releaseVersion2 = modVersion.minecraftVersion();
                        boolean bl2 = this._newVerAvailable = releaseVersion.major() == releaseVersion2.major() && releaseVersion.minor() == releaseVersion2.minor();
                    }
                    if (modVersion3 != null && modVersion.compareTo(modVersion3) >= 0) {
                        this._criticalUpdate = Boolean.parseBoolean(modVersion3.description());
                        this._criticalUpdate &= this._newVerAvailable;
                    }
                }
                if (this._criticalUpdate) {
                    this._mod.getLogger().info("This update has been marked as CRITICAL and will ignore notification suppression.");
                }
            }
        }
        catch (Exception exception) {
            Level level = Level.WARN;
            String string = this._mod.getClass().getPackage().getName();
            int n = string.indexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (string.equals("cofh") || string.equals("powercrystals")) {
                level = Level.ERROR;
            }
            this._mod.getLogger().log(level, AbstractLogger.CATCHING_MARKER, "Update check for " + this._mod.getModName() + " failed.", (Throwable)exception);
        }
        this._checkComplete = true;
    }

    public boolean checkComplete() {
        return this._checkComplete;
    }

    public boolean isCriticalUpdate() {
        return this._criticalUpdate;
    }

    public boolean newVersionAvailable() {
        return this._newVerAvailable;
    }

    public ModVersion newVersion() {
        return this._newVer;
    }
}

