/*
 * Decompiled with CFR 0.152.
 */
package irclib;

import cofh.plugin.ForgeIRC;
import irclib.Base64;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IRCLib
extends Thread {
    protected boolean bConnected;
    protected List<String> lChannel = new ArrayList<String>();
    protected String sServer;
    protected String sNick;
    protected String sName = "sdIRC";
    protected String sUser = "sdIRC";
    protected String sKey = "";
    protected String SASLUser = "";
    protected String SASLPass = "";
    protected Integer iPort;
    protected Socket socket;
    public BufferedWriter out;
    public BufferedReader in;

    public boolean connect(String string, Integer n) throws IOException {
        if (this.sNick == null) {
            return false;
        }
        if (this.bConnected) {
            return false;
        }
        this.socket = new Socket(string, (int)n);
        this.bConnected = true;
        this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.start();
        if (!this.SASLUser.isEmpty() && !this.SASLPass.isEmpty()) {
            this.out.write("CAP REQ :sasl\n");
        }
        if (!this.sKey.isEmpty()) {
            this.out.write("PASS " + this.sKey + "\n");
        }
        this.out.write("USER " + this.sUser + " * * :" + this.sName + "\n");
        this.out.write("NICK " + this.sNick + "\n");
        this.out.flush();
        return true;
    }

    public boolean connect(String string, Integer n, String string2) throws IOException {
        this.sNick = string2;
        return this.connect(string, n);
    }

    public boolean connect(String string, Integer n, String string2, String string3) throws IOException {
        this.sNick = string2;
        this.sKey = string3;
        return this.connect(string, n);
    }

    public void close() throws IOException {
        this.bConnected = false;
        this.socket.close();
    }

    public String getServer() {
        return this.bConnected ? this.sServer : null;
    }

    public String getNick() {
        return this.sNick;
    }

    public boolean setNick(String string) {
        if (this.bConnected) {
            this.sNick = string;
            this.sendRaw("NICK :" + string);
            return true;
        }
        this.sNick = string;
        return true;
    }

    public String getUser() {
        return this.sUser;
    }

    public boolean setUser(String string) {
        if (this.bConnected) {
            return false;
        }
        this.sUser = string;
        return true;
    }

    public boolean setInfo(String string) {
        if (this.bConnected) {
            return false;
        }
        this.sName = string;
        return true;
    }

    public void setSASLUser(String string) {
        this.SASLUser = string;
    }

    public void setSASLPass(String string) {
        this.SASLPass = string;
    }

    public List<String> getChannels() {
        return this.lChannel;
    }

    public boolean sendRaw(String string) {
        if (this.bConnected) {
            try {
                this.out.write(string + "\n");
                this.out.flush();
                return true;
            }
            catch (IOException iOException) {
                this.bConnected = false;
                return false;
            }
        }
        return false;
    }

    protected Matcher parseMask(String string) {
        Matcher matcher = Pattern.compile(":(.*)!(.*)@(.*)").matcher(string);
        return matcher.matches() ? matcher : null;
    }

    protected void process(String string) {
        if (string.toUpperCase().startsWith("PING ")) {
            this.sendRaw("PONG " + string.substring(5));
        } else if (string.toUpperCase().startsWith("AUTHENTICATE +")) {
            this.sendRaw("AUTHENTICATE " + this.getSASL(this.SASLUser, this.SASLPass));
        } else {
            String[] stringArray = string.split(" ", 3);
            this.processCommand(stringArray[1], string);
        }
    }

    protected void processCommand(String string, String string2) {
        String[] stringArray = string2.split(" ");
        if (string.toUpperCase().trim().equals("004")) {
            this.onConnected();
        } else if (string.toUpperCase().trim().equals("433")) {
            this.setNick(this.sNick + "_");
        } else if (string.toUpperCase().equals("CAP")) {
            if (stringArray[3].equals("ACK")) {
                this.sendRaw("AUTHENTICATE PLAIN");
            }
        } else if (string.toUpperCase().trim().equals("903") || string.toUpperCase().trim().equals("904") || string.toUpperCase().trim().equals("905") || string.toUpperCase().trim().equals("906") || string.toUpperCase().trim().equals("907")) {
            this.sendRaw("CAP END");
        } else if (!string.toUpperCase().trim().equals("432")) {
            if (string.toUpperCase().trim().equals("NICK")) {
                this.sNick = stringArray[2].replaceFirst(":", "");
                String string3 = stringArray[0].split("!")[0].replaceFirst(":", "");
                this.onNick(string3, this.sNick);
            } else if (string.toUpperCase().trim().equals("JOIN")) {
                String string4;
                Matcher matcher = this.parseMask(stringArray[0]);
                String string5 = string4 = matcher == null ? stringArray[0].replaceFirst(":", "") : matcher.group(1);
                if (matcher == null) {
                    this.onJoin(string4, stringArray[2]);
                } else {
                    if (matcher.group(1).equals(this.sNick)) {
                        this.lChannel.add(stringArray[2]);
                    }
                    this.onJoin(matcher.group(1), matcher.group(2), matcher.group(3), stringArray[2]);
                }
            } else if (string.toUpperCase().trim().equals("PART")) {
                String string6;
                Matcher matcher = this.parseMask(stringArray[0]);
                String string7 = string6 = matcher == null ? stringArray[0].replaceFirst(":", "") : matcher.group(1);
                if (matcher.group(1).equals(this.sNick)) {
                    this.lChannel.remove(stringArray[2]);
                }
                String string8 = string2.split(" ", 4).length > 3 ? string2.split(" ", 4)[3].replaceFirst(":", "") : null;
                this.onPart(matcher.group(1), matcher.group(2), matcher.group(3), stringArray[2], string8);
            } else if (string.toUpperCase().trim().equals("KICK")) {
                String string9;
                Matcher matcher = this.parseMask(stringArray[0]);
                String string10 = string9 = matcher == null ? stringArray[0].replaceFirst(":", "") : matcher.group(1);
                if (matcher == null) {
                    this.onKick(string9, stringArray[3], stringArray[2], stringArray[4]);
                } else {
                    if (matcher.group(1).equals(this.sNick)) {
                        this.lChannel.remove(stringArray[2]);
                    }
                    this.onKick(matcher.group(1), matcher.group(2), matcher.group(3), stringArray[3], stringArray[2], stringArray[4]);
                }
            } else if (string.toUpperCase().trim().equals("QUIT")) {
                Matcher matcher = this.parseMask(stringArray[0]);
                this.onQuit(matcher.group(1), matcher.group(2), matcher.group(3), string2.split(" ", 3)[2].replaceFirst(":", ""));
            } else if (string.toUpperCase().trim().equals("PRIVMSG")) {
                String string11;
                Matcher matcher = this.parseMask(stringArray[0]);
                String string12 = string11 = matcher == null ? stringArray[0].replaceFirst(":", "") : matcher.group(1);
                if (string2.split(" ", 4)[3].replaceFirst(":", "").startsWith(Character.toString('\u0001'))) {
                    if (matcher == null) {
                        this.processCTCP(string11, stringArray[2], string2.split(" ", 4)[3].replaceFirst(":", "").substring(1, string2.split(" ", 4)[3].replaceFirst(":", "").length() - 1));
                    } else {
                        this.processCTCP(matcher.group(1), matcher.group(2), matcher.group(3), stringArray[2], string2.split(" ", 4)[3].replaceFirst(":", "").substring(1, string2.split(" ", 4)[3].replaceFirst(":", "").length() - 1));
                    }
                } else if (matcher == null) {
                    List<String> list = ForgeIRC.onMessage(string11, stringArray[2], string2.split(" ", 4)[3].replaceFirst(":", ""));
                    if (list == null) {
                        this.onMessage(string11, stringArray[2], string2.split(" ", 4)[3].replaceFirst(":", ""));
                    } else {
                        for (String string13 : list) {
                            this.sendMessage(stringArray[2], string13);
                        }
                    }
                } else {
                    List<String> list = ForgeIRC.onMessage(matcher.group(1), matcher.group(2), matcher.group(3), stringArray[2], string2.split(" ", 4)[3].replaceFirst(":", ""));
                    if (list == null) {
                        this.onMessage(matcher.group(1), matcher.group(2), matcher.group(3), stringArray[2], string2.split(" ", 4)[3].replaceFirst(":", ""));
                    } else {
                        for (String string14 : list) {
                            this.sendMessage(stringArray[2], string14);
                        }
                    }
                }
            } else if (string.toUpperCase().trim().equals("NOTICE")) {
                String string15;
                Matcher matcher = this.parseMask(stringArray[0]);
                String string16 = string15 = matcher == null ? stringArray[0].replaceFirst(":", "") : matcher.group(1);
                if (matcher == null) {
                    this.onNotice(string15, stringArray[2], string2.split(" ", 4)[3].replaceFirst(":", ""));
                } else {
                    this.onNotice(matcher.group(1), matcher.group(2), matcher.group(3), stringArray[2], string2.split(" ", 4)[3].replaceFirst(":", ""));
                }
            }
        }
    }

    public void processCTCP(String string, String string2, String string3, String string4, String string5) {
        String[] stringArray = string5.split(" ", 2);
        if (stringArray[0].equals("ACTION")) {
            this.onAction(string, string2, string3, string4, stringArray[1]);
        } else {
            this.onCTCP(string, string2, string3, string4, string5);
        }
    }

    public void processCTCP(String string, String string2, String string3) {
        String[] stringArray = string3.split(" ", 2);
        if (stringArray[0].equals("ACTION")) {
            this.onAction(string, string2, stringArray[1]);
        } else {
            this.onCTCP(string, string2, string3);
        }
    }

    public String getSASL(String string, String string2) {
        return Base64.encode(string + Character.toString('\u0000') + string + Character.toString('\u0000') + string2);
    }

    @Override
    public void run() {
        try {
            String string = null;
            while (this.in != null && (string = this.in.readLine()) != null) {
                this.process(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void joinChannel(String string) {
        this.sendRaw("JOIN " + string);
    }

    public void joinChannel(String string, String string2) {
        this.sendRaw("JOIN " + string + " " + string2);
    }

    public void partChannel(String string) {
        this.sendRaw("PART " + string);
    }

    public void sendMessage(String string, String string2) {
        this.sendRaw("PRIVMSG " + string + " :" + string2);
    }

    public void sendAction(String string, String string2) {
        this.sendCTCP(string, "ACTION " + string2);
    }

    public void sendCTCP(String string, String string2) {
        this.sendRaw("PRIVMSG " + string + " :" + Character.toString('\u0001') + string2 + Character.toString('\u0001'));
    }

    public void sendCTCPReply(String string, String string2) {
        this.sendRaw("NOTICE " + string + " :" + Character.toString('\u0001') + string2 + Character.toString('\u0001'));
    }

    public void onConnected() {
    }

    public void onNick(String string, String string2) {
    }

    public void onJoin(String string, String string2, String string3, String string4) {
    }

    public void onJoin(String string, String string2) {
    }

    public void onPart(String string, String string2, String string3, String string4, String string5) {
    }

    public void onPart(String string, String string2, String string3) {
    }

    public void onKick(String string, String string2, String string3, String string4, String string5, String string6) {
    }

    public void onKick(String string, String string2, String string3, String string4) {
    }

    public void onQuit(String string, String string2, String string3, String string4) {
    }

    public void onCTCP(String string, String string2, String string3, String string4, String string5) {
    }

    public void onCTCP(String string, String string2, String string3) {
    }

    public void onAction(String string, String string2, String string3) {
    }

    public void onAction(String string, String string2, String string3, String string4, String string5) {
    }

    public void onMessage(String string, String string2, String string3, String string4, String string5) {
    }

    public void onMessage(String string, String string2, String string3) {
    }

    public void onNotice(String string, String string2, String string3, String string4, String string5) {
    }

    public void onNotice(String string, String string2, String string3) {
    }
}

