/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.CoFHCore;
import cofh.api.tileentity.ISecurable;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class TabSecurity
extends TabBase {
    public static boolean enable;
    public static int defaultSide;
    public static int defaultHeaderColor;
    public static int defaultSubHeaderColor;
    public static int defaultTextColor;
    public static int defaultBackgroundColor;
    ISecurable myContainer;
    String myPlayer;

    public static void initialize() {
        String string = "tab.security";
        defaultSide = MathHelper.clampI(CoFHCore.configClient.get(string, "Side", defaultSide), 0, 1);
        defaultHeaderColor = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorHeader", defaultHeaderColor), 0, 0xFFFFFF);
        defaultSubHeaderColor = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorSubHeader", defaultSubHeaderColor), 0, 0xFFFFFF);
        defaultTextColor = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorText", defaultTextColor), 0, 0xFFFFFF);
        defaultBackgroundColor = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorBackground", defaultBackgroundColor), 0, 0xFFFFFF);
        CoFHCore.configClient.save();
    }

    public TabSecurity(GuiBase guiBase, ISecurable iSecurable, String string) {
        this(guiBase, defaultSide, iSecurable, string);
    }

    public TabSecurity(GuiBase guiBase, int n, ISecurable iSecurable, String string) {
        super(guiBase, n);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.myContainer = iSecurable;
        this.myPlayer = string;
    }

    @Override
    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        this.drawBackground();
        if (this.myContainer.getAccess().isPublic()) {
            this.drawTabIcon("IconAccessPublic");
        } else if (this.myContainer.getAccess().isRestricted()) {
            this.drawTabIcon("IconAccessFriends");
        } else if (this.myContainer.getAccess().isPrivate()) {
            this.drawTabIcon("IconAccessPrivate");
        }
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_78261_a(StringHelper.localize("info.cofh.security"), this.posXOffset() + 18, this.posY + 6, this.headerColor);
        this.getFontRenderer().func_78261_a(StringHelper.localize("info.cofh.accessMode") + ":", this.posXOffset() + 6, this.posY + 42, this.subheaderColor);
        if (this.myContainer.getAccess().isPublic()) {
            this.gui.drawButton("IconAccessPublic", this.posX() + 28, this.posY + 20, 1, 1);
            this.gui.drawButton("IconAccessFriends", this.posX() + 48, this.posY + 20, 1, 0);
            this.gui.drawButton("IconAccessPrivate", this.posX() + 68, this.posY + 20, 1, 0);
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.accessPublic"), this.posXOffset() + 14, this.posY + 54, this.textColor);
        } else if (this.myContainer.getAccess().isRestricted()) {
            this.gui.drawButton("IconAccessPublic", this.posX() + 28, this.posY + 20, 1, 0);
            this.gui.drawButton("IconAccessFriends", this.posX() + 48, this.posY + 20, 1, 1);
            this.gui.drawButton("IconAccessPrivate", this.posX() + 68, this.posY + 20, 1, 0);
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.accessRestricted"), this.posXOffset() + 14, this.posY + 54, this.textColor);
        } else if (this.myContainer.getAccess().isPrivate()) {
            this.gui.drawButton("IconAccessPublic", this.posX() + 28, this.posY + 20, 1, 0);
            this.gui.drawButton("IconAccessFriends", this.posX() + 48, this.posY + 20, 1, 0);
            this.gui.drawButton("IconAccessPrivate", this.posX() + 68, this.posY + 20, 1, 1);
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.accessPrivate"), this.posXOffset() + 14, this.posY + 54, this.textColor);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.owner") + ": " + this.myContainer.getOwnerName());
            return;
        }
        int n = this.gui.getMouseX() - this.currentShiftX;
        int n2 = this.gui.getMouseY() - this.currentShiftY;
        if (28 <= n && n < 44 && 20 <= n2 && n2 < 36) {
            list.add(StringHelper.localize("info.cofh.accessPublic"));
        } else if (48 <= n && n < 64 && 20 <= n2 && n2 < 36) {
            list.add(StringHelper.localize("info.cofh.accessRestricted"));
        } else if (68 <= n && n < 84 && 20 <= n2 && n2 < 36) {
            list.add(StringHelper.localize("info.cofh.accessPrivate"));
        }
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        if (!this.myPlayer.equals(this.myContainer.getOwnerName())) {
            return true;
        }
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == TabBase.LEFT) {
            n += this.currentWidth;
        }
        if ((n -= this.currentShiftX) < 24 || n >= 88 || (n2 -= this.currentShiftY) < 16 || n2 >= 40) {
            return false;
        }
        if (28 <= n && n < 44 && 20 <= n2 && n2 < 36) {
            if (!this.myContainer.getAccess().isPublic()) {
                this.myContainer.setAccess(ISecurable.AccessMode.PUBLIC);
                GuiBase.playSound("random.click", 1.0f, 0.4f);
            }
        } else if (48 <= n && n < 64 && 20 <= n2 && n2 < 36) {
            if (!this.myContainer.getAccess().isRestricted()) {
                this.myContainer.setAccess(ISecurable.AccessMode.RESTRICTED);
                GuiBase.playSound("random.click", 1.0f, 0.6f);
            }
        } else if (68 <= n && n < 84 && 20 <= n2 && n2 < 36 && !this.myContainer.getAccess().isPrivate()) {
            this.myContainer.setAccess(ISecurable.AccessMode.PRIVATE);
            GuiBase.playSound("random.click", 1.0f, 0.8f);
        }
        return true;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float f = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float f2 = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float f3 = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
        this.gui.func_73729_b(this.posX() + 24, this.posY + 16, 16, 20, 64, 24);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void setFullyOpen() {
        if (!this.myPlayer.equals(this.myContainer.getOwnerName())) {
            return;
        }
        super.setFullyOpen();
    }

    static {
        defaultSide = 1;
        defaultHeaderColor = 14797103;
        defaultSubHeaderColor = 11186104;
        defaultTextColor = 0;
        defaultBackgroundColor = 0x888888;
    }
}

