/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.lib.util.helpers.ItemHelper;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;

public abstract class ItemToolAdv
extends ItemTool {
    public String repairIngot = "";
    private final TLinkedHashSet<String> toolClasses = new TLinkedHashSet();
    private final Set<String> immutableClasses = Collections.unmodifiableSet(this.toolClasses);
    protected THashSet<Block> effectiveBlocks = new THashSet();
    protected THashSet<Material> effectiveMaterials = new THashSet();
    protected int harvestLevel = -1;

    public ItemToolAdv(float f, Item.ToolMaterial toolMaterial) {
        super(f, toolMaterial, null);
    }

    public ItemToolAdv(float f, Item.ToolMaterial toolMaterial, int n) {
        this(f, toolMaterial);
        this.harvestLevel = n;
    }

    public ItemToolAdv setRepairIngot(String string) {
        this.repairIngot = string;
        return this;
    }

    protected void addToolClass(String string) {
        this.toolClasses.add((Object)string);
    }

    protected THashSet<Block> getEffectiveBlocks(ItemStack itemStack) {
        return this.effectiveBlocks;
    }

    protected THashSet<Material> getEffectiveMaterials(ItemStack itemStack) {
        return this.effectiveMaterials;
    }

    protected boolean isClassValid(String string, ItemStack itemStack) {
        return true;
    }

    protected float getEfficiency(ItemStack itemStack) {
        return this.field_77864_a;
    }

    protected int getHarvestLevel(ItemStack itemStack, int n) {
        return n;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.isOreNameEqual(itemStack2, this.repairIngot);
    }

    public boolean func_77616_k(ItemStack itemStack) {
        return true;
    }

    public float func_150893_a(ItemStack itemStack, Block block) {
        return this.getEffectiveMaterials(itemStack).contains((Object)block.func_149688_o()) || this.getEffectiveBlocks(itemStack).contains((Object)block) ? this.getEfficiency(itemStack) : 1.0f;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return this.func_150893_a(itemStack, block) > 1.0f;
    }

    protected void harvestBlock(World world, int n, int n2, int n3, EntityPlayer entityPlayer) {
        Block block = world.func_147439_a(n, n2, n3);
        if (block.func_149712_f(world, n, n2, n3) < 0.0f) {
            return;
        }
        int n4 = world.func_72805_g(n, n2, n3);
        if (block.canHarvestBlock(entityPlayer, n4)) {
            block.func_149636_a(world, entityPlayer, n, n2, n3, n4);
        }
        world.func_147468_f(n, n2, n3);
    }

    protected boolean isValidHarvestMaterial(ItemStack itemStack, World world, int n, int n2, int n3) {
        return this.getEffectiveMaterials(itemStack).contains((Object)world.func_147439_a(n, n2, n3).func_149688_o());
    }

    public int getHarvestLevel(ItemStack itemStack, String string) {
        if (this.harvestLevel != -1) {
            return this.harvestLevel;
        }
        int n = super.getHarvestLevel(itemStack, string);
        if (n == -1 && this.isClassValid(string, itemStack) && this.toolClasses.contains((Object)string)) {
            n = this.field_77862_b.func_77996_d();
        }
        return this.getHarvestLevel(itemStack, n);
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        return this.toolClasses.isEmpty() ? super.getToolClasses(itemStack) : this.immutableClasses;
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int n) {
        for (String string : this.getToolClasses(itemStack)) {
            int n2 = this.getHarvestLevel(itemStack, string);
            if (!string.equals(block.getHarvestTool(n)) || block.getHarvestLevel(n) >= n2) continue;
            return this.getEfficiency(itemStack);
        }
        return super.getDigSpeed(itemStack, block, n);
    }
}

