/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FireworksHelper {
    public static ItemStack getRandomFirework() {
        Random random = new Random();
        Firework firework = new Firework();
        int n = random.nextInt(4);
        switch (n) {
            case 0: 
            case 2: {
                firework.setFlicker();
                if (n == 0) break;
            }
            case 1: {
                firework.setTrail();
            }
        }
        int n2 = random.nextInt(5);
        firework.setType(n2);
        for (int i = 0; i <= random.nextInt(6); ++i) {
            Color color = new Color(Color.HSBtoRGB(random.nextFloat() * 360.0f, random.nextFloat() * 0.15f + 0.8f, 0.85f));
            firework.addColor(color.getRed(), color.getGreen(), color.getBlue());
        }
        return firework.getStack();
    }

    public static class Firework {
        private int flightDuration = 0;
        private boolean flicker = false;
        private boolean trail = false;
        private ArrayList<Integer> colors = new ArrayList();
        private FireworkType type = FireworkType.BALL;

        public Firework setFlightDuration(int n) {
            if (n >= 0 && n <= 3) {
                this.flightDuration = n;
            }
            return this;
        }

        public Firework setFlicker() {
            this.flicker = true;
            return this;
        }

        public Firework setTrail() {
            this.trail = true;
            return this;
        }

        public Firework setType(FireworkType fireworkType) {
            this.type = fireworkType;
            return this;
        }

        public Firework setType(int n) {
            if (n >= 0 && n <= 4) {
                this.setType(FireworkType.values()[n]);
            }
            return this;
        }

        public Firework addColor(int n, int n2, int n3) {
            this.colors.add((n << 16) + (n2 << 8) + n3);
            return this;
        }

        public ItemStack getStack() {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            NBTTagList nBTTagList = new NBTTagList();
            nBTTagList.func_74742_a((NBTBase)this.getNBT());
            nBTTagCompound2.func_74774_a("Flight", (byte)this.flightDuration);
            nBTTagCompound2.func_74782_a("Explosions", (NBTBase)nBTTagList);
            nBTTagCompound.func_74782_a("Fireworks", (NBTBase)nBTTagCompound2);
            ItemStack itemStack = new ItemStack(Items.field_151152_bP);
            itemStack.func_77982_d(nBTTagCompound);
            return itemStack;
        }

        private NBTTagCompound getNBT() {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74757_a("Flicker", this.flicker);
            nBTTagCompound.func_74757_a("Trail", this.trail);
            nBTTagCompound.func_74774_a("Type", (byte)this.type.ordinal());
            int[] nArray = new int[this.colors.size()];
            for (int i = 0; i < this.colors.size(); ++i) {
                nArray[i] = this.colors.get(i);
            }
            nBTTagCompound.func_74783_a("Colors", nArray);
            return nBTTagCompound;
        }
    }

    public static enum FireworkType {
        BALL,
        LARGE_BALL,
        STAR,
        CREEPER,
        BURST;

    }
}

