/*
 * Decompiled with CFR 0.152.
 */
package cofh.plugin;

import cofh.CoFHCore;
import cofh.core.util.CoreUtils;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ForgeIRC {
    private static DecimalFormat floatfmt = new DecimalFormat("##0.00");

    public static List<String> onMessage(String string, String string2, String string3, String string4, String string5) {
        String[] stringArray;
        if (CoreUtils.isServer() && (stringArray = string5.split(" ", 3))[0].equals("!tps")) {
            return ForgeIRC.commandTps(stringArray);
        }
        return null;
    }

    static String colorNick(String string, String string2, String string3) {
        if (string.toLowerCase().equals("zeldokavira") || string.toLowerCase().equals("zeldo")) {
            return "\u00a7f" + string + "\u00a7r";
        }
        if (string.toLowerCase().equals("kinglemmingcofh") || string.toLowerCase().equals("kinglemming") || string.toLowerCase().equals("king_lemming")) {
            return "\u00a71" + string + "\u00a7r";
        }
        if (string.toLowerCase().equals("jadedcat")) {
            return "\u00a75" + string + "\u00a7r";
        }
        if (string.toLowerCase().equals("morvelaira")) {
            return "\u00a7d" + string + "\u00a7r";
        }
        return string;
    }

    public static List<String> onMessage(String string, String string2, String string3) {
        return null;
    }

    public static List<String> commandTps(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (stringArray.length < 2) {
            double d = ForgeIRC.getTps(null);
            double d2 = ForgeIRC.getTickMs(null);
            linkedList.add("Overall: " + floatfmt.format(d) + " TPS/" + floatfmt.format(d2) + "MS (" + (int)(d / 20.0 * 100.0) + "%)");
            for (WorldServer worldServer : CoFHCore.server.field_71305_c) {
                d = ForgeIRC.getTps((World)worldServer);
                d2 = ForgeIRC.getTickMs((World)worldServer);
                linkedList.add(worldServer.field_73011_w.func_80007_l() + " [" + worldServer.field_73011_w.field_76574_g + "]: " + floatfmt.format(d) + " TPS/" + floatfmt.format(d2) + "MS (" + (int)(d / 20.0 * 100.0) + "%)");
            }
        } else if (stringArray[1].toLowerCase().charAt(0) == 'o') {
            double d = ForgeIRC.getTickMs(null);
            double d3 = ForgeIRC.getTps(null);
            linkedList.add("Overall server tick");
            linkedList.add("\u00a7r\u00a7r\u00a7rTPS: " + floatfmt.format(d3) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(d3 / 20.0 * 100.0) + "%)");
            linkedList.add("\u00a7r\u00a7r\u00a7rTick time: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms");
        } else if (stringArray[1].toLowerCase().charAt(0) == 'a') {
            double d = ForgeIRC.getTickMs(null);
            double d4 = ForgeIRC.getTps(null);
            linkedList.add("Overall server tick");
            linkedList.add("\u00a7r\u00a7r\u00a7rTPS: " + floatfmt.format(d4) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(d4 / 20.0 * 100.0) + "%)");
            linkedList.add("\u00a7r\u00a7r\u00a7rTick time: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms");
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (WorldServer worldServer : CoFHCore.server.field_71305_c) {
                n += worldServer.func_72863_F().func_73152_e();
                n2 += worldServer.field_72996_f.size();
                n3 += worldServer.field_147482_g.size();
                ++n4;
            }
            linkedList.add("\u00a7r\u00a7r\u00a7rTotal Loaded Worlds/Chunks: " + n4 + "/" + n);
            linkedList.add("\u00a7r\u00a7r\u00a7rTotal Entities/TileEntities: " + n2 + "/" + n3);
        } else {
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Throwable throwable) {
                linkedList.add("");
                return linkedList;
            }
            WorldServer worldServer = CoFHCore.server.func_71218_a(n);
            if (worldServer == null) {
                throw new PlayerNotFoundException("World not found", new Object[0]);
            }
            double d = ForgeIRC.getTickMs((World)worldServer);
            double d5 = ForgeIRC.getTps((World)worldServer);
            linkedList.add("World " + worldServer.field_73011_w.field_76574_g + ": " + worldServer.field_73011_w.func_80007_l() + " - Loaded chunks: " + worldServer.func_72863_F().func_73152_e());
            linkedList.add("\u00a7r\u00a7r\u00a7rTPS: " + floatfmt.format(d5) + "/" + floatfmt.format(20L) + " TPS (" + (int)(d5 / 20.0 * 100.0) + "%) - Tick: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms");
            linkedList.add("\u00a7r\u00a7r\u00a7rEntities: " + worldServer.field_72996_f.size() + " - Tile entities: " + worldServer.field_147482_g.size());
        }
        return linkedList;
    }

    private static double getTickTimeSum(long[] lArray) {
        long l = 0L;
        if (lArray == null) {
            return 0.0;
        }
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i];
        }
        return l / (long)lArray.length;
    }

    private static double getTickMs(World world) {
        return ForgeIRC.getTickTimeSum(world == null ? CoFHCore.server.field_71311_j : (long[])CoFHCore.server.worldTickTimes.get(world.field_73011_w.field_76574_g)) * 1.0E-6;
    }

    private static double getTps(World world) {
        double d = 1000.0 / ForgeIRC.getTickMs(world);
        return d > 20.0 ? 20.0 : d;
    }
}

