/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.lighting.LC;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.Vertex5;
import cofh.repack.codechicken.lib.vec.Cuboid6;

public class BlockRenderer {
    public static FullBlock fullBlock = new FullBlock();
    private static BlockFace face = new BlockFace();

    public static void renderCuboid(Cuboid6 cuboid6, int n) {
        if (n == 63) {
            return;
        }
        CCRenderState.setModel(face);
        for (int i = 0; i < 6; ++i) {
            if ((n & 1 << i) != 0) continue;
            face.loadCuboidFace(cuboid6, i);
            CCRenderState.render();
        }
    }

    public static class FullBlock
    implements CCRenderState.IVertexSource {
        public Vertex5[] verts;
        public LC[] lightCoords;

        public FullBlock() {
            this.verts = CCModel.quadModel((int)24).generateBlock((int)0, (Cuboid6)Cuboid6.full).verts;
            this.lightCoords = new LC[24];
            for (int i = 0; i < 24; ++i) {
                this.lightCoords[i] = new LC().compute(this.verts[i].vec, i / 4);
            }
        }

        @Override
        public Vertex5[] getVertices() {
            return this.verts;
        }

        @Override
        public <T> T getAttributes(CCRenderState.VertexAttribute<T> vertexAttribute) {
            return (T)(vertexAttribute == CCRenderState.lightCoordAttrib ? this.lightCoords : null);
        }

        @Override
        public boolean hasAttribute(CCRenderState.VertexAttribute<?> vertexAttribute) {
            return vertexAttribute == CCRenderState.sideAttrib || vertexAttribute == CCRenderState.lightCoordAttrib;
        }

        @Override
        public void prepareVertex() {
            CCRenderState.side = CCRenderState.vertexIndex >> 2;
        }
    }

    public static class BlockFace
    implements CCRenderState.IVertexSource {
        public Vertex5[] verts = new Vertex5[]{new Vertex5(), new Vertex5(), new Vertex5(), new Vertex5()};
        public LC[] lightCoords = new LC[]{new LC(), new LC(), new LC(), new LC()};
        public boolean lcComputed = false;
        public int side;

        @Override
        public Vertex5[] getVertices() {
            return this.verts;
        }

        @Override
        public <T> T getAttributes(CCRenderState.VertexAttribute<T> vertexAttribute) {
            return (T)(vertexAttribute == CCRenderState.lightCoordAttrib && this.lcComputed ? this.lightCoords : null);
        }

        @Override
        public boolean hasAttribute(CCRenderState.VertexAttribute<?> vertexAttribute) {
            return vertexAttribute == CCRenderState.sideAttrib || vertexAttribute == CCRenderState.lightCoordAttrib && this.lcComputed;
        }

        @Override
        public void prepareVertex() {
            CCRenderState.side = this.side;
        }

        public BlockFace computeLightCoords() {
            if (!this.lcComputed) {
                for (int i = 0; i < 4; ++i) {
                    this.lightCoords[i].compute(this.verts[i].vec, this.side);
                }
                this.lcComputed = true;
            }
            return this;
        }

        public BlockFace loadCuboidFace(Cuboid6 cuboid6, int n) {
            double d = cuboid6.min.x;
            double d2 = cuboid6.max.x;
            double d3 = cuboid6.min.y;
            double d4 = cuboid6.max.y;
            double d5 = cuboid6.min.z;
            double d6 = cuboid6.max.z;
            this.side = n;
            this.lcComputed = false;
            switch (n) {
                case 0: {
                    double d7 = d;
                    double d8 = d5;
                    double d9 = d2;
                    double d10 = d6;
                    this.verts[0].set(d, d3, d6, d7, d10, 0);
                    this.verts[1].set(d, d3, d5, d7, d8, 0);
                    this.verts[2].set(d2, d3, d5, d9, d8, 0);
                    this.verts[3].set(d2, d3, d6, d9, d10, 0);
                    break;
                }
                case 1: {
                    double d11 = d;
                    double d12 = d5;
                    double d13 = d2;
                    double d14 = d6;
                    this.verts[0].set(d2, d4, d6, d13, d14, 1);
                    this.verts[1].set(d2, d4, d5, d13, d12, 1);
                    this.verts[2].set(d, d4, d5, d11, d12, 1);
                    this.verts[3].set(d, d4, d6, d11, d14, 1);
                    break;
                }
                case 2: {
                    double d15 = 1.0 - d;
                    double d16 = 1.0 - d4;
                    double d17 = 1.0 - d2;
                    double d18 = 1.0 - d3;
                    this.verts[0].set(d, d3, d5, d15, d18, 2);
                    this.verts[1].set(d, d4, d5, d15, d16, 2);
                    this.verts[2].set(d2, d4, d5, d17, d16, 2);
                    this.verts[3].set(d2, d3, d5, d17, d18, 2);
                    break;
                }
                case 3: {
                    double d19 = d;
                    double d20 = 1.0 - d4;
                    double d21 = d2;
                    double d22 = 1.0 - d3;
                    this.verts[0].set(d2, d3, d6, d21, d22, 3);
                    this.verts[1].set(d2, d4, d6, d21, d20, 3);
                    this.verts[2].set(d, d4, d6, d19, d20, 3);
                    this.verts[3].set(d, d3, d6, d19, d22, 3);
                    break;
                }
                case 4: {
                    double d23 = d5;
                    double d24 = 1.0 - d4;
                    double d25 = d6;
                    double d26 = 1.0 - d3;
                    this.verts[0].set(d, d3, d6, d25, d26, 4);
                    this.verts[1].set(d, d4, d6, d25, d24, 4);
                    this.verts[2].set(d, d4, d5, d23, d24, 4);
                    this.verts[3].set(d, d3, d5, d23, d26, 4);
                    break;
                }
                case 5: {
                    double d27 = 1.0 - d5;
                    double d28 = 1.0 - d4;
                    double d29 = 1.0 - d6;
                    double d30 = 1.0 - d3;
                    this.verts[0].set(d2, d3, d5, d27, d30, 5);
                    this.verts[1].set(d2, d4, d5, d27, d28, 5);
                    this.verts[2].set(d2, d4, d6, d29, d28, 5);
                    this.verts[3].set(d2, d3, d6, d29, d30, 5);
                }
            }
            return this;
        }
    }
}

