/*
 * Decompiled with CFR 0.152.
 */
package defense.api;

import cpw.mods.fml.common.FMLCommonHandler;
import defense.api.IBlockFrequency;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import mekanism.api.Pos3D;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class FrequencyGrid {
    private static FrequencyGrid CLIENT_INSTANCE = new FrequencyGrid();
    private static FrequencyGrid SERVER_INSTANCE = new FrequencyGrid();
    private final Set<IBlockFrequency> frequencyGrid = Collections.newSetFromMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IBlockFrequency tileEntity) {
        Set<IBlockFrequency> set = this.frequencyGrid;
        synchronized (set) {
            try {
                Iterator<IBlockFrequency> it = this.frequencyGrid.iterator();
                while (it.hasNext()) {
                    IBlockFrequency frequency = it.next();
                    if (frequency == null) {
                        it.remove();
                        continue;
                    }
                    if (((TileEntity)frequency).func_145837_r()) {
                        it.remove();
                        continue;
                    }
                    if (!new Pos3D((TileEntity)frequency).equals((Object)new Pos3D((TileEntity)tileEntity))) continue;
                    it.remove();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.frequencyGrid.add(tileEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IBlockFrequency tileEntity) {
        Set<IBlockFrequency> set = this.frequencyGrid;
        synchronized (set) {
            this.frequencyGrid.remove(tileEntity);
            this.cleanUp();
        }
    }

    public Set<IBlockFrequency> get() {
        return this.frequencyGrid;
    }

    public Set<IBlockFrequency> get(int frequency) {
        HashSet<IBlockFrequency> set = new HashSet<IBlockFrequency>();
        for (IBlockFrequency tile : this.get()) {
            if (tile == null || ((TileEntity)tile).func_145837_r() || tile.getFrequency() != frequency) continue;
            set.add(tile);
        }
        return set;
    }

    public void cleanUp() {
        HashSet<IBlockFrequency> tilesToRemove = new HashSet<IBlockFrequency>();
        for (IBlockFrequency frequency : this.frequencyGrid) {
            if (frequency == null) {
                tilesToRemove.add(frequency);
                continue;
            }
            if (((TileEntity)frequency).func_145837_r()) {
                tilesToRemove.add(frequency);
                continue;
            }
            if (((TileEntity)frequency).func_145831_w().func_147438_o(((TileEntity)frequency).field_145851_c, ((TileEntity)frequency).field_145848_d, ((TileEntity)frequency).field_145849_e) == (TileEntity)frequency) continue;
            tilesToRemove.add(frequency);
        }
        for (IBlockFrequency tile : tilesToRemove) {
            this.unregister(tile);
        }
    }

    public Set<IBlockFrequency> get(World world, Pos3D position, int radius, int frequency) {
        HashSet<IBlockFrequency> set = new HashSet<IBlockFrequency>();
        for (IBlockFrequency tileEntity : this.get(frequency)) {
            if (((TileEntity)tileEntity).func_145831_w() != world) continue;
            Pos3D pos3D = new Pos3D((TileEntity)tileEntity);
            if (!(pos3D.distance(position) <= (double)radius)) continue;
            set.add(tileEntity);
        }
        return set;
    }

    public static void reinitiate() {
        CLIENT_INSTANCE = new FrequencyGrid();
        SERVER_INSTANCE = new FrequencyGrid();
    }

    public static FrequencyGrid instance() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient() ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }
}

