/*
 * Decompiled with CFR 0.152.
 */
package defense.client.gui;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import defense.client.gui.GuiBase;
import defense.common.Rectangle;
import defense.common.Vector2;
import defense.common.block.BlockMachine;
import defense.common.entity.EntityMissile;
import defense.common.tile.TileRadarStation;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.LangUtils;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiRadarStation
extends GuiBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("defense", "textures/gui/gui_radar.png");
    public static final ResourceLocation TEXTURE_RED_DOT = new ResourceLocation("defense", "textures/gui/reddot.png");
    public static final ResourceLocation TEXTURE_YELLOW_DOT = new ResourceLocation("defense", "textures/gui/yellowdot.png");
    public static final ResourceLocation TEXTURE_WHITE_DOT = new ResourceLocation("defense", "textures/gui/whitedot.png");
    private TileRadarStation tileEntity;
    private int containerPosX;
    private int containerPosY;
    private GuiTextField textFieldAlarmRange;
    private GuiTextField textFieldSafetyZone;
    private GuiTextField textFieldFrequency;
    private List<Vector2> missileCoords = new ArrayList<Vector2>();
    private Vector2 mouseOverCoords = new Vector2();
    private Vector2 mousePosition = new Vector2();
    private Vector2 radarCenter;
    private float radarMapRadius;
    private String info = "";
    private String info2;

    public GuiRadarStation(TileRadarStation tileEntity) {
        this.tileEntity = tileEntity;
        this.mouseOverCoords = new Vector2(this.tileEntity.field_145851_c, this.tileEntity.field_145849_e);
        this.field_147000_g = 166;
        this.field_146999_f = 256;
        this.radarCenter = new Vector2(this.containerPosX + this.field_146999_f / 3 - 14, this.containerPosY + this.field_147000_g / 2 + 4);
        this.radarMapRadius = 7.836991f;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.textFieldSafetyZone = new GuiTextField(this.field_146289_q, 210, 67, 30, 12);
        this.textFieldSafetyZone.func_146203_f(3);
        this.textFieldSafetyZone.func_146180_a(this.tileEntity.safetyRange + "");
        this.textFieldAlarmRange = new GuiTextField(this.field_146289_q, 210, 82, 30, 12);
        this.textFieldAlarmRange.func_146203_f(3);
        this.textFieldAlarmRange.func_146180_a(this.tileEntity.alarmRange + "");
        this.textFieldFrequency = new GuiTextField(this.field_146289_q, 155, 112, 50, 12);
        this.textFieldFrequency.func_146203_f(6);
        this.textFieldFrequency.func_146180_a(this.tileEntity.getFrequency() + "");
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b("\u00a77" + this.tileEntity.func_145825_b(), this.field_146999_f / 2 - 30, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.radar.coords"), 155, 18, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.misc.x") + " " + (int)Math.round(this.mouseOverCoords.x) + " " + LangUtils.localize((String)"gui.misc.z") + " " + (int)Math.round(this.mouseOverCoords.y), 155, 30, 0x404040);
        this.field_146289_q.func_78276_b("\u00a76" + this.info, 155, 42, 0x404040);
        this.field_146289_q.func_78276_b("\u00a74" + this.info2, 155, 54, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.radar.zoneSafe"), 152, 70, 0x404040);
        this.textFieldSafetyZone.func_146194_f();
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.radar.zoneAlarm"), 150, 85, 0x404040);
        this.textFieldAlarmRange.func_146194_f();
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.misc.freq"), 155, 100, 0x404040);
        this.textFieldFrequency.func_146194_f();
        String color = "\u00a74";
        String status = LangUtils.localize((String)"gui.misc.idle");
        if (this.tileEntity.getEnergy() >= 400.0) {
            color = "\u00a72";
            status = LangUtils.localize((String)"gui.radar.on");
        } else {
            status = LangUtils.localize((String)"gui.radar.nopower");
        }
        this.field_146289_q.func_78276_b(color + status, 155, 150, 0x404040);
    }

    public void func_73869_a(char par1, int par2) {
        ArrayList<Integer> data;
        super.func_73869_a(par1, par2);
        this.textFieldSafetyZone.func_146201_a(par1, par2);
        this.textFieldAlarmRange.func_146201_a(par1, par2);
        this.textFieldFrequency.func_146201_a(par1, par2);
        try {
            int newSafetyRadius;
            this.tileEntity.safetyRange = newSafetyRadius = Math.min(500, Math.max(0, Integer.parseInt(this.textFieldSafetyZone.func_146179_b())));
            data = new ArrayList<Integer>();
            data.add(2);
            data.add(this.tileEntity.safetyRange);
            Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this.tileEntity), data));
        }
        catch (NumberFormatException newSafetyRadius) {
            // empty catch block
        }
        try {
            int newAlarmRadius;
            this.tileEntity.alarmRange = newAlarmRadius = Math.min(500, Math.max(0, Integer.parseInt(this.textFieldAlarmRange.func_146179_b())));
            data = new ArrayList();
            data.add(3);
            data.add(this.tileEntity.alarmRange);
            Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this.tileEntity), data));
        }
        catch (NumberFormatException newAlarmRadius) {
            // empty catch block
        }
        try {
            this.tileEntity.setFrequency(Integer.parseInt(this.textFieldFrequency.func_146179_b()));
            ArrayList<Integer> data2 = new ArrayList<Integer>();
            data2.add(4);
            data2.add(this.tileEntity.getFrequency());
            Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this.tileEntity), data2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.textFieldAlarmRange.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
        this.textFieldSafetyZone.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
        this.textFieldFrequency.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.containerPosX = (this.field_146294_l - this.field_146999_f) / 2;
        this.containerPosY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(this.containerPosX, this.containerPosY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.radarCenter = new Vector2(this.containerPosX + this.field_146999_f / 3 - 10, this.containerPosY + this.field_147000_g / 2 + 4);
        this.radarMapRadius = 7.0422535f;
        this.info = "";
        this.info2 = "";
        if (this.tileEntity.getEnergy() >= 400.0) {
            Vector2 maxPosition;
            Vector2 minPosition;
            Vector2 position;
            int range = 4;
            for (Entity entity : this.tileEntity.detectedEntities) {
                position = new Vector2(this.radarCenter.x + (entity.field_70165_t - (double)this.tileEntity.field_145851_c) / (double)this.radarMapRadius, this.radarCenter.y - (entity.field_70161_v - (double)this.tileEntity.field_145849_e) / (double)this.radarMapRadius);
                if (entity instanceof EntityMissile) {
                    if (this.tileEntity.isMissileGoingToHit((EntityMissile)entity)) {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_RED_DOT);
                    } else {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_YELLOW_DOT);
                    }
                } else {
                    FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_YELLOW_DOT);
                }
                this.func_73729_b(position.intX(), position.intY(), 0, 0, 2, 2);
                minPosition = position.clone();
                minPosition.add(-range);
                maxPosition = position.clone();
                maxPosition.add(range);
                if (!new Rectangle(minPosition, maxPosition).isIn(this.mousePosition)) continue;
                this.info = entity.func_70005_c_();
                if (entity instanceof EntityPlayer) {
                    this.info = "\u00a71" + this.info;
                }
                if (!(entity instanceof EntityMissile) || ((EntityMissile)entity).targetVector == null) continue;
                this.info2 = "(" + (int)((EntityMissile)entity).targetVector.xPos + ", " + (int)((EntityMissile)entity).targetVector.zPos + ")";
            }
            range = 2;
            for (TileEntity jiQi : this.tileEntity.detectedTiles) {
                position = new Vector2(this.radarCenter.x + (double)((float)(jiQi.field_145851_c - this.tileEntity.field_145851_c) / this.radarMapRadius), this.radarCenter.y - (double)((float)(jiQi.field_145849_e - this.tileEntity.field_145849_e) / this.radarMapRadius));
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_WHITE_DOT);
                this.func_73729_b(position.intX(), position.intY(), 0, 0, 2, 2);
                minPosition = position.clone();
                minPosition.add(-range);
                maxPosition = position.clone();
                maxPosition.add(range);
                if (!new Rectangle(minPosition, maxPosition).isIn(this.mousePosition) || jiQi.func_145838_q() == null) continue;
                if (jiQi.func_145838_q() instanceof BlockMachine) {
                    this.info = BlockMachine.getJiQiMing(jiQi);
                    continue;
                }
                this.info = jiQi.func_145838_q().func_149732_F();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (Mouse.isInsideWindow() && Mouse.getEventButton() == -1) {
            this.mousePosition = new Vector2(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c, this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1);
            float difference = 500.0f / this.radarMapRadius;
            if (this.mousePosition.x > this.radarCenter.x - (double)difference && this.mousePosition.x < this.radarCenter.x + (double)difference && this.mousePosition.y > this.radarCenter.y - (double)difference && this.mousePosition.y < this.radarCenter.y + (double)difference) {
                int xDifference = (int)(this.mousePosition.x - this.radarCenter.x);
                int yDifference = (int)(this.mousePosition.y - this.radarCenter.y);
                int xBlockDistance = (int)((float)xDifference * this.radarMapRadius);
                int yBlockDistance = (int)((float)yDifference * this.radarMapRadius);
                this.mouseOverCoords = new Vector2(this.tileEntity.field_145851_c + xBlockDistance, this.tileEntity.field_145849_e - yBlockDistance);
            }
        }
        if (!this.textFieldSafetyZone.func_146206_l()) {
            this.textFieldSafetyZone.func_146180_a(this.tileEntity.safetyRange + "");
        }
        if (!this.textFieldAlarmRange.func_146206_l()) {
            this.textFieldAlarmRange.func_146180_a(this.tileEntity.alarmRange + "");
        }
    }
}

