/*
 * Decompiled with CFR 0.152.
 */
package defense.common;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import defense.api.IItemFrequency;
import defense.common.Settings;
import defense.common.entity.EntityMissile;
import defense.common.explosive.Explosive;
import defense.common.explosive.ExplosiveRegistry;
import defense.common.inventory.container.ContainerCruiseLauncher;
import defense.common.inventory.container.ContainerMissileCoordinator;
import defense.common.tile.TileCruiseLauncher;
import defense.common.tile.TileEMPTower;
import defense.common.tile.TileExplosive;
import defense.common.tile.TileLauncherBase;
import defense.common.tile.TileLauncherFrame;
import defense.common.tile.TileLauncherScreen;
import defense.common.tile.TileMissileCoordinator;
import defense.common.tile.TileRadarStation;
import java.util.List;
import mekanism.api.Pos3D;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.TileEntityContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CommonProxy
implements IGuiHandler {
    public void preInit() {
    }

    public void init() {
        GameRegistry.registerTileEntity(TileCruiseLauncher.class, (String)"CruiseLauncher");
        GameRegistry.registerTileEntity(TileLauncherBase.class, (String)"LauncherBase");
        GameRegistry.registerTileEntity(TileLauncherScreen.class, (String)"LauncherScreen");
        GameRegistry.registerTileEntity(TileLauncherFrame.class, (String)"LauncherFrame");
        GameRegistry.registerTileEntity(TileRadarStation.class, (String)"RadarStation");
        GameRegistry.registerTileEntity(TileEMPTower.class, (String)"EMPTower");
        GameRegistry.registerTileEntity(TileMissileCoordinator.class, (String)"MissileCoordinator");
        GameRegistry.registerTileEntity(TileExplosive.class, (String)"Explosive");
    }

    public void loadConfiguration() {
        Settings.initiate();
        for (Explosive explosive : ExplosiveRegistry.getExplosives()) {
            explosive.isDisabled = !Settings.CONFIGURATION.get("explosives", explosive.getUnlocalizedName(), true).getBoolean(true);
        }
        if (Settings.CONFIGURATION.hasChanged()) {
            Settings.CONFIGURATION.save();
        }
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof IItemFrequency) {
            return new ContainerNull(player, null);
        }
        if (tileEntity instanceof TileCruiseLauncher) {
            return new ContainerCruiseLauncher(player.field_71071_by, (TileCruiseLauncher)tileEntity);
        }
        if (tileEntity instanceof TileMissileCoordinator) {
            return new ContainerMissileCoordinator(player.field_71071_by, (TileMissileCoordinator)tileEntity);
        }
        if (tileEntity instanceof TileLauncherScreen || tileEntity instanceof TileRadarStation || tileEntity instanceof TileEMPTower || tileEntity instanceof TileLauncherBase || tileEntity instanceof TileMissileCoordinator) {
            return new ContainerNull(player, (TileEntityContainerBlock)tileEntity);
        }
        return null;
    }

    public boolean isFancyGraphicsEnabled() {
        return false;
    }

    public void spawnParticle(String name, World world, Pos3D position, float scale, double distance) {
        this.spawnParticle(name, world, position, 0.0, 0.0, 0.0, scale, distance);
    }

    public void spawnParticle(String name, World world, Pos3D position, double motionX, double motionY, double motionZ, float scale, double distance) {
        this.spawnParticle(name, world, position, motionX, motionY, motionZ, 1.0f, 1.0f, 1.0f, scale, distance);
    }

    public void spawnParticle(String name, World world, Pos3D position, double motionX, double motionY, double motionZ, float red, float green, float blue, float scale, double distance) {
    }

    public void playSound(EntityMissile missile) {
    }

    public int getParticleSetting() {
        return -1;
    }

    public List<Entity> getEntityFXs() {
        return null;
    }

    public void spawnShock(World world, Pos3D position, Pos3D target) {
    }

    public void spawnShock(World world, Pos3D startVec, Pos3D targetVec, int duration) {
    }
}

