/*
 * Decompiled with CFR 0.152.
 */
package defense.common.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import mekanism.api.Pos3D;
import mekanism.common.MekanismBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityFlyingBlock
extends Entity
implements IEntityAdditionalSpawnData {
    public Block block = null;
    public int metadata = 0;
    public float yawChange = 0.0f;
    public float pitchChange = 0.0f;
    public float gravity = 0.045f;

    public EntityFlyingBlock(World world) {
        super(world);
        this.field_70173_aa = 0;
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityFlyingBlock(World world, Pos3D position, Block b, int metadata) {
        super(world);
        this.field_70178_ae = true;
        this.field_70173_aa = 0;
        this.func_70105_a(0.98f, 0.98f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.func_70107_b(position.xPos + 0.5, position.yPos, position.zPos + 0.5);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.block = b;
        this.metadata = metadata;
    }

    public EntityFlyingBlock(World world, Pos3D position, Block b, int metadata, float gravity) {
        this(world, position, b, metadata);
        this.gravity = gravity;
    }

    public String func_70005_c_() {
        return "Flying Block";
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(Block.func_149682_b((Block)this.block));
        data.writeInt(this.metadata);
        data.writeFloat(this.gravity);
        data.writeFloat(this.yawChange);
        data.writeFloat(this.pitchChange);
    }

    public void readSpawnData(ByteBuf data) {
        this.block = Block.func_149729_e((int)data.readInt());
        this.metadata = data.readInt();
        this.gravity = data.readFloat();
        this.yawChange = data.readFloat();
        this.pitchChange = data.readFloat();
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (this.block == null) {
            this.func_70106_y();
            return;
        }
        if (this.field_70163_u > 400.0 || this.block == null || this.block == MekanismBlocks.BoundingBlock || this.block == Blocks.field_150326_M || this.block == Blocks.field_150358_i || this.block == Blocks.field_150356_k) {
            this.func_70106_y();
            return;
        }
        this.field_70181_x -= (double)this.gravity;
        if (this.field_70132_H) {
            this.func_145771_j(this.field_70165_t, (this.field_70121_D.field_72338_b + this.field_70121_D.field_72337_e) / 2.0, this.field_70161_v);
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.yawChange > 0.0f) {
            this.field_70177_z += this.yawChange;
            this.yawChange -= 2.0f;
        }
        if (this.pitchChange > 0.0f) {
            this.field_70125_A += this.pitchChange;
            this.pitchChange -= 2.0f;
        }
        if (this.field_70122_E && this.field_70173_aa > 20 || this.field_70173_aa > 2400) {
            this.setBlock();
            return;
        }
        ++this.field_70173_aa;
    }

    public void setBlock() {
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            this.field_70170_p.func_147465_d(i, j, k, this.block, this.metadata, 2);
        }
        this.func_70106_y();
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        if (par1Entity instanceof EntityLiving && this.block != null && !(this.block instanceof BlockLiquid) && (this.field_70159_w > 2.0 || this.field_70181_x > 2.0 || this.field_70179_y > 2.0)) {
            int damage = (int)(1.2 * (Math.abs(this.field_70159_w) + Math.abs(this.field_70181_x) + Math.abs(this.field_70179_y)));
            ((EntityLiving)par1Entity).func_70097_a(DamageSource.field_82729_p, (float)damage);
        }
        return null;
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("metadata", this.metadata);
        nbttagcompound.func_74768_a("blockID", Block.func_149682_b((Block)this.block));
        nbttagcompound.func_74776_a("gravity", this.gravity);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.metadata = nbttagcompound.func_74762_e("metadata");
        this.block = Block.func_149729_e((int)nbttagcompound.func_74762_e("blockID"));
        this.gravity = nbttagcompound.func_74760_g("gravity");
    }

    public float func_70053_R() {
        return 0.5f;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }
}

