/*
 * Decompiled with CFR 0.152.
 */
package defense.common.entity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import defense.api.ExplosionEvent;
import defense.api.ExplosiveType;
import defense.api.IExplosive;
import defense.api.IExplosiveContainer;
import defense.api.ILauncherContainer;
import defense.api.IMissile;
import defense.api.ITarget;
import defense.api.RadarRegistry;
import defense.common.DamageUtility;
import defense.common.DefenseTech;
import defense.common.DefenseTechItems;
import defense.common.Settings;
import defense.common.Vector2;
import defense.common.base.IChunkLoadHandler;
import defense.common.explosion.Explosion;
import defense.common.explosive.ExplosiveRegistry;
import defense.common.tile.TileCruiseLauncher;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

public class EntityMissile
extends Entity
implements IChunkLoadHandler,
IExplosiveContainer,
IEntityAdditionalSpawnData,
IMissile,
ITarget {
    public static final float SPEED = 0.012f;
    public boolean createdSound = false;
    public int explosiveID = 0;
    public int maxHeight = 200;
    public Pos3D targetVector = null;
    public Pos3D startPos = null;
    public Pos3D launcherPos = null;
    public boolean isExpoding = false;
    public int targetHeight = 0;
    public int feiXingTick = -1;
    public double deltaPathX;
    public double deltaPathY;
    public double deltaPathZ;
    public double flatDistance;
    public float missileFlightTime;
    public float acceleration;
    public float damage = 0.0f;
    public float max_damage = 10.0f;
    public int protectionTime = 2;
    private ForgeChunkManager.Ticket chunkTicket;
    public Entity lockedTarget;
    public boolean didTargetLockBefore = false;
    public int trackingVar = -1;
    public int missileCount = 0;
    public double daoDanGaoDu = 2.0;
    private boolean setExplode;
    private boolean setNormalExplode;
    public MissileType missileType = MissileType.MISSILE;
    public Pos3D xiaoDanMotion = new Pos3D();
    private double qiFeiGaoDu = 3.0;
    private final HashSet<Entity> ignoreEntity = new HashSet();
    public NBTTagCompound nbtData = new NBTTagCompound();
    final List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityMissile(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70155_l = 3.0;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public EntityMissile(World world, Pos3D startPos, Pos3D launcherPos, int explosiveId) {
        this(world);
        this.explosiveID = explosiveId;
        this.startPos = startPos;
        this.launcherPos = launcherPos;
        this.func_70107_b(this.startPos.xPos, this.startPos.yPos, this.startPos.zPos);
        this.func_70101_b(0.0f, 90.0f);
    }

    public EntityMissile(World world, Pos3D startPos, int explosiveId, float yaw, float pitch) {
        this(world);
        this.explosiveID = explosiveId;
        this.launcherPos = this.startPos = startPos;
        this.missileType = MissileType.LAUNCHER;
        this.protectionTime = 0;
        this.func_70107_b(this.startPos.xPos, this.startPos.yPos, this.startPos.zPos);
        this.func_70101_b(yaw, pitch);
    }

    public String func_70005_c_() {
        return ExplosiveRegistry.get(this.explosiveID).getMissileName();
    }

    public void writeSpawnData(ByteBuf data) {
        try {
            data.writeInt(this.explosiveID);
            data.writeInt(this.missileType.ordinal());
            data.writeDouble(this.startPos.xPos);
            data.writeDouble(this.startPos.yPos);
            data.writeDouble(this.startPos.zPos);
            data.writeInt((int)this.launcherPos.xPos);
            data.writeInt((int)this.launcherPos.yPos);
            data.writeInt((int)this.launcherPos.zPos);
            data.writeFloat(this.field_70177_z);
            data.writeFloat(this.field_70125_A);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.explosiveID = data.readInt();
            this.missileType = MissileType.values()[data.readInt()];
            this.startPos = new Pos3D(data.readDouble(), data.readDouble(), data.readDouble());
            this.launcherPos = new Pos3D((double)data.readInt(), (double)data.readInt(), (double)data.readInt());
            this.field_70177_z = data.readFloat();
            this.field_70125_A = data.readFloat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void launch(Pos3D target) {
        this.startPos = new Pos3D((Entity)this);
        this.targetVector = target;
        this.targetHeight = (int)this.targetVector.yPos;
        ((Explosion)ExplosiveRegistry.get(this.explosiveID)).launch(this);
        this.feiXingTick = 0;
        this.recalculatePath();
        this.field_70170_p.func_72956_a((Entity)this, "defense:missilelaunch", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        RadarRegistry.register(this);
        DefenseTech.LOGGER.info("Launching " + this.func_70005_c_() + " (" + this.func_145782_y() + ") from " + (int)this.startPos.xPos + ", " + (int)this.startPos.yPos + ", " + (int)this.startPos.zPos + " to " + (int)this.targetVector.xPos + ", " + (int)this.targetVector.yPos + ", " + (int)this.targetVector.zPos);
    }

    @Override
    public void launch(Pos3D target, int height) {
        this.qiFeiGaoDu = height;
        this.launch(target);
    }

    public EntityMissile ignore(Entity entity) {
        this.ignoreEntity.add(entity);
        return this;
    }

    public void recalculatePath() {
        if (this.targetVector != null) {
            this.deltaPathX = this.targetVector.xPos - this.startPos.xPos;
            this.deltaPathY = this.targetVector.yPos - this.startPos.yPos;
            this.deltaPathZ = this.targetVector.zPos - this.startPos.zPos;
            this.flatDistance = Vector2.distance(new Vector2(this.startPos), new Vector2(this.targetVector));
            this.maxHeight = 160 + (int)(this.flatDistance * 3.0);
            this.missileFlightTime = (float)Math.max(100.0, 2.0 * this.flatDistance) - (float)this.feiXingTick;
            this.acceleration = (float)this.maxHeight * 2.0f / (this.missileFlightTime * this.missileFlightTime);
        }
    }

    public void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.chunkLoaderInit(ForgeChunkManager.requestTicket((Object)DefenseTech.INSTANCE, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
    }

    @Override
    public void chunkLoaderInit(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.chunkTicket == null) {
                this.chunkTicket = ticket;
                this.chunkTicket.bindEntity((Entity)this);
                this.chunkTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void updateLoadChunk(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && Settings.LOAD_CHUNKS && this.chunkTicket != null) {
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ - 1));
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, ExplosiveType.AIR, ExplosiveRegistry.get(this.explosiveID));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (evt.isCanceled()) {
                if (this.feiXingTick >= 0) {
                    this.dropMissileAsItem();
                }
                this.func_70106_y();
                return;
            }
        } else if (!this.createdSound) {
            DefenseTech.proxy.playSound(this);
            this.createdSound = true;
        }
        try {
            if (this.field_70170_p.field_72995_K) {
                this.feiXingTick = this.field_70180_af.func_75679_c(16);
                int status = this.field_70180_af.func_75679_c(17);
                switch (status) {
                    case 1: {
                        this.setNormalExplode = true;
                        break;
                    }
                    case 2: {
                        this.setExplode = true;
                    }
                }
            } else {
                this.field_70180_af.func_75692_b(16, (Object)this.feiXingTick);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.setNormalExplode) {
            this.normalExplode();
            return;
        }
        if (this.setExplode) {
            this.explode();
            return;
        }
        if (this.feiXingTick >= 0) {
            RadarRegistry.register(this);
            if (!this.field_70170_p.field_72995_K) {
                if (this.missileType == MissileType.CruiseMissile || this.missileType == MissileType.LAUNCHER) {
                    if (this.feiXingTick == 0 && this.xiaoDanMotion != null) {
                        this.xiaoDanMotion = new Pos3D(this.deltaPathX / ((double)this.missileFlightTime * 0.3), this.deltaPathY / ((double)this.missileFlightTime * 0.3), this.deltaPathZ / ((double)this.missileFlightTime * 0.3));
                        this.field_70159_w = this.xiaoDanMotion.xPos;
                        this.field_70181_x = this.xiaoDanMotion.yPos;
                        this.field_70179_y = this.xiaoDanMotion.zPos;
                    }
                    this.field_70125_A = (float)(Math.atan(this.field_70181_x / Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
                    this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                    ((Explosion)ExplosiveRegistry.get(this.explosiveID)).update(this);
                    Block block = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                    if (this.protectionTime <= 0 && (!this.field_70170_p.func_147437_c((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) && !(block instanceof BlockLiquid) || this.field_70163_u > 1000.0 || this.field_70132_H || this.feiXingTick > 20000 || this.field_70159_w == 0.0 && this.field_70181_x == 0.0 && this.field_70179_y == 0.0)) {
                        this.setExplode();
                        return;
                    }
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                } else if (this.qiFeiGaoDu > 0.0) {
                    this.field_70181_x = 0.012f * (float)this.feiXingTick * (float)(this.feiXingTick / 2);
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.qiFeiGaoDu -= this.field_70181_x;
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    if (this.qiFeiGaoDu <= 0.0) {
                        this.field_70181_x = this.acceleration * (this.missileFlightTime / 2.0f);
                        this.field_70159_w = this.deltaPathX / (double)this.missileFlightTime;
                        this.field_70179_y = this.deltaPathZ / (double)this.missileFlightTime;
                    }
                } else {
                    Block blockBelow;
                    this.field_70181_x -= (double)this.acceleration;
                    this.field_70125_A = (float)(Math.atan(this.field_70181_x / Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
                    this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                    ((Explosion)ExplosiveRegistry.get(this.explosiveID)).update(this);
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    if (this.field_70132_H) {
                        this.explode();
                    }
                    if (this.targetHeight > 0 && this.field_70181_x < 0.0 && (blockBelow = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u - this.targetHeight, (int)this.field_70161_v)) != null) {
                        this.targetHeight = 0;
                        this.explode();
                    }
                }
            } else {
                this.field_70125_A = (float)(Math.atan(this.field_70181_x / Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
                this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            }
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            this.spawnMissileSmoke();
            --this.protectionTime;
            ++this.feiXingTick;
        } else if (this.missileType != MissileType.LAUNCHER) {
            ILauncherContainer launcher = this.getLauncher();
            if (launcher != null) {
                launcher.setContainingMissile(this);
                if (launcher instanceof TileCruiseLauncher) {
                    this.missileType = MissileType.CruiseMissile;
                    this.field_70145_X = true;
                    if (this.field_70170_p.field_72995_K) {
                        this.field_70177_z = -((TileCruiseLauncher)launcher).rotationYaw + 90.0f;
                        this.field_70125_A = ((TileCruiseLauncher)launcher).rotationPitch;
                    }
                    this.field_70163_u = ((TileCruiseLauncher)launcher).field_145848_d + 1;
                }
            } else {
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    @Override
    public ILauncherContainer getLauncher() {
        TileEntity tileEntity;
        if (this.launcherPos != null && (tileEntity = this.field_70170_p.func_147438_o((int)this.launcherPos.xPos, (int)this.launcherPos.yPos, (int)this.launcherPos.zPos)) != null && tileEntity instanceof ILauncherContainer && !tileEntity.func_145837_r()) {
            return (ILauncherContainer)tileEntity;
        }
        return null;
    }

    public boolean func_130002_c(EntityPlayer entityPlayer) {
        if ((Explosion)ExplosiveRegistry.get(this.explosiveID) != null && ((Explosion)ExplosiveRegistry.get(this.explosiveID)).onInteract(this, entityPlayer)) {
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n != entityPlayer)) {
            entityPlayer.func_70078_a((Entity)this);
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        if (this.missileFlightTime <= 0.0f && this.missileType == MissileType.MISSILE) {
            return this.field_70131_O;
        }
        if (this.missileType == MissileType.CruiseMissile) {
            return this.field_70131_O / 10.0f;
        }
        return (double)(this.field_70131_O / 2.0f) + this.field_70181_x;
    }

    private void spawnMissileSmoke() {
        if (this.field_70170_p.field_72995_K) {
            Pos3D position = new Pos3D((Entity)this);
            double distance = -this.daoDanGaoDu - (double)0.2f;
            Pos3D delta = new Pos3D();
            delta.yPos = Math.sin(Math.toRadians(this.field_70125_A)) * distance;
            double dH = Math.cos(Math.toRadians(this.field_70125_A)) * distance;
            delta.xPos = Math.sin(Math.toRadians(this.field_70177_z)) * dH;
            delta.zPos = Math.cos(Math.toRadians(this.field_70177_z)) * dH;
            position.translate(delta);
            this.field_70170_p.func_72869_a("flame", position.xPos, position.yPos, position.zPos, 0.0, 0.0, 0.0);
            DefenseTech.proxy.spawnParticle("missile_smoke", this.field_70170_p, position, 4.0f, 2.0);
            position.scale(1.0 - 0.001 * Math.random());
            DefenseTech.proxy.spawnParticle("missile_smoke", this.field_70170_p, position, 4.0f, 2.0);
            position.scale(1.0 - 0.001 * Math.random());
            DefenseTech.proxy.spawnParticle("missile_smoke", this.field_70170_p, position, 4.0f, 2.0);
            position.scale(1.0 - 0.001 * Math.random());
            DefenseTech.proxy.spawnParticle("missile_smoke", this.field_70170_p, position, 4.0f, 2.0);
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (this.ignoreEntity.contains(entity)) {
            return null;
        }
        if (!(entity instanceof EntityItem) && entity != this.field_70153_n && this.protectionTime <= 0) {
            if (entity instanceof EntityMissile) {
                ((EntityMissile)entity).setNormalExplode();
            }
            this.setExplode();
        }
        return null;
    }

    @Override
    public Pos3D getPredictedPosition(int t) {
        Pos3D guJiDiDian = new Pos3D((Entity)this);
        double tempMotionY = this.field_70181_x;
        if (this.feiXingTick > 20) {
            for (int i = 0; i < t; ++i) {
                if (this.missileType == MissileType.CruiseMissile || this.missileType == MissileType.LAUNCHER) {
                    guJiDiDian.xPos += this.xiaoDanMotion.xPos;
                    guJiDiDian.yPos += this.xiaoDanMotion.yPos;
                    guJiDiDian.zPos += this.xiaoDanMotion.zPos;
                    continue;
                }
                guJiDiDian.xPos += this.field_70159_w;
                guJiDiDian.yPos += tempMotionY;
                guJiDiDian.zPos += this.field_70179_y;
                tempMotionY -= (double)this.acceleration;
            }
        }
        return guJiDiDian;
    }

    @Override
    public void setNormalExplode() {
        this.setNormalExplode = true;
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    @Override
    public void setExplode() {
        this.setExplode = true;
        this.field_70180_af.func_75692_b(17, (Object)2);
    }

    public void func_70106_y() {
        RadarRegistry.unregister(this);
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        super.func_70106_y();
    }

    @Override
    public void explode() {
        try {
            if (!this.isExpoding) {
                if (this.explosiveID == 0) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
                    }
                } else {
                    ((Explosion)ExplosiveRegistry.get(this.explosiveID)).createExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this);
                }
                this.isExpoding = true;
                DefenseTech.LOGGER.info(this.func_70005_c_() + " (" + this.func_145782_y() + ") exploded in " + (int)this.field_70165_t + ", " + (int)this.field_70163_u + ", " + (int)this.field_70161_v);
            }
            this.func_70106_y();
        }
        catch (Exception e) {
            DefenseTech.LOGGER.severe("Missile failed to explode properly. Report this to the developers.");
            e.printStackTrace();
        }
    }

    @Override
    public void normalExplode() {
        if (!this.isExpoding) {
            this.isExpoding = true;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
            }
            this.func_70106_y();
        }
    }

    @Override
    public void dropMissileAsItem() {
        if (!this.isExpoding && !this.field_70170_p.field_72995_K) {
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(DefenseTechItems.itemMissile, 1, this.explosiveID));
            float var13 = 0.05f;
            Random random = new Random();
            entityItem.field_70159_w = (float)random.nextGaussian() * var13;
            entityItem.field_70181_x = (float)random.nextGaussian() * var13 + 0.2f;
            entityItem.field_70179_y = (float)random.nextGaussian() * var13;
            this.field_70170_p.func_72838_d((Entity)entityItem);
        }
        this.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.startPos = Pos3D.read((NBTTagCompound)nbt.func_74775_l("kaiShi"));
        this.targetVector = Pos3D.read((NBTTagCompound)nbt.func_74775_l("muBiao"));
        this.launcherPos = Pos3D.read((NBTTagCompound)nbt.func_74775_l("faSheQi"));
        this.acceleration = nbt.func_74760_g("jiaSu");
        this.targetHeight = nbt.func_74762_e("baoZhaGaoDu");
        this.explosiveID = nbt.func_74762_e("haoMa");
        this.feiXingTick = nbt.func_74762_e("feiXingTick");
        this.qiFeiGaoDu = nbt.func_74769_h("qiFeiGaoDu");
        this.missileType = MissileType.values()[nbt.func_74762_e("xingShi")];
        this.nbtData = nbt.func_74775_l("data");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.startPos != null) {
            nbt.func_74782_a("kaiShi", (NBTBase)this.startPos.write(new NBTTagCompound()));
        }
        if (this.targetVector != null) {
            nbt.func_74782_a("muBiao", (NBTBase)this.targetVector.write(new NBTTagCompound()));
        }
        if (this.launcherPos != null) {
            nbt.func_74782_a("faSheQi", (NBTBase)this.launcherPos.write(new NBTTagCompound()));
        }
        nbt.func_74776_a("jiaSu", this.acceleration);
        nbt.func_74768_a("haoMa", this.explosiveID);
        nbt.func_74768_a("baoZhaGaoDu", this.targetHeight);
        nbt.func_74768_a("feiXingTick", this.feiXingTick);
        nbt.func_74780_a("qiFeiGaoDu", this.qiFeiGaoDu);
        nbt.func_74768_a("xingShi", this.missileType.ordinal());
        nbt.func_74782_a("data", (NBTBase)this.nbtData);
    }

    public float func_70053_R() {
        return 1.0f;
    }

    @Override
    public int getTicksInAir() {
        return this.feiXingTick;
    }

    @Override
    public IExplosive getExplosiveType() {
        return ExplosiveRegistry.get(this.explosiveID);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (DamageUtility.canHarm(this, source, damage)) {
            this.damage += damage;
            if (this.damage >= this.max_damage) {
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeTargeted(Object turret) {
        return this.getTicksInAir() > 0;
    }

    @Override
    public ITarget.TargetType getType() {
        return ITarget.TargetType.MISSILE;
    }

    @Override
    public NBTTagCompound getTagCompound() {
        return this.nbtData;
    }

    public static enum MissileType {
        MISSILE,
        CruiseMissile,
        LAUNCHER;

    }
}

