/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosion;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.client.model.missile.ModelAttractiveMissile;
import defense.client.model.missile.ModelRepulsiveMissile;
import defense.common.ModelMissileBase;
import defense.common.explosion.Explosion;
import defense.common.explosive.Explosive;
import defense.common.explosive.blast.BlastRepulsive;
import mekanism.common.recipe.ShapedMekanismRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ExRepulsive
extends Explosion {
    public ExRepulsive(String name, int tier) {
        super(name, tier);
        this.setFuseTime(120);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getMissileModel() {
        if (this.getUnlocalizedName().equalsIgnoreCase("attractive")) {
            return new ModelAttractiveMissile();
        }
        return new ModelRepulsiveMissile();
    }

    @Override
    public void init() {
        if (this.getID() == Explosive.attractive.getID()) {
            GameRegistry.addRecipe((IRecipe)new ShapedMekanismRecipe(this.getItemStack(), new Object[]{"YY", Character.valueOf('Y'), Explosive.condensed.getItemStack()}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedMekanismRecipe(this.getItemStack(), new Object[]{"Y", "Y", Character.valueOf('Y'), Explosive.condensed.getItemStack()}));
        }
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        if (this.getID() == Explosive.attractive.getID()) {
            new BlastRepulsive(world, entity, x, y, z, 2.0f).setDestroyItems().setPushType(1).explode();
        } else {
            new BlastRepulsive(world, entity, x, y, z, 2.0f).setDestroyItems().setPushType(2).explode();
        }
    }
}

