/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import defense.common.entity.EntityFlyingBlock;
import defense.common.explosive.blast.Blast;
import defense.common.explosive.thread.ThreadSmallExplosion;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class BlastAntiGravitational
extends Blast {
    protected ThreadSmallExplosion thread;
    protected Set<EntityFlyingBlock> flyingBlocks = new HashSet<EntityFlyingBlock>();

    public BlastAntiGravitational(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.field_77287_j.field_72995_K) {
            this.thread = new ThreadSmallExplosion(this.field_77287_j, this.position, (int)this.getRadius(), this.field_77283_e);
            this.thread.start();
        }
        this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:antigravity", 6.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public void doExplode() {
        int r = this.callCount;
        if (!this.field_77287_j.field_72995_K && this.thread.isComplete) {
            int blocksToTake = 20;
            for (Pos3D targetPosition : this.thread.results) {
                double distance = targetPosition.distance(this.position);
                if (distance > (double)r || distance < (double)(r - 2) || blocksToTake <= 0) continue;
                Block block = this.field_77287_j.func_147439_a((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos);
                if (this.field_77287_j.func_147437_c((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos) || block.func_149712_f(this.field_77287_j, (int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos) < 0.0f) continue;
                int metadata = this.field_77287_j.func_72805_g((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos);
                if (!(distance < (double)(r - 1)) && this.field_77287_j.field_73012_v.nextInt(3) <= 0) continue;
                this.field_77287_j.func_147468_f((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos);
                targetPosition.translate(0.5, 0.5, 0.5);
                if ((double)this.field_77287_j.field_73012_v.nextFloat() < 0.3 * (double)(this.getRadius() - (float)r)) {
                    EntityFlyingBlock entity = new EntityFlyingBlock(this.field_77287_j, targetPosition, block, metadata, 0.0f);
                    this.field_77287_j.func_72838_d((Entity)entity);
                    this.flyingBlocks.add(entity);
                    entity.yawChange = 50.0f * this.field_77287_j.field_73012_v.nextFloat();
                    entity.pitchChange = 100.0f * this.field_77287_j.field_73012_v.nextFloat();
                    entity.field_70181_x += Math.max(0.15 * (double)this.field_77287_j.field_73012_v.nextFloat(), 0.1);
                }
                --blocksToTake;
            }
        }
        int radius = (int)this.getRadius();
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.xPos - (double)radius), (double)(this.position.yPos - (double)radius), (double)(this.position.zPos - (double)radius), (double)(this.position.xPos + (double)radius), (double)100.0, (double)(this.position.zPos + (double)radius));
        List allEntities = this.field_77287_j.func_72872_a(Entity.class, bounds);
        for (Entity entity : allEntities) {
            if (entity instanceof EntityFlyingBlock || !(entity.field_70163_u < 100.0 + this.position.yPos) || !(entity.field_70181_x < 0.4)) continue;
            entity.field_70181_x += 0.15;
        }
        if (this.callCount > 2400) {
            this.controller.endExplosion();
        }
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public float getRadius() {
        return 15.0f;
    }

    @Override
    public long getEnergy() {
        return 10000L;
    }
}

