/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import defense.common.entity.EntityFlyingBlock;
import defense.common.entity.EntityLightBeam;
import defense.common.explosive.blast.Blast;
import defense.common.explosive.thread.ThreadExplosion;
import defense.common.explosive.thread.ThreadSky;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public abstract class BlastBeam
extends Blast {
    protected ThreadExplosion thread;
    protected Set<EntityFlyingBlock> feiBlocks = new HashSet<EntityFlyingBlock>();
    protected EntityLightBeam lightBeam;
    protected float red;
    protected float green;
    protected float blue;
    protected int radius = 5;

    public BlastBeam(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.field_77287_j.field_72995_K) {
            this.field_77287_j.func_72876_a(this.field_77283_e, this.position.xPos, this.position.yPos, this.position.zPos, 4.0f, true);
            this.lightBeam = new EntityLightBeam(this.field_77287_j, this.position, 400, this.red, this.green, this.blue);
            this.field_77287_j.func_72838_d((Entity)this.lightBeam);
            this.thread = new ThreadSky(this.field_77287_j, this.position, (int)this.getRadius(), 50.0f, this.field_77283_e);
            this.thread.start();
        }
    }

    @Override
    public void doExplode() {
        if (!this.field_77287_j.field_72995_K) {
            if (this.callCount > 100 / this.proceduralInterval() && this.thread.isComplete) {
                this.controller.endExplosion();
            }
            if (!this.canFocusBeam(this.field_77287_j, this.position)) {
                this.controller.endExplosion();
            }
            for (EntityFlyingBlock entity : this.feiBlocks) {
                Pos3D entityPosition = new Pos3D((Entity)entity);
                Pos3D centeredPosition = entityPosition.clone().translate(this.position.scale(-1.0));
                centeredPosition.rotateYaw(2.0);
                Pos3D newPosition = this.position.clone().translate(centeredPosition);
                entity.field_70159_w /= 3.0;
                entity.field_70181_x /= 3.0;
                entity.field_70179_y /= 3.0;
                entity.func_70024_g((newPosition.xPos - entityPosition.xPos) * 0.5 * (double)this.proceduralInterval(), 0.09 * (double)this.proceduralInterval(), (newPosition.zPos - entityPosition.zPos) * 0.5 * (double)this.proceduralInterval());
                entity.yawChange += 3.0f * this.field_77287_j.field_73012_v.nextFloat();
            }
        }
    }

    @Override
    public void doPostExplode() {
        if (!this.field_77287_j.field_72995_K && this.lightBeam != null) {
            this.lightBeam.func_70106_y();
            this.lightBeam = null;
        }
    }

    public boolean canFocusBeam(World worldObj, Pos3D position) {
        return worldObj.func_72937_j((int)position.xPos, (int)position.yPos + 1, (int)position.zPos);
    }

    @Override
    public int proceduralInterval() {
        return 4;
    }

    @Override
    public long getEnergy() {
        return 10000L;
    }
}

