/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import defense.common.DefenseTech;
import defense.common.explosive.blast.Blast;
import defense.common.explosive.blast.BlastMutation;
import defense.common.explosive.blast.BlastRot;
import defense.common.explosive.thread.ThreadLargeExplosion;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlastNuclear
extends Blast {
    private ThreadLargeExplosion thread;
    private float energy;
    private boolean spawnMoreParticles = false;
    private boolean isRadioactive = false;

    public BlastNuclear(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastNuclear(World world, Entity entity, double x, double y, double z, float size, float energy) {
        this(world, entity, x, y, z, size);
        this.energy = energy;
    }

    public BlastNuclear setNuclear() {
        this.spawnMoreParticles = true;
        this.isRadioactive = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        if (!this.field_77287_j.field_72995_K) {
            this.thread = new ThreadLargeExplosion(this.field_77287_j, this.position, (int)this.getRadius(), this.energy, this.field_77283_e);
            this.thread.start();
        } else if (this.spawnMoreParticles && DefenseTech.proxy.isFancyGraphicsEnabled()) {
            for (int y = 0; y < 26; ++y) {
                int r = 4;
                if (y < 8) {
                    r = Math.max(Math.min((8 - y) * 2, 10), 4);
                } else if (y > 15) {
                    r = Math.max(Math.min((y - 15) * 2, 15), 5);
                }
                for (int x = -r; x < r; ++x) {
                    for (int z = -r; z < r; ++z) {
                        double distance = MathHelper.func_76133_a((double)(x * x + z * z));
                        if (!((double)r > distance) || !((double)(r - 3) < distance)) continue;
                        Pos3D spawnPosition = this.position.clone().translate(new Pos3D((double)(x * 2), (double)((y - 2) * 2), (double)(z * 2)));
                        float xDiff = (float)(spawnPosition.xPos - this.position.xPos);
                        float zDiff = (float)(spawnPosition.zPos - this.position.zPos);
                        DefenseTech.proxy.spawnParticle("smoke", this.field_77287_j, spawnPosition, (double)xDiff * 0.3 * (double)this.field_77287_j.field_73012_v.nextFloat(), -this.field_77287_j.field_73012_v.nextFloat(), (double)zDiff * 0.3 * (double)this.field_77287_j.field_73012_v.nextFloat(), (float)(distance / (double)this.getRadius()) * this.field_77287_j.field_73012_v.nextFloat(), 0.0f, 0.0f, 8.0f, 1.2f);
                    }
                }
            }
        }
        this.doDamageEntities(this.getRadius(), this.energy * 1000.0f);
        this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:explosion", 7.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public void doExplode() {
        int r = this.callCount;
        if (this.field_77287_j.field_72995_K) {
            if (DefenseTech.proxy.isFancyGraphicsEnabled()) {
                for (int x = -r; x < r; ++x) {
                    for (int z = -r; z < r; ++z) {
                        double distance = MathHelper.func_76133_a((double)(x * x + z * z));
                        if (!(distance < (double)r) || !(distance > (double)(r - 1))) continue;
                        Pos3D targetPosition = this.position.clone().translate(new Pos3D((double)x, 0.0, (double)z));
                        if (!((double)this.field_77287_j.field_73012_v.nextFloat() < Math.max(0.001 * (double)r, 0.05))) continue;
                        DefenseTech.proxy.spawnParticle("smoke", this.field_77287_j, targetPosition, 5.0f, 1.0);
                    }
                }
            }
        } else if (this.thread != null) {
            if (this.thread.isComplete) {
                this.controller.endExplosion();
            }
        } else {
            this.controller.endExplosion();
            DefenseTech.LOGGER.severe("Something went wrong with multi-threading while detonating the nuclear explosive.");
        }
    }

    @Override
    public void doPostExplode() {
        try {
            if (!this.field_77287_j.field_72995_K && this.thread.isComplete) {
                for (Pos3D p : this.thread.results) {
                    Block block = this.field_77287_j.func_147439_a((int)p.xPos, (int)p.yPos, (int)p.zPos);
                    if (this.field_77287_j.func_147437_c((int)p.xPos, (int)p.yPos, (int)p.zPos)) continue;
                    block.onBlockExploded(this.field_77287_j, (int)p.xPos, (int)p.yPos, (int)p.zPos, (Explosion)this);
                }
            }
        }
        catch (Exception e) {
            DefenseTech.LOGGER.severe("Nuclear-type detonation Failed!");
            e.printStackTrace();
        }
        this.doDamageEntities(this.getRadius(), this.energy * 1000.0f);
        if (this.isRadioactive) {
            new BlastRot(this.field_77287_j, this.field_77283_e, this.position.xPos, this.position.yPos, this.position.zPos, this.getRadius(), this.energy).explode();
            new BlastMutation(this.field_77287_j, this.field_77283_e, this.position.xPos, this.position.yPos, this.position.zPos, this.getRadius()).explode();
            if (this.field_77287_j.field_73012_v.nextInt(3) == 0) {
                this.field_77287_j.func_72912_H().func_76084_b(true);
            }
        }
        this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:explosion", 10.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public long getEnergy() {
        return (long)(4.184E7f * this.energy);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.spawnMoreParticles = nbt.func_74767_n("spawnMoreParticles");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("spawnMoreParticles", this.spawnMoreParticles);
    }
}

