/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import defense.api.IExplosiveIgnore;
import defense.common.DefenseTech;
import defense.common.Settings;
import defense.common.entity.EntityExplosion;
import defense.common.entity.EntityExplosive;
import defense.common.entity.EntityFlyingBlock;
import defense.common.explosive.blast.Blast;
import defense.common.explosive.blast.BlastAntimatter;
import java.util.List;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class BlastRedmatter
extends Blast {
    private int maxTakeBlocks = 5;

    public BlastRedmatter(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.field_77287_j.field_72995_K) {
            this.field_77287_j.func_72876_a(this.field_77283_e, this.position.xPos, this.position.yPos, this.position.zPos, 5.0f, true);
        }
    }

    @Override
    protected void doPostExplode() {
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.field_77284_b - (double)this.field_77280_f), (double)(this.field_77285_c - (double)this.field_77280_f), (double)(this.field_77282_d - (double)this.field_77280_f), (double)(this.field_77284_b + (double)this.field_77280_f), (double)(this.field_77285_c + (double)this.field_77280_f), (double)(this.field_77282_d + (double)this.field_77280_f));
        List list = this.field_77287_j.func_72872_a(EntityExplosion.class, bounds);
        for (Object obj : list) {
            if (!(obj instanceof EntityExplosion)) continue;
            EntityExplosion explosion = (EntityExplosion)obj;
            if (!(explosion.blast instanceof BlastRedmatter)) continue;
            explosion.func_70106_y();
        }
    }

    @Override
    public void doExplode() {
        if (Settings.DO_REDMATTER_DESPAWN && this.callCount >= Settings.MAX_REDMATTER_LIFESPAN) {
            this.postExplode();
        }
        if (!this.field_77287_j.field_72995_K) {
            Pos3D currentPos = new Pos3D();
            int blockID = -1;
            int metadata = -1;
            double dist = -1.0;
            int takenBlocks = 0;
            Block block = null;
            int radius = 1;
            block0: while ((float)radius < this.getRadius()) {
                for (int xCoord = -radius; xCoord < radius; ++xCoord) {
                    for (int yCoord = -radius; yCoord < radius; ++yCoord) {
                        for (int zCoord = -radius; zCoord < radius; ++zCoord) {
                            currentPos.xPos = this.position.xPos + (double)xCoord;
                            currentPos.yPos = this.position.yPos + (double)yCoord;
                            currentPos.zPos = this.position.zPos + (double)zCoord;
                            dist = MathHelper.func_76133_a((double)(xCoord * xCoord + yCoord * yCoord + zCoord * zCoord));
                            if (dist > (double)radius || dist < (double)(radius - 2)) continue;
                            block = currentPos.getCoord(this.field_77287_j.field_73011_w.field_76574_g).getBlock((IBlockAccess)this.field_77287_j);
                            metadata = currentPos.getCoord(this.field_77287_j.field_73011_w.field_76574_g).getMetadata((IBlockAccess)this.field_77287_j);
                            if (this.field_77287_j.func_147437_c((int)currentPos.xPos, (int)currentPos.yPos, (int)currentPos.zPos) || !(block.func_149712_f(this.field_77287_j, (int)currentPos.xPos, (int)currentPos.yPos, (int)currentPos.zPos) >= 0.0f)) continue;
                            this.field_77287_j.func_147465_d((int)currentPos.xPos, (int)currentPos.yPos, (int)currentPos.zPos, Blocks.field_150350_a, 0, block instanceof BlockLiquid ? 0 : 2);
                            if (block instanceof BlockLiquid || block instanceof IFluidBlock) continue;
                            currentPos.translate(0.5, 0.5, 0.5);
                            if ((double)this.field_77287_j.field_73012_v.nextFloat() > 0.8) {
                                EntityFlyingBlock entity = new EntityFlyingBlock(this.field_77287_j, currentPos, block, metadata);
                                this.field_77287_j.func_72838_d((Entity)entity);
                                entity.yawChange = 50.0f * this.field_77287_j.field_73012_v.nextFloat();
                                entity.pitchChange = 50.0f * this.field_77287_j.field_73012_v.nextFloat();
                            }
                            if (++takenBlocks > this.maxTakeBlocks) break block0;
                        }
                    }
                }
                ++radius;
            }
        }
        float radius = this.getRadius() + this.getRadius() / 2.0f;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.xPos - (double)radius), (double)(this.position.yPos - (double)radius), (double)(this.position.zPos - (double)radius), (double)(this.position.xPos + (double)radius), (double)(this.position.yPos + (double)radius), (double)(this.position.zPos + (double)radius));
        List allEntities = this.field_77287_j.func_72872_a(Entity.class, bounds);
        boolean doExplosion = true;
        for (Entity entity : allEntities) {
            doExplosion = !this.affectEntity(radius, entity, doExplosion);
        }
        if (this.field_77287_j.field_73012_v.nextInt(8) == 0) {
            this.field_77287_j.func_72908_a(this.position.xPos + (Math.random() - 0.5) * (double)radius, this.position.yPos + (Math.random() - 0.5) * (double)radius, this.position.zPos + (Math.random() - 0.5) * (double)radius, "defense:collapse", 6.0f - this.field_77287_j.field_73012_v.nextFloat(), 1.0f - this.field_77287_j.field_73012_v.nextFloat() * 0.4f);
        }
        this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:redmatter", 3.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 1.0f);
    }

    public boolean affectEntity(float radius, Entity entity, boolean doExplosion) {
        boolean explosionCreated = false;
        if (entity == this.controller) {
            return false;
        }
        if (entity instanceof IExplosiveIgnore && ((IExplosiveIgnore)entity).canIgnore(this)) {
            return false;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return false;
        }
        double xDifference = entity.field_70165_t - this.position.xPos;
        double yDifference = entity.field_70163_u - this.position.yPos;
        double zDifference = entity.field_70161_v - this.position.zPos;
        double xPercentage = 1.0 - xDifference / (double)radius;
        double yPercentage = 1.0 - yDifference / (double)radius;
        double zPercentage = 1.0 - zDifference / (double)radius;
        double distancePercentage = this.position.distance(new Pos3D(entity)) / (double)radius;
        Pos3D entityPosition = new Pos3D(entity);
        Pos3D centeredPosition = entityPosition.clone().diff(this.position);
        centeredPosition.rotate(1.5 * distancePercentage * Math.random(), 1.5 * distancePercentage * Math.random(), 1.5 * distancePercentage * Math.random());
        Pos3D newPosition = this.position.clone().translate(centeredPosition);
        entity.func_70024_g(newPosition.xPos - entityPosition.xPos, 0.0, newPosition.zPos - entityPosition.zPos);
        entity.func_70024_g(-xDifference * 0.015 * xPercentage, -yDifference * 0.015 * yPercentage, -zDifference * 0.015 * zPercentage);
        if (this.field_77287_j.field_72995_K && entity instanceof EntityFlyingBlock && DefenseTech.proxy.getParticleSetting() == 0 && this.field_77287_j.field_73012_v.nextInt(5) == 0) {
            DefenseTech.proxy.spawnParticle("digging", this.field_77287_j, new Pos3D(entity), -xDifference, -yDifference + 10.0, -zDifference, Block.func_149682_b((Block)((EntityFlyingBlock)entity).block), 0.0f, ((EntityFlyingBlock)entity).metadata, 2.0f, 1.0);
        }
        Pos3D pos3D = new Pos3D(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (pos3D.distance(this.position) < 4.0) {
            if (doExplosion && !explosionCreated && this.callCount % 5 == 0) {
                Pos3D tempMotion = new Pos3D(this.controller.field_70159_w, this.controller.field_70181_x, this.controller.field_70179_y);
                this.field_77287_j.func_72876_a(this.field_77283_e, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 3.0f, true);
                this.controller.field_70159_w = tempMotion.xPos;
                this.controller.field_70181_x = tempMotion.yPos;
                this.controller.field_70179_y = tempMotion.zPos;
                explosionCreated = true;
            }
            if (entity instanceof EntityLivingBase) {
                entity.field_70143_R = 0.0f;
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), 4.0f);
            } else if (entity instanceof EntityExplosion) {
                if (((EntityExplosion)entity).blast instanceof BlastAntimatter || ((EntityExplosion)entity).blast instanceof BlastRedmatter) {
                    this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:explosion", 7.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    if ((double)this.field_77287_j.field_73012_v.nextFloat() > 0.85 && !this.field_77287_j.field_72995_K) {
                        entity.func_70106_y();
                        return explosionCreated;
                    }
                }
            } else if (entity instanceof EntityExplosive) {
                ((EntityExplosive)entity).explode();
            } else {
                entity.func_70106_y();
            }
        }
        return explosionCreated;
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public long getEnergy() {
        return -3000L;
    }

    @Override
    public boolean isMovable() {
        return this.callCount > 1;
    }
}

