/*
 * Decompiled with CFR 0.152.
 */
package defense.common.tile;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import defense.api.RadarRegistry;
import defense.common.DefenseTech;
import defense.common.base.IBlockActivate;
import defense.common.explosive.blast.BlastEMP;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEMPTower
extends TileEntityElectricBlock
implements IBoundingBlock,
IBlockActivate,
IComputerIntegration {
    public static final int MAX_RADIUS = 150;
    public float rotation = 0.0f;
    private float rotationDelta = 0.0f;
    public byte empMode = 0;
    private int cooldownTicks = 0;
    public int empRadius = 60;
    public double energyToUse = 0.0;
    public boolean packet = false;
    private static final String[] methods = new String[]{"getEMPMode", "setEMPMode", "targetMissiles", "targetAll", "targetElectronics", "getEMPRadius", "getMaxEMPRadius", "setEMPRadius"};

    public TileEMPTower() {
        super("EMPTower", 1.0E7);
        RadarRegistry.register((TileEntity)this);
        this.updateCapacity();
    }

    public String func_145825_b() {
        return LangUtils.localize((String)"machine.EmpTower.name");
    }

    public void func_145843_s() {
        RadarRegistry.unregister((TileEntity)this);
        super.func_145843_s();
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.isReady()) {
            --this.cooldownTicks;
        }
        if (this.ticker % 20 == 0 && this.getEnergy() > 0.0) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "defense:machinehum", 0.5f, 0.85f * (float)this.getEnergy() / (float)this.getMaxEnergy());
        }
        this.rotationDelta = (float)(Math.pow(this.getEnergy() / this.getMaxEnergy(), 2.0) * 0.5);
        this.rotation += this.rotationDelta;
        if (this.rotation > 360.0f) {
            this.rotation = 0.0f;
        }
        if (!this.field_145850_b.field_72995_K && this.ticker % 20 == 0) {
            Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this)));
        }
    }

    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int packetType = dataStream.readInt();
            if (packetType == 1) {
                this.empRadius = dataStream.readInt();
                this.updateCapacity();
            } else if (packetType == 2) {
                this.empMode = dataStream.readByte();
            }
            return;
        }
        super.handlePacketData(dataStream);
        int prev = this.empRadius;
        this.empRadius = dataStream.readInt();
        this.empMode = dataStream.readByte();
        if (dataStream.readBoolean()) {
            switch (this.empMode) {
                default: {
                    new BlastEMP(this.field_145850_b, null, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.empRadius).setEffectBlocks().setEffectEntities().explode();
                    break;
                }
                case 1: {
                    new BlastEMP(this.field_145850_b, null, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.empRadius).setEffectEntities().explode();
                    break;
                }
                case 2: {
                    new BlastEMP(this.field_145850_b, null, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.empRadius).setEffectBlocks().explode();
                }
            }
        }
        if (prev != this.empRadius) {
            this.updateCapacity();
        }
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.empRadius);
        data.add(this.empMode);
        data.add(this.packet);
        this.packet = false;
        return data;
    }

    public boolean isReady() {
        return this.getCooldown() <= 0;
    }

    public int getCooldown() {
        return this.cooldownTicks;
    }

    public int getMaxCooldown() {
        return 120;
    }

    private void updateCapacity() {
        this.maxEnergy = Math.max(3000000.0 * ((double)this.empRadius / 150.0), 1.0E7);
        this.energyToUse = this.getMaxEnergy() / 4.0;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.empRadius = par1NBTTagCompound.func_74762_e("banJing");
        this.empMode = par1NBTTagCompound.func_74771_c("muoShi");
        this.updateCapacity();
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("banJing", this.empRadius);
        par1NBTTagCompound.func_74774_a("muoShi", this.empMode);
    }

    public boolean fire() {
        if (!this.field_145850_b.field_72995_K && this.getEnergy() >= this.energyToUse && this.isReady()) {
            switch (this.empMode) {
                default: {
                    new BlastEMP(this.field_145850_b, null, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.empRadius).setEffectBlocks().setEffectEntities().explode();
                    break;
                }
                case 1: {
                    new BlastEMP(this.field_145850_b, null, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.empRadius).setEffectEntities().explode();
                    break;
                }
                case 2: {
                    new BlastEMP(this.field_145850_b, null, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.empRadius).setEffectBlocks().explode();
                }
            }
            this.setEnergy(this.getEnergy() - this.energyToUse);
            this.cooldownTicks = this.getMaxCooldown();
            this.packet = true;
            Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this)));
            return true;
        }
        return false;
    }

    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    public void onPowerChange() {
        if (this.redstone) {
            this.fire();
        }
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)DefenseTech.INSTANCE, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void onPlace() {
        Coord4D pos = Coord4D.get((TileEntity)this);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (Coord4D)pos.getFromSide(ForgeDirection.UP, 1), (Coord4D)pos);
    }

    public void onBreak() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] args) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEmpMode()};
            }
            case 1: {
                if (args.length < 1 || !(args[0] instanceof Number)) {
                    return new Object[]{false, "first argument needs to be a number between 0 and 2"};
                }
                return new Object[]{this.setEmpMode(((Number)args[0]).byteValue())};
            }
            case 2: {
                this.empMissiles();
                return new Object[0];
            }
            case 3: {
                this.empAll();
                return new Object[0];
            }
            case 4: {
                this.empElectronics();
                return new Object[0];
            }
            case 5: {
                return new Object[]{this.getEmpRadius()};
            }
            case 6: {
                return new Object[]{this.getMaxEmpRadius()};
            }
            case 7: {
                if (args.length < 1 || !(args[0] instanceof Number)) {
                    return new Object[]{false, "first argument needs to be a number"};
                }
                this.setEmpRadius(((Number)args[0]).intValue());
                return new Object[]{true};
            }
        }
        throw new NoSuchMethodException();
    }

    public byte getEmpMode() {
        return this.empMode;
    }

    public boolean setEmpMode(byte empMode) {
        if (empMode >= 0 && empMode <= 2) {
            this.empMode = empMode;
            return true;
        }
        return false;
    }

    public void empMissiles() {
        this.empMode = 1;
    }

    public void empAll() {
        this.empMode = 0;
    }

    public void empElectronics() {
        this.empMode = (byte)2;
    }

    public int getEmpRadius() {
        return this.empRadius;
    }

    public int getMaxEmpRadius() {
        return 150;
    }

    public void setEmpRadius(int empRadius) {
        int prev = this.getEmpRadius();
        this.empRadius = Math.min(Math.max(empRadius, 0), 150);
        if (prev != this.getEmpRadius()) {
            this.updateCapacity();
        }
    }
}

