/*
 * Decompiled with CFR 0.152.
 */
package defense.common.tile;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import defense.api.ExplosionEvent;
import defense.api.ExplosiveType;
import defense.api.ILauncherContainer;
import defense.api.ILauncherController;
import defense.api.IMissile;
import defense.api.ITier;
import defense.common.Settings;
import defense.common.base.IBlockActivate;
import defense.common.entity.EntityMissile;
import defense.common.explosion.Explosion;
import defense.common.explosive.ExplosiveRegistry;
import defense.common.item.ItemMissile;
import defense.common.tile.TileLauncherFrame;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Pos3D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLauncherBase
extends TileEntityContainerBlock
implements ILauncherContainer,
ITier,
IBoundingBlock,
IBlockActivate {
    public IMissile missile = null;
    public TileLauncherFrame supportFrame = null;
    private int tier = 0;
    private boolean packetGengXin = true;

    public TileLauncherBase() {
        super("LauncherBase");
        this.inventory = new ItemStack[1];
    }

    public String func_145825_b() {
        return LangUtils.localize((String)"gui.launcherBase.name");
    }

    public void onUpdate() {
        if (this.supportFrame == null) {
            for (int i = 2; i < 6; i = (int)((byte)(i + 1))) {
                Coord4D position = Coord4D.get((TileEntity)this);
                position.step(ForgeDirection.getOrientation((int)i));
                TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_145850_b);
                if (!(tileEntity instanceof TileLauncherFrame)) continue;
                this.supportFrame = (TileLauncherFrame)tileEntity;
                this.supportFrame.setFacing((short)MekanismUtils.getBaseOrientation((int)ForgeDirection.NORTH.ordinal(), (int)i));
            }
        } else if (this.supportFrame.func_145837_r()) {
            this.supportFrame = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.setMissile();
            if (this.packetGengXin || this.ticker % 600 == 0) {
                Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this)));
                this.packetGengXin = false;
            }
        }
    }

    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.tier = dataStream.readInt();
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.tier);
        return data;
    }

    public void setMissile() {
        if (!this.field_145850_b.field_72995_K) {
            int explosiveID;
            if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemMissile && ExplosiveRegistry.get(explosiveID = this.func_70301_a(0).func_77960_j()) instanceof Explosion) {
                Explosion missile = (Explosion)ExplosiveRegistry.get(explosiveID);
                ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ExplosiveType.AIR, missile);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (!evt.isCanceled()) {
                    if (this.missile == null) {
                        Pos3D startingPosition = new Pos3D((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.8f), (double)((float)this.field_145849_e + 0.5f));
                        this.missile = new EntityMissile(this.field_145850_b, startingPosition, new Pos3D((TileEntity)this), explosiveID);
                        this.field_145850_b.func_72838_d((Entity)this.missile);
                        return;
                    }
                    if (this.missile.getExplosiveType().getID() == explosiveID) {
                        return;
                    }
                }
            }
            if (this.missile != null) {
                ((Entity)this.missile).func_70106_y();
            }
            this.missile = null;
        }
    }

    public void launchMissile(Pos3D target, int gaoDu) {
        float inaccuracy = this.supportFrame != null ? (float)this.supportFrame.getInaccuracy() : 30.0f;
        target.xPos += (double)(inaccuracy *= (float)Math.random() * 2.0f - 1.0f);
        target.zPos += (double)inaccuracy;
        this.func_70298_a(0, 1);
        this.missile.launch(target, gaoDu);
        this.missile = null;
    }

    public boolean isInRange(Pos3D target) {
        if (target != null) {
            return !this.shiTaiYuan(target) && !this.shiTaiJin(target);
        }
        return false;
    }

    public boolean shiTaiJin(Pos3D target) {
        return new Pos3D((double)this.field_145851_c, 0.0, (double)this.field_145849_e).distance(new Pos3D(target.xPos, 0.0, target.zPos)) < 10.0;
    }

    public boolean shiTaiYuan(Pos3D target) {
        if (this.tier == 0) {
            Pos3D pos3D = new Pos3D((double)this.field_145851_c, 0.0, (double)this.field_145849_e);
            Pos3D pos3D2 = new Pos3D(target.xPos, 0.0, target.zPos);
            if (pos3D.distance(pos3D2) < (double)(Settings.MAX_MISSILE_DISTANCE / 10)) {
                return false;
            }
        } else if (this.tier == 1) {
            Pos3D pos3D = new Pos3D((double)this.field_145851_c, 0.0, (double)this.field_145849_e);
            Pos3D pos3D3 = new Pos3D(target.xPos, 0.0, target.zPos);
            if (pos3D.distance(pos3D3) < (double)(Settings.MAX_MISSILE_DISTANCE / 5)) {
                return false;
            }
        } else if (this.tier == 2) {
            Pos3D pos3D = new Pos3D((double)this.field_145851_c, 0.0, (double)this.field_145849_e);
            Pos3D pos3D4 = new Pos3D(target.xPos, 0.0, target.zPos);
            if (pos3D.distance(pos3D4) < (double)Settings.MAX_MISSILE_DISTANCE) {
                return false;
            }
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tier = nbt.func_74762_e("tier");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("tier", this.tier);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public boolean onActivated(EntityPlayer player) {
        if (player.field_71071_by.func_70448_g() != null) {
            if (player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemMissile) {
                if (this.func_70301_a(0) == null) {
                    this.func_70299_a(0, player.field_71071_by.func_70448_g());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    return true;
                }
                ItemStack player_held = player.field_71071_by.func_70448_g();
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.func_70301_a(0));
                }
                this.func_70299_a(0, player_held);
                return true;
            }
        } else if (this.func_70301_a(0) != null) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.func_70301_a(0));
            this.func_70299_a(0, null);
            return true;
        }
        return true;
    }

    public void func_145843_s() {
        if (this.missile != null) {
            ((Entity)this.missile).func_70106_y();
        }
        super.func_145843_s();
    }

    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    public void onPlace() {
        Coord4D pos = Coord4D.get((TileEntity)this);
        for (Coord4D coord : this.getMultiBlockVectors()) {
            MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (Coord4D)pos.clone().translate(coord), (Coord4D)pos);
        }
    }

    public void onBreak() {
        for (Coord4D coord : this.getMultiBlockVectors()) {
            Coord4D translated = Coord4D.get((TileEntity)this).translate(coord);
            this.field_145850_b.func_147468_f(translated.xCoord, translated.yCoord, translated.zCoord);
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Coord4D[] getMultiBlockVectors() {
        ForgeDirection facingDirection = ForgeDirection.getOrientation((int)this.facing);
        if (facingDirection == ForgeDirection.SOUTH || facingDirection == ForgeDirection.NORTH) {
            return new Coord4D[]{new Coord4D(1, 0, 0), new Coord4D(1, 1, 0), new Coord4D(1, 2, 0), new Coord4D(-1, 0, 0), new Coord4D(-1, 1, 0), new Coord4D(-1, 2, 0)};
        }
        return new Coord4D[]{new Coord4D(0, 0, 1), new Coord4D(0, 1, 1), new Coord4D(0, 2, 1), new Coord4D(0, 0, -1), new Coord4D(0, 1, -1), new Coord4D(0, 2, -1)};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0 && stack.func_77973_b() instanceof ItemMissile;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public void setContainingMissile(IMissile missile) {
        this.missile = missile;
    }

    @Override
    public ILauncherController getController() {
        for (int i = 2; i < 6; i = (int)((byte)(i + 1))) {
            Coord4D position = Coord4D.get((TileEntity)this).step(ForgeDirection.getOrientation((int)i));
            TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tileEntity instanceof ILauncherController)) continue;
            return (ILauncherController)tileEntity;
        }
        return null;
    }
}

