/*
 * Decompiled with CFR 0.152.
 */
package defense.common.tile;

import defense.api.ILauncherController;
import defense.api.IMissile;
import defense.api.ITier;
import defense.common.DefenseTech;
import defense.common.base.IBlockActivate;
import defense.common.tile.TileLauncherBase;
import defense.common.tile.TileLauncherPrefab;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.Pos3D;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLauncherScreen
extends TileLauncherPrefab
implements IBlockActivate,
ITier {
    private int tier = 0;
    public TileLauncherBase laucherBase = null;
    public short gaoDu = (short)3;
    private final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();

    public TileLauncherScreen() {
        super("LauncherScreen", 1.0E7);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.laucherBase == null) {
            for (ForgeDirection side : MekanismUtils.SIDE_DIRS) {
                Coord4D position = new Coord4D(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                position.step(side);
                TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity == null || !(tileEntity instanceof TileLauncherBase)) continue;
                this.laucherBase = (TileLauncherBase)tileEntity;
                this.setFacing((short)side.getOpposite().ordinal());
            }
        } else if (this.laucherBase.func_145837_r()) {
            this.laucherBase = null;
        }
        if (!this.field_145850_b.field_72995_K && this.ticker % 40 == 0 && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.launch();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticker % 3 == 0 && this.targetPos == null) {
                this.targetPos = new Pos3D((double)this.field_145851_c, 0.0, (double)this.field_145849_e);
            }
            if (this.ticker % 600 == 0) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int packetType = dataStream.readInt();
            if (packetType == 1) {
                this.setFrequency(dataStream.readInt());
            } else if (packetType == 2) {
                this.targetPos = new Pos3D((double)dataStream.readInt(), (double)dataStream.readInt(), (double)dataStream.readInt());
                if (this.getTier() < 2) {
                    this.targetPos.yPos = 0.0;
                }
            } else if (packetType == 3) {
                this.gaoDu = (short)Math.max(Math.min(dataStream.readShort(), Short.MAX_VALUE), 3);
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.tier = dataStream.readInt();
        this.gaoDu = dataStream.readShort();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.tier);
        data.add(this.gaoDu);
        return data;
    }

    @Override
    public void placeMissile(ItemStack itemStack) {
        if (this.laucherBase != null && !this.laucherBase.func_145837_r()) {
            this.laucherBase.func_70299_a(0, itemStack);
        }
    }

    @Override
    public boolean canLaunch() {
        if (this.laucherBase != null && this.laucherBase.missile != null && this.getEnergy() >= (double)this.getLaunchCost()) {
            return this.laucherBase.isInRange(this.targetPos);
        }
        return false;
    }

    @Override
    public void launch() {
        if (this.canLaunch()) {
            this.setEnergy(this.getEnergy() - (double)this.getLaunchCost());
            this.laucherBase.launchMissile(this.targetPos.clone(), this.gaoDu);
        }
    }

    @Override
    public String getStatus() {
        String color = "\u00a74";
        String status = LangUtils.localize((String)"gui.misc.idle");
        if (this.laucherBase == null) {
            status = LangUtils.localize((String)"gui.launcherScreen.statusMissing");
        } else if (this.getEnergy() < (double)this.getLaunchCost()) {
            status = LangUtils.localize((String)"gui.launcherScreen.statusNoPower");
        } else if (this.laucherBase.missile == null) {
            status = LangUtils.localize((String)"gui.launcherScreen.statusEmpty");
        } else if (this.targetPos == null) {
            status = LangUtils.localize((String)"gui.launcherScreen.statusInvalid");
        } else if (this.laucherBase.shiTaiJin(this.targetPos)) {
            status = LangUtils.localize((String)"gui.launcherScreen.statusClose");
        } else if (this.laucherBase.shiTaiYuan(this.targetPos)) {
            status = LangUtils.localize((String)"gui.launcherScreen.statusFar");
        } else {
            color = "\u00a72";
            status = LangUtils.localize((String)"gui.launcherScreen.statusReady");
        }
        return color + status;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.tier = par1NBTTagCompound.func_74762_e("tier");
        this.gaoDu = par1NBTTagCompound.func_74765_d("gaoDu");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("tier", this.tier);
        par1NBTTagCompound.func_74777_a("gaoDu", this.gaoDu);
    }

    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    public long getLaunchCost() {
        switch (this.getTier()) {
            case 0: {
                return 50000L;
            }
            case 1: {
                return 80000L;
            }
        }
        return 100000L;
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)DefenseTech.INSTANCE, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public ILauncherController.LauncherType getLauncherType() {
        return ILauncherController.LauncherType.TRADITIONAL;
    }

    @Override
    public IMissile getMissile() {
        if (this.laucherBase != null) {
            return this.laucherBase.missile;
        }
        return null;
    }
}

