/*
 * Decompiled with CFR 0.152.
 */
package defense.common.tile;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import defense.api.FrequencyGrid;
import defense.api.IBlockFrequency;
import defense.api.IItemFrequency;
import defense.api.IRadarDetectable;
import defense.api.RadarRegistry;
import defense.common.DefenseTech;
import defense.common.Vector2;
import defense.common.base.IBlockActivate;
import defense.common.base.IChunkLoadHandler;
import defense.common.base.IRedstoneProvider;
import defense.common.entity.EntityMissile;
import defense.common.tile.TileLauncherPrefab;
import defense.common.tile.TileLauncherScreen;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.Pos3D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRadarStation
extends TileEntityElectricBlock
implements IChunkLoadHandler,
IRedstoneProvider,
IComputerIntegration,
IBlockActivate,
IBlockFrequency {
    public static final int MAX_DETECTION_RANGE = 500;
    public float rotation = 0.0f;
    public int alarmRange = 100;
    public int safetyRange = 50;
    public List<Entity> detectedEntities = new ArrayList<Entity>();
    public boolean initiated = false;
    public List<TileEntity> detectedTiles = new ArrayList<TileEntity>();
    public boolean emitAll = true;
    private List<EntityMissile> incomingMissiles = new ArrayList<EntityMissile>();
    public static final double ENERGY_USAGE = 400.0;
    protected int frequency = 0;
    private ForgeChunkManager.Ticket ticket;

    public TileRadarStation() {
        super("RadarStation", 1000000.0);
        RadarRegistry.register((TileEntity)this);
    }

    public void initiate() {
        FrequencyGrid.instance().register(this);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.chunkLoaderInit(ForgeChunkManager.requestTicket((Object)DefenseTech.INSTANCE, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL));
    }

    public String func_145825_b() {
        return LangUtils.localize((String)"machine.RadarStation.name");
    }

    @Override
    public void chunkLoaderInit(ForgeChunkManager.Ticket ticket) {
        if (!this.field_145850_b.field_72995_K && this.ticket == null && ticket != null) {
            this.ticket = ticket;
            Coord4D.get((TileEntity)this).write(this.ticket.getModData());
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.initiated) {
            this.initiate();
            this.initiated = true;
        }
        if (!this.field_145850_b.field_72995_K && this.ticker % 40 == 0) {
            Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this)));
        }
        if (this.getEnergy() >= 400.0) {
            this.rotation += 0.08f;
            if (this.rotation > 360.0f) {
                this.rotation = 0.0f;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.setEnergy(this.getEnergy() - 400.0);
            }
            int prevDetectedEntities = this.detectedEntities.size();
            this.doScan();
            if (prevDetectedEntities != this.detectedEntities.size()) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            if (this.ticker % 20 == 0 && this.incomingMissiles.size() > 0) {
                for (IBlockFrequency blockFrequency : FrequencyGrid.instance().get()) {
                    if (!(blockFrequency instanceof TileLauncherPrefab)) continue;
                    TileLauncherPrefab launcher = (TileLauncherPrefab)blockFrequency;
                    Pos3D pos3D = new Pos3D((TileEntity)this);
                    Pos3D pos3D2 = new Pos3D((TileEntity)launcher);
                    if (!(pos3D.distance(pos3D2) < (double)this.alarmRange) || launcher.getFrequency() != this.getFrequency()) continue;
                    if (launcher instanceof TileLauncherScreen) {
                        double height = launcher.getTarget() != null ? launcher.getTarget().yPos : 0.0;
                        launcher.setTarget(new Pos3D(this.incomingMissiles.get((int)0).field_70165_t, height, this.incomingMissiles.get((int)0).field_70161_v));
                        continue;
                    }
                    launcher.setTarget(new Pos3D((Entity)this.incomingMissiles.get(0)));
                }
            }
        } else {
            if (this.detectedEntities.size() > 0) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            this.incomingMissiles.clear();
            this.detectedEntities.clear();
            this.detectedTiles.clear();
        }
        if (this.ticker % 40 == 0) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    private void doScan() {
        int i;
        this.incomingMissiles.clear();
        this.detectedEntities.clear();
        this.detectedTiles.clear();
        List<Entity> entities = RadarRegistry.getEntitiesWithinRadius(new Vector2(new Pos3D((TileEntity)this)), 500);
        block0: for (Entity entity : entities) {
            if (entity instanceof EntityMissile) {
                if (((EntityMissile)entity).feiXingTick <= -1) continue;
                if (!this.detectedEntities.contains(entity)) {
                    this.detectedEntities.add(entity);
                }
                if (!this.isMissileGoingToHit((EntityMissile)entity)) continue;
                if (this.incomingMissiles.size() > 0) {
                    double dist = new Pos3D((TileEntity)this).distance(new Pos3D(entity));
                    for (i = 0; i < this.incomingMissiles.size(); ++i) {
                        EntityMissile daoDan = this.incomingMissiles.get(i);
                        Pos3D pos3D = new Pos3D((TileEntity)this);
                        Pos3D pos3D2 = new Pos3D((Entity)daoDan);
                        if (dist < pos3D.distance(pos3D2)) {
                            this.incomingMissiles.add(i, (EntityMissile)entity);
                            continue block0;
                        }
                        if (i != this.incomingMissiles.size() - 1) continue;
                        this.incomingMissiles.add((EntityMissile)entity);
                        continue block0;
                    }
                    continue;
                }
                this.incomingMissiles.add((EntityMissile)entity);
                continue;
            }
            this.detectedEntities.add(entity);
        }
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 500), (double)(this.field_145848_d - 500), (double)(this.field_145849_e - 500), (double)(this.field_145851_c + 500), (double)(this.field_145848_d + 500), (double)(this.field_145849_e + 500)));
        for (EntityPlayer player : players) {
            if (player == null) continue;
            boolean youHuoLuan = false;
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IItemFrequency)) continue;
                youHuoLuan = true;
                break;
            }
            if (youHuoLuan) continue;
            this.detectedEntities.add((Entity)player);
        }
        for (TileEntity jiQi : RadarRegistry.getTileEntitiesInArea(new Vector2(this.field_145851_c - 500, this.field_145849_e - 500), new Vector2(this.field_145851_c + 500, this.field_145849_e + 500))) {
            if (jiQi instanceof TileRadarStation) {
                if (!(((TileRadarStation)jiQi).getEnergy() > 0.0)) continue;
                this.detectedTiles.add(jiQi);
                continue;
            }
            if (this.detectedTiles instanceof IRadarDetectable) {
                if (!((IRadarDetectable)((Object)this.detectedTiles)).canDetect((TileEntity)this)) continue;
                this.detectedTiles.add(jiQi);
                continue;
            }
            this.detectedTiles.add(jiQi);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMissileGoingToHit(EntityMissile missile) {
        if (missile == null) return false;
        if (missile.targetVector == null) {
            return false;
        }
        Vector2 vector2 = new Vector2(new Pos3D((Entity)missile));
        Vector2 vector22 = new Vector2(this.field_145851_c, this.field_145849_e);
        if (!(Vector2.distance(vector2, vector22) < (double)this.alarmRange)) return false;
        Vector2 vector23 = new Vector2(missile.targetVector);
        Vector2 vector24 = new Vector2(this.field_145851_c, this.field_145849_e);
        if (!(Vector2.distance(vector23, vector24) < (double)this.safetyRange)) return false;
        return true;
    }

    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int packetType = dataStream.readInt();
            if (packetType == 2) {
                this.safetyRange = dataStream.readInt();
            } else if (packetType == 3) {
                this.alarmRange = dataStream.readInt();
            } else if (packetType == 4) {
                this.frequency = dataStream.readInt();
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.alarmRange = dataStream.readInt();
        this.safetyRange = dataStream.readInt();
        this.frequency = dataStream.readInt();
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.alarmRange);
        data.add(this.safetyRange);
        data.add(this.frequency);
        return data;
    }

    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public boolean isPoweringTo(ForgeDirection side) {
        if (this.incomingMissiles.size() > 0) {
            if (this.emitAll) {
                return true;
            }
            for (EntityMissile incomingMissile : this.incomingMissiles) {
                Vector2 position = new Vector2(new Pos3D((Entity)incomingMissile));
                ForgeDirection missileTravelDirection = ForgeDirection.UNKNOWN;
                double closest = -1.0;
                for (int i = 2; i < 6; ++i) {
                    double dist = Vector2.distance(position, new Vector2(this.field_145851_c + ForgeDirection.getOrientation((int)i).offsetX, this.field_145849_e + ForgeDirection.getOrientation((int)i).offsetZ));
                    if (!(dist < closest) && !(closest < 0.0)) continue;
                    missileTravelDirection = ForgeDirection.getOrientation((int)i);
                    closest = dist;
                }
                if (missileTravelDirection.getOpposite() != side) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIndirectlyPoweringTo(ForgeDirection side) {
        return this.isPoweringTo(side);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.safetyRange = nbt.func_74762_e("safetyBanJing");
        this.alarmRange = nbt.func_74762_e("alarmBanJing");
        this.emitAll = nbt.func_74767_n("emitAll");
        this.frequency = nbt.func_74762_e("frequency");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("safetyBanJing", this.safetyRange);
        nbt.func_74768_a("alarmBanJing", this.alarmRange);
        nbt.func_74757_a("emitAll", this.emitAll);
        nbt.func_74768_a("frequency", this.frequency);
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        if (entityPlayer.field_71071_by.func_70448_g() != null && MekanismUtils.hasUsableWrench((EntityPlayer)entityPlayer, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e)) {
            if (!this.field_145850_b.field_72995_K) {
                this.emitAll = !this.emitAll;
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(LangUtils.localize((String)"message.radar.redstone") + " " + this.emitAll));
            }
            return true;
        }
        entityPlayer.openGui((Object)DefenseTech.INSTANCE, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public String[] getMethods() {
        return new String[]{"getEntities", "getBlocks"};
    }

    public Object[] invoke(int method, Object[] arguments) throws Exception {
        if (this.getEnergy() < 400.0) {
            throw new Exception("Radar has insufficient electricity!");
        }
        HashMap<String, Double> returnArray = new HashMap<String, Double>();
        int count = 0;
        switch (method) {
            case 0: {
                List<Entity> entities = RadarRegistry.getEntitiesWithinRadius(new Vector2(new Pos3D((TileEntity)this)), this.alarmRange);
                for (Entity entity : entities) {
                    returnArray.put("x_" + count, entity.field_70165_t);
                    returnArray.put("y_" + count, entity.field_70163_u);
                    returnArray.put("z_" + count, entity.field_70161_v);
                    ++count;
                }
                return new Object[]{returnArray};
            }
            case 1: {
                for (TileEntity jiQi : RadarRegistry.getTileEntitiesInArea(new Vector2(this.field_145851_c - 500, this.field_145849_e - 500), new Vector2(this.field_145851_c + 500, this.field_145849_e + 500))) {
                    returnArray.put("x_" + count, Double.valueOf(jiQi.field_145851_c));
                    returnArray.put("y_" + count, Double.valueOf(jiQi.field_145848_d));
                    returnArray.put("z_" + count, Double.valueOf(jiQi.field_145849_e));
                    ++count;
                }
                return new Object[]{returnArray};
            }
        }
        throw new Exception("Invalid Radar Function.");
    }

    public void func_145843_s() {
        FrequencyGrid.instance().unregister(this);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        RadarRegistry.unregister((TileEntity)this);
        super.func_145843_s();
    }
}

