/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon;

import net.minecraftforge.common.config.Configuration;

public class DragonMountsConfig {
    private boolean eggsInChests = false;
    private int dragonEntityID = -1;
    private boolean debug = false;

    public DragonMountsConfig(Configuration config) {
        this.eggsInChests = config.getBoolean("eggsInChests", "server", this.eggsInChests, "Spawns dragon eggs in generated chests when enabled");
        this.dragonEntityID = config.getInt("dragonEntityID", "server", this.dragonEntityID, -1, 255, "Overrides the entity ID for dragons to fix problems with manual IDs from other mods.\nSet to -1 for automatic assignment (recommended).\nWarning: wrong values may cause crashes and loss of data!");
        this.debug = config.getBoolean("debug", "client", this.debug, "Debug mode. Unless you're a developer or are told to activate it, you don't want to set this to true.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public boolean isEggsInChests() {
        return this.eggsInChests;
    }

    public int getDragonEntityID() {
        return this.dragonEntityID;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

