/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.render;

import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.client.forgeobjmodelported.AdvancedModelLoader;
import info.ata4.minecraft.dragon.client.forgeobjmodelported.IModelCustom;
import info.ata4.minecraft.dragon.client.model.DragonModel;
import info.ata4.minecraft.dragon.client.render.LayerRendererDragonGlow;
import info.ata4.minecraft.dragon.client.render.LayerRendererDragonSaddle;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedRegistry;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStageHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class DragonRenderer
extends RenderLiving {
    public static final String TEX_BASE = "textures/entities/dragon/";
    public static final String MDL_BASE = "models/entities/dragon/";
    public static boolean updateModel;
    private final Map<DragonBreed, DragonModel> breedModels = new HashMap<DragonBreed, DragonModel>();
    private final ResourceLocation dissolveTextureLoc = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/dissolve.png");
    private final ResourceLocation eggModelLoc = new ResourceLocation(DragonMounts.AID, "models/entities/dragon/dragon_egg.obj");
    private final IModelCustom eggModel = AdvancedModelLoader.loadModel(this.eggModelLoc);
    private DragonModel dragonModel;

    public DragonRenderer(RenderManager renderManager) {
        super(renderManager, null, 2.0f);
        this.func_177094_a(new LayerRendererDragonSaddle(this));
        this.func_177094_a(new LayerRendererDragonGlow(this));
        this.initBreedModels();
    }

    private void initBreedModels() {
        this.breedModels.clear();
        for (DragonBreed breed : DragonBreedRegistry.getInstance().getBreeds()) {
            this.breedModels.put(breed, new DragonModel(breed));
        }
    }

    private void setModel(DragonBreed breed) {
        this.dragonModel = this.breedModels.get(breed);
        this.field_77045_g = this.dragonModel;
    }

    public DragonModel getModel() {
        return this.dragonModel;
    }

    public void func_76986_a(EntityLiving entity, double x, double y, double z, float yaw, float partialTicks) {
        this.doRender((EntityTameableDragon)entity, x, y, z, yaw, partialTicks);
    }

    public void doRender(EntityTameableDragon dragon, double x, double y, double z, float yaw, float partialTicks) {
        this.setModel(dragon.getBreed());
        this.passSpecialRender2((EntityLivingBase)dragon, x, y, z);
        if (dragon.isEgg()) {
            this.renderEgg(dragon, x, y, z, yaw, partialTicks);
        } else {
            super.func_76986_a((EntityLiving)dragon, x, y, z, yaw, partialTicks);
        }
    }

    protected void func_77036_a(EntityLivingBase entity, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        this.renderModel((EntityTameableDragon)entity, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderModel(EntityTameableDragon dragon, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        this.dragonModel.renderPass = DragonModel.RenderPass.MAIN;
        if (dragon.getDeathTime() > 0) {
            float alpha = (float)dragon.getDeathTime() / (float)dragon.getMaxDeathTime();
            try {
                GL11.glPushAttrib((int)16640);
                GL11.glDepthFunc((int)515);
                GL11.glEnable((int)3008);
                GL11.glAlphaFunc((int)516, (float)alpha);
                this.func_110776_a(this.dissolveTextureLoc);
                this.dragonModel.render(dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glDepthFunc((int)514);
                super.func_77036_a((EntityLivingBase)dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
            }
            finally {
                GL11.glPopAttrib();
            }
        } else {
            super.func_77036_a((EntityLivingBase)dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
        }
    }

    protected void renderEgg(EntityTameableDragon dragon, double x, double y, double z, float pitch, float partialTicks) {
        DragonLifeStageHelper lifeStage = dragon.getLifeStageHelper();
        float tickX = lifeStage.getEggWiggleX();
        float tickZ = lifeStage.getEggWiggleZ();
        float rotX = 0.0f;
        float rotZ = 0.0f;
        if (tickX > 0.0f) {
            rotX = (float)Math.sin(tickX - partialTicks) * 8.0f;
        }
        if (tickZ > 0.0f) {
            rotZ = (float)Math.sin(tickZ - partialTicks) * 8.0f;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_110776_a(this.dragonModel.getEggTexture());
        this.eggModel.renderAll();
        GL11.glPopMatrix();
    }

    protected void func_77043_a(EntityLivingBase par1EntityLiving, float par2, float par3, float par4) {
        this.rotateCorpse((EntityTameableDragon)par1EntityLiving, par2, par3, par4);
    }

    protected void rotateCorpse(EntityTameableDragon dragon, float par2, float par3, float par4) {
        GL11.glRotatef((float)(180.0f - par3), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected void func_77041_b(EntityLivingBase entity, float partialTicks) {
        this.preRenderCallback((EntityTameableDragon)entity, partialTicks);
    }

    protected void preRenderCallback(EntityTameableDragon dragon, float partialTicks) {
        float scale = dragon.getScale() * 0.8f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getEntityTexture((EntityTameableDragon)entity);
    }

    protected ResourceLocation getEntityTexture(EntityTameableDragon dragon) {
        return this.dragonModel.bodyTexture;
    }

    protected void passSpecialRender2(EntityLivingBase par1EntityLiving, double par2, double par4, double par6) {
        super.func_77033_b(par1EntityLiving, par2, par4, par6);
    }
}

