/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server;

import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.server.cmd.CommandDragon;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.handler.DragonEggBlockHandler;
import info.ata4.minecraft.dragon.server.network.DragonControlMessage;
import info.ata4.minecraft.dragon.server.network.DragonControlMessageHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    private SimpleNetworkWrapper network;
    public final byte DCM_DISCRIMINATOR_ID = (byte)35;

    public SimpleNetworkWrapper getNetwork() {
        return this.network;
    }

    public void onInit(FMLInitializationEvent evt) {
        this.registerEntities();
        if (DragonMounts.instance.getConfig().isEggsInChests()) {
            this.registerChestItems();
        }
        MinecraftForge.EVENT_BUS.register((Object)new DragonEggBlockHandler());
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel("DragonControls");
        this.network.registerMessage(DragonControlMessageHandler.class, DragonControlMessage.class, 35, Side.SERVER);
    }

    public void onPostInit(FMLPostInitializationEvent event) {
    }

    public void onServerStarted(FMLServerStartedEvent evt) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ServerCommandManager cmdman = (ServerCommandManager)server.func_71187_D();
        cmdman.func_71560_a((ICommand)new CommandDragon());
    }

    public void onServerStopped(FMLServerStoppedEvent evt) {
    }

    private void registerEntities() {
        int TRACKING_RANGE = 80;
        int UPDATE_FREQUENCY = 3;
        int DRAGON_ENTITY_ID = 26;
        EntityRegistry.registerModEntity(EntityTameableDragon.class, (String)"DragonMount", (int)26, (Object)DragonMounts.instance, (int)80, (int)3, (boolean)true);
    }

    public void registerChestItems() {
        ChestGenHooks chestGenHooksDungeon = ChestGenHooks.getInfo((String)"dungeonChest");
        chestGenHooksDungeon.addItem(new WeightedRandomChestContent(new ItemStack(Blocks.field_150380_bt), 1, 1, 70));
        ChestGenHooks chestGenHooksMineshaft = ChestGenHooks.getInfo((String)"mineshaftCorridor");
        chestGenHooksMineshaft.addItem(new WeightedRandomChestContent(new ItemStack(Blocks.field_150380_bt), 1, 1, 5));
        ChestGenHooks chestGenHooksJungleChest = ChestGenHooks.getInfo((String)"pyramidJungleChest");
        chestGenHooksJungleChest.addItem(new WeightedRandomChestContent(new ItemStack(Blocks.field_150380_bt), 1, 1, 15));
        ChestGenHooks chestGenHooksDesertChest = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
        chestGenHooksDesertChest.addItem(new WeightedRandomChestContent(new ItemStack(Blocks.field_150380_bt), 1, 1, 10));
    }
}

