/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.cmd;

import info.ata4.minecraft.dragon.server.cmd.BreedModifier;
import info.ata4.minecraft.dragon.server.cmd.EntityModifier;
import info.ata4.minecraft.dragon.server.cmd.LifeStageModifier;
import info.ata4.minecraft.dragon.server.cmd.TameModifier;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedRegistry;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.StringUtils;

public class CommandDragon
extends CommandBase {
    private final List<String> commandNames;
    private final List<String> breedNames;
    private final List<String> lifeStageNames;

    public CommandDragon() {
        Command[] commands = Command.values();
        this.commandNames = new ArrayList<String>(commands.length);
        for (Command command : commands) {
            this.commandNames.add(command.name().toLowerCase());
        }
        List<DragonBreed> breeds = DragonBreedRegistry.getInstance().getBreeds();
        this.breedNames = new ArrayList<String>(breeds.size());
        for (DragonBreed breed : breeds) {
            this.breedNames.add(breed.getName().toLowerCase());
        }
        DragonLifeStage[] lifeStages = DragonLifeStage.values();
        this.lifeStageNames = new ArrayList<String>(lifeStages.length);
        for (DragonLifeStage lifeStage : lifeStages) {
            this.lifeStageNames.add(lifeStage.name().toLowerCase());
        }
    }

    public String func_71517_b() {
        return "dragon";
    }

    public String func_71518_a(ICommandSender sender) {
        String commands = StringUtils.join(this.commandNames, (char)'|');
        return String.format("/dragon <%s> [global]", commands);
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandDragon.func_175762_a((String[])args, this.commandNames);
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("stage")) {
                return CommandDragon.func_175762_a((String[])args, this.lifeStageNames);
            }
            if (args[0].equalsIgnoreCase("breed")) {
                return CommandDragon.func_175762_a((String[])args, this.breedNames);
            }
        }
        return null;
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_71515_b(ICommandSender sender, String[] params) throws CommandException {
        Command cmd;
        if (params.length < 1 || params[0].isEmpty()) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        boolean global = params[params.length - 1].equalsIgnoreCase("global");
        try {
            cmd = Command.valueOf(params[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (cmd) {
            case STAGE: {
                if (params.length < 2) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                DragonLifeStage lifeStage = null;
                String parameter = params[1].toUpperCase();
                if (!parameter.equals("ITEM")) {
                    try {
                        lifeStage = DragonLifeStage.valueOf(parameter);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new SyntaxErrorException();
                    }
                }
                LifeStageModifier modifier = new LifeStageModifier(lifeStage);
                this.applyModifier(sender, modifier, global);
                break;
            }
            case BREED: {
                if (params.length < 2) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                String breedName = params[1].toLowerCase();
                DragonBreed breed = DragonBreedRegistry.getInstance().getBreedByName(breedName);
                if (breed == null) {
                    throw new SyntaxErrorException();
                }
                this.applyModifier(sender, new BreedModifier(breed), global);
                break;
            }
            case TAME: {
                if (sender instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)sender;
                    this.applyModifier(sender, new TameModifier(player), global);
                    break;
                }
                throw new CommandException("commands.dragon.canttame", new Object[0]);
            }
        }
    }

    private void applyModifier(ICommandSender sender, EntityModifier modifier, boolean global) throws CommandException {
        if (!global && sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = CommandDragon.func_71521_c((ICommandSender)sender);
            double range = 64.0;
            AxisAlignedBB aabb = new AxisAlignedBB(player.field_70165_t - 1.0, player.field_70163_u - 1.0, player.field_70161_v - 1.0, player.field_70165_t + 1.0, player.field_70163_u + 1.0, player.field_70161_v + 1.0);
            aabb = aabb.func_72314_b(range, range, range);
            List entities = player.field_70170_p.func_72872_a(EntityTameableDragon.class, aabb);
            Entity closestEntity = null;
            float minPlayerDist = Float.MAX_VALUE;
            for (Entity entity : entities) {
                float playerDist = entity.func_70032_d((Entity)player);
                if (!(entity.func_70032_d((Entity)player) < minPlayerDist)) continue;
                closestEntity = entity;
                minPlayerDist = playerDist;
            }
            if (closestEntity == null) {
                throw new CommandException("commands.dragon.nodragons", new Object[0]);
            }
            modifier.modify((EntityTameableDragon)closestEntity);
        } else {
            MinecraftServer server = MinecraftServer.func_71276_C();
            for (WorldServer worldServer : server.field_71305_c) {
                List entities = worldServer.field_72996_f;
                for (Entity entity : entities) {
                    if (!(entity instanceof EntityTameableDragon)) continue;
                    modifier.modify((EntityTameableDragon)entity);
                }
            }
        }
    }

    private static enum Command {
        STAGE,
        BREED,
        TAME;

    }
}

