/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;

public class DragonFlightWaypoint {
    private static final String NBT_WAYPOINT_X = "Waypoint-X";
    private static final String NBT_WAYPOINT_Y = "Waypoint-Y";
    private static final String NBT_WAYPOINT_Z = "Waypoint-Z";
    public int posX;
    public int posY;
    public int posZ;
    private final Entity entity;

    public DragonFlightWaypoint(Entity entity) {
        this.entity = entity;
    }

    public void set(int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void set(double x, double y, double z) {
        this.posX = (int)x;
        this.posY = (int)y;
        this.posZ = (int)z;
    }

    public void setBlockPos(BlockPos bp) {
        this.posX = bp.func_177958_n();
        this.posY = bp.func_177956_o();
        this.posZ = bp.func_177952_p();
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public void setVector(Vec3 vec) {
        this.posX = (int)vec.field_72450_a;
        this.posY = (int)vec.field_72448_b;
        this.posZ = (int)vec.field_72449_c;
    }

    public void setEntity(Entity target) {
        this.posX = (int)target.field_70165_t;
        this.posY = (int)target.field_70163_u;
        this.posZ = (int)target.field_70161_v;
    }

    public Vec3 toVector() {
        return new Vec3((double)this.posX, (double)this.posY, (double)this.posZ);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_WAYPOINT_X, this.posX);
        nbt.func_74768_a(NBT_WAYPOINT_Y, this.posY);
        nbt.func_74768_a(NBT_WAYPOINT_Z, this.posZ);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.posX = nbt.func_74762_e(NBT_WAYPOINT_X);
        this.posY = nbt.func_74762_e(NBT_WAYPOINT_Y);
        this.posZ = nbt.func_74762_e(NBT_WAYPOINT_Z);
    }

    public double getDeltaX() {
        return (double)this.posX - this.entity.field_70165_t;
    }

    public double getDeltaY() {
        return (double)this.posY - this.entity.field_70163_u;
    }

    public double getDeltaZ() {
        return (double)this.posZ - this.entity.field_70161_v;
    }

    public double getDistanceSquare() {
        double deltaX = this.getDeltaX();
        double deltaY = this.getDeltaY();
        double deltaZ = this.getDeltaZ();
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public double getDistance() {
        return Math.sqrt(this.getDistanceSquare());
    }

    public boolean isNear() {
        return this.getDistanceSquare() < (double)(this.entity.field_70130_N * this.entity.field_70130_N);
    }

    public void clear() {
        this.posX = (int)this.entity.field_70165_t;
        this.posY = (int)this.entity.field_70163_u;
        this.posZ = (int)this.entity.field_70161_v;
    }

    public String toString() {
        return this.posX + ", " + this.posY + ", " + this.posZ;
    }
}

