/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.util.math.MathX;
import net.minecraft.util.MathHelper;

public enum DragonLifeStage {
    EGG(0, 24000, 0.25f),
    HATCHLING(24000, 24000, 0.33f),
    JUVENILE(48000, 24000, 0.66f),
    ADULT(72000, -1, 1.0f);

    public final int startTicks;
    public final int durationTicks;
    public final float scale;

    private DragonLifeStage(int startTicks, int durationTicks, float scale) {
        this.startTicks = startTicks;
        this.durationTicks = durationTicks;
        this.scale = scale;
    }

    public static DragonLifeStage getLifeStageFromTickCount(int ticksSinceCreation) {
        if (ticksSinceCreation < DragonLifeStage.HATCHLING.startTicks) {
            return EGG;
        }
        if (ticksSinceCreation < DragonLifeStage.JUVENILE.startTicks) {
            return HATCHLING;
        }
        if (ticksSinceCreation < DragonLifeStage.ADULT.startTicks) {
            return JUVENILE;
        }
        return ADULT;
    }

    public static float getScaleFromTickCount(int ticksSinceCreation) {
        DragonLifeStage lifeStage = DragonLifeStage.getLifeStageFromTickCount(ticksSinceCreation);
        int timeInThisStage = ticksSinceCreation - lifeStage.startTicks;
        float fractionOfStage = (float)timeInThisStage / (float)lifeStage.durationTicks;
        switch (lifeStage) {
            case EGG: {
                return DragonLifeStage.EGG.scale;
            }
            case ADULT: {
                return DragonLifeStage.ADULT.scale;
            }
            case HATCHLING: {
                return MathX.lerp(DragonLifeStage.HATCHLING.scale, DragonLifeStage.JUVENILE.scale, fractionOfStage);
            }
            case JUVENILE: {
                return MathX.lerp(DragonLifeStage.JUVENILE.scale, DragonLifeStage.ADULT.scale, fractionOfStage);
            }
        }
        throw new RuntimeException("Unimplemented life stage: " + (Object)((Object)lifeStage));
    }

    public static int clipTickCountToValid(int ticksSinceCreation) {
        return MathHelper.func_76125_a((int)ticksSinceCreation, (int)DragonLifeStage.EGG.startTicks, (int)DragonLifeStage.ADULT.durationTicks);
    }
}

