/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.ai.air.EntityAICatchOwnerAir;
import info.ata4.minecraft.dragon.server.entity.ai.air.EntityAILand;
import info.ata4.minecraft.dragon.server.entity.ai.air.EntityAIRideAir;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAICatchOwnerGround;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIDragonFollowOwner;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIDragonMate;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIHunt;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIPanicChild;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIRideGround;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIWatchIdle;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIWatchLiving;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStage;
import info.ata4.minecraft.dragon.server.entity.helper.DragonScaleModifier;
import info.ata4.minecraft.dragon.server.util.ClientServerSynchronisedTickCount;
import info.ata4.minecraft.dragon.server.util.EntityClassPredicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonLifeStageHelper
extends DragonHelper {
    private static final Logger L = LogManager.getLogger();
    private static final String NBT_TICKS_SINCE_CREATION = "TicksSinceCreation";
    private static final int TICKS_SINCE_CREATION_UPDATE_INTERVAL = 100;
    private DragonLifeStage lifeStagePrev;
    private final DragonScaleModifier scaleModifier = new DragonScaleModifier();
    private int eggWiggleX;
    private int eggWiggleZ;
    private final int dataIndexTicksSinceCreation;
    private int ticksSinceCreationServer;
    private final ClientServerSynchronisedTickCount ticksSinceCreationClient;

    public DragonLifeStageHelper(EntityTameableDragon dragon, int dataWatcherIndex) {
        super(dragon);
        this.dataIndexTicksSinceCreation = dataWatcherIndex;
        this.ticksSinceCreationServer = 0;
        this.dataWatcher.func_75682_a(this.dataIndexTicksSinceCreation, (Object)this.ticksSinceCreationServer);
        this.ticksSinceCreationClient = new ClientServerSynchronisedTickCount(100);
        this.ticksSinceCreationClient.reset(this.ticksSinceCreationServer);
    }

    @Override
    public void applyEntityAttributes() {
        this.scaleModifier.setScale(this.getScale());
        this.dragon.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a((AttributeModifier)this.scaleModifier);
        this.dragon.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a((AttributeModifier)this.scaleModifier);
    }

    public void playEggCrackEffect() {
        int bx = (int)Math.round(this.dragon.field_70165_t - 0.5);
        int by = (int)Math.round(this.dragon.field_70163_u);
        int bz = (int)Math.round(this.dragon.field_70161_v - 0.5);
        this.dragon.field_70170_p.func_175718_b(2001, new BlockPos(bx, by, bz), Block.func_149682_b((Block)Blocks.field_150380_bt));
    }

    public int getEggWiggleX() {
        return this.eggWiggleX;
    }

    public int getEggWiggleZ() {
        return this.eggWiggleZ;
    }

    public DragonLifeStage getLifeStage() {
        int age = this.getTicksSinceCreation();
        return DragonLifeStage.getLifeStageFromTickCount(age);
    }

    public int getTicksSinceCreation() {
        if (!this.dragon.field_70170_p.field_72995_K) {
            return this.ticksSinceCreationServer;
        }
        return this.ticksSinceCreationClient.getCurrentTickCount();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_TICKS_SINCE_CREATION, this.getTicksSinceCreation());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int ticksRead = nbt.func_74762_e(NBT_TICKS_SINCE_CREATION);
        this.ticksSinceCreationServer = ticksRead = DragonLifeStage.clipTickCountToValid(ticksRead);
        this.dataWatcher.func_75692_b(this.dataIndexTicksSinceCreation, (Object)this.ticksSinceCreationServer);
    }

    public float getScale() {
        DragonLifeStage lifeStage = this.getLifeStage();
        int stageStartTicks = lifeStage.startTicks;
        int timeInThisStage = this.getTicksSinceCreation() - stageStartTicks;
        float fractionOfStage = (float)timeInThisStage / (float)lifeStage.durationTicks;
        fractionOfStage = MathHelper.func_76131_a((float)fractionOfStage, (float)0.0f, (float)1.0f);
        float EGG_SIZE = 0.225f;
        float HATCHLING_SIZE = 0.33f;
        float JUVENILE_SIZE = 0.66f;
        float ADULT_SIZE = 1.0f;
        switch (this.getLifeStage()) {
            case EGG: {
                return 0.225f;
            }
            case HATCHLING: {
                return 0.33f + fractionOfStage * 0.33f;
            }
            case JUVENILE: {
                return 0.66f + fractionOfStage * 0.33999997f;
            }
            case ADULT: {
                return 1.0f;
            }
        }
        L.error("Illegal lifestage in getScale():" + (Object)((Object)this.getLifeStage()));
        return 1.0f;
    }

    public void transformToEgg() {
        if (this.dragon.func_110143_aJ() <= 0.0f) {
            return;
        }
        L.debug("transforming to egg");
        float volume = 1.0f;
        float pitch = 0.5f + (0.5f - this.rand.nextFloat()) * 0.1f;
        this.dragon.field_70170_p.func_72956_a((Entity)this.dragon, "mob.endermen.portal", volume, pitch);
        if (this.dragon.isSaddled()) {
            this.dragon.func_145779_a(Items.field_151141_av, 1);
        }
        this.dragon.func_70099_a(new ItemStack(Blocks.field_150380_bt), 0.0f);
        this.dragon.func_70106_y();
    }

    public final void setLifeStage(DragonLifeStage lifeStage) {
        L.trace("setLifeStage({})", new Object[]{lifeStage});
        if (!this.dragon.field_70170_p.field_72995_K) {
            this.ticksSinceCreationServer = lifeStage.startTicks;
            this.dataWatcher.func_75692_b(this.dataIndexTicksSinceCreation, (Object)this.ticksSinceCreationServer);
        } else {
            L.error("setLifeStage called on Client");
        }
        this.updateLifeStage();
    }

    private void onNewLifeStage(DragonLifeStage lifeStage, DragonLifeStage prevLifeStage) {
        L.trace("onNewLifeStage({},{})", new Object[]{prevLifeStage, lifeStage});
        if (this.dragon.isClient()) {
            if (prevLifeStage != null && prevLifeStage == DragonLifeStage.EGG && lifeStage == DragonLifeStage.HATCHLING) {
                this.playEggCrackEffect();
            }
        } else {
            this.dragon.setCanFly(lifeStage != DragonLifeStage.EGG && lifeStage != DragonLifeStage.HATCHLING);
            if (this.dragon.func_70661_as() instanceof PathNavigateGround) {
                PathNavigateGround pathNavigateGround = (PathNavigateGround)this.dragon.func_70661_as();
                pathNavigateGround.func_179691_c(lifeStage == DragonLifeStage.HATCHLING);
            }
            this.changeAITasks(lifeStage, prevLifeStage);
            IAttributeInstance healthAttrib = this.dragon.func_110148_a(SharedMonsterAttributes.field_111267_a);
            IAttributeInstance damageAttrib = this.dragon.func_110148_a(SharedMonsterAttributes.field_111264_e);
            healthAttrib.func_111124_b((AttributeModifier)this.scaleModifier);
            damageAttrib.func_111124_b((AttributeModifier)this.scaleModifier);
            this.scaleModifier.setScale(this.getScale());
            healthAttrib.func_111121_a((AttributeModifier)this.scaleModifier);
            damageAttrib.func_111121_a((AttributeModifier)this.scaleModifier);
            this.dragon.func_70606_j(this.dragon.func_110138_aP());
        }
    }

    @Override
    public void onLivingUpdate() {
        if (!this.dragon.field_70170_p.field_72995_K) {
            if (this.getLifeStage() != DragonLifeStage.ADULT) {
                ++this.ticksSinceCreationServer;
                if (this.ticksSinceCreationServer % 100 == 0) {
                    this.dataWatcher.func_75692_b(this.dataIndexTicksSinceCreation, (Object)this.ticksSinceCreationServer);
                }
            }
        } else {
            this.ticksSinceCreationClient.updateFromServer(this.dataWatcher.func_75679_c(this.dataIndexTicksSinceCreation));
            if (this.getLifeStage() != DragonLifeStage.ADULT) {
                this.ticksSinceCreationClient.tick();
            }
        }
        this.updateLifeStage();
        this.updateEgg();
        this.updateScale();
    }

    private void updateLifeStage() {
        DragonLifeStage lifeStage = this.getLifeStage();
        if (this.lifeStagePrev != lifeStage) {
            this.onNewLifeStage(lifeStage, this.lifeStagePrev);
            this.lifeStagePrev = lifeStage;
        }
    }

    private void updateEgg() {
        int hatchAge;
        if (!this.isEgg()) {
            return;
        }
        int age = this.getTicksSinceCreation();
        float fractionComplete = (float)age / (float)(hatchAge = DragonLifeStage.HATCHLING.durationTicks);
        if (fractionComplete > 0.66f) {
            float wiggleChance = fractionComplete / 60.0f;
            if (this.eggWiggleX > 0) {
                --this.eggWiggleX;
            } else if (this.rand.nextFloat() < wiggleChance) {
                this.eggWiggleX = this.rand.nextBoolean() ? 10 : 20;
                this.playEggCrackEffect();
            }
            if (this.eggWiggleZ > 0) {
                --this.eggWiggleZ;
            } else if (this.rand.nextFloat() < wiggleChance) {
                this.eggWiggleZ = this.rand.nextBoolean() ? 10 : 20;
                this.playEggCrackEffect();
            }
        }
        double px = this.dragon.field_70165_t + (this.rand.nextDouble() - 0.5);
        double py = this.dragon.field_70163_u + (this.rand.nextDouble() - 0.5);
        double pz = this.dragon.field_70161_v + (this.rand.nextDouble() - 0.5);
        double ox = (this.rand.nextDouble() - 0.5) * 2.0;
        double oy = (this.rand.nextDouble() - 0.5) * 2.0;
        double oz = (this.rand.nextDouble() - 0.5) * 2.0;
        this.dragon.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, px, py, pz, ox, oy, oz, new int[0]);
    }

    private void updateScale() {
        this.dragon.setScalePublic(this.getScale());
    }

    @Override
    public void onDeath() {
        if (this.dragon.isClient() && this.isEgg()) {
            this.playEggCrackEffect();
        }
    }

    public boolean isEgg() {
        return this.getLifeStage() == DragonLifeStage.EGG;
    }

    public boolean isHatchling() {
        return this.getLifeStage() == DragonLifeStage.HATCHLING;
    }

    public boolean isJuvenile() {
        return this.getLifeStage() == DragonLifeStage.JUVENILE;
    }

    public boolean isAdult() {
        return this.getLifeStage() == DragonLifeStage.ADULT;
    }

    private void changeAITasks(DragonLifeStage newLifeStage, DragonLifeStage previousLifeStage) {
        EntityAIBase entityAIBase;
        if (newLifeStage != null && previousLifeStage != null) {
            if (newLifeStage == previousLifeStage) {
                return;
            }
            if (newLifeStage != DragonLifeStage.EGG && previousLifeStage != DragonLifeStage.EGG) {
                return;
            }
        }
        EntityAITasks tasks = this.dragon.field_70714_bg;
        EntityAITasks airTasks = this.dragon.airTasks;
        EntityAITasks targetTasks = this.dragon.field_70715_bh;
        while (!tasks.field_75782_a.isEmpty()) {
            entityAIBase = ((EntityAITasks.EntityAITaskEntry)tasks.field_75782_a.get((int)0)).field_75733_a;
            tasks.func_85156_a(entityAIBase);
        }
        while (!airTasks.field_75782_a.isEmpty()) {
            entityAIBase = ((EntityAITasks.EntityAITaskEntry)airTasks.field_75782_a.get((int)0)).field_75733_a;
            airTasks.func_85156_a(entityAIBase);
        }
        while (!targetTasks.field_75782_a.isEmpty()) {
            entityAIBase = ((EntityAITasks.EntityAITaskEntry)targetTasks.field_75782_a.get((int)0)).field_75733_a;
            targetTasks.func_85156_a(entityAIBase);
        }
        if (newLifeStage == DragonLifeStage.EGG) {
            return;
        }
        tasks.func_75776_a(0, (EntityAIBase)new EntityAICatchOwnerGround(this.dragon));
        tasks.func_75776_a(1, (EntityAIBase)new EntityAIRideGround(this.dragon, 1.0));
        tasks.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this.dragon));
        tasks.func_75776_a(3, (EntityAIBase)this.dragon.func_70907_r());
        tasks.func_75776_a(4, (EntityAIBase)new EntityAIDragonMate(this.dragon, 0.6));
        tasks.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this.dragon, 0.75, EntityTameableDragon.FAVORITE_FOOD, false));
        tasks.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this.dragon, 1.0, true));
        tasks.func_75776_a(7, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this.dragon, 0.8));
        tasks.func_75776_a(8, (EntityAIBase)new EntityAIDragonFollowOwner(this.dragon, 1.0, 12.0f, 128.0f));
        tasks.func_75776_a(8, (EntityAIBase)new EntityAIPanicChild(this.dragon, 1.0));
        tasks.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this.dragon, 1.0));
        tasks.func_75776_a(10, (EntityAIBase)new EntityAIWatchIdle((EntityLiving)this.dragon));
        tasks.func_75776_a(10, (EntityAIBase)new EntityAIWatchLiving(this.dragon, 16.0f, 0.05f));
        airTasks.func_75776_a(0, (EntityAIBase)new EntityAIRideAir(this.dragon));
        airTasks.func_75776_a(0, (EntityAIBase)new EntityAILand(this.dragon));
        airTasks.func_75776_a(0, (EntityAIBase)new EntityAICatchOwnerAir(this.dragon));
        targetTasks.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this.dragon));
        targetTasks.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this.dragon));
        targetTasks.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this.dragon, false, new Class[0]));
        targetTasks.func_75776_a(4, (EntityAIBase)new EntityAIHunt(this.dragon, EntityAnimal.class, false, new EntityClassPredicate(EntitySheep.class, EntityPig.class, EntityChicken.class, EntityRabbit.class)));
    }
}

