/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.network;

import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DragonControlMessage
implements IMessage {
    private final BitSet bits = new BitSet(8);
    private int previous;

    public BitSet getFlags() {
        return this.bits;
    }

    public void fromBytes(ByteBuf buf) {
        this.fromInteger(buf.readUnsignedByte());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.toInteger());
    }

    public void fromInteger(int value) {
        this.bits.clear();
        for (int i = 0; i < this.bits.size(); ++i) {
            if ((value & 1 << i) == 0) continue;
            this.bits.set(i);
        }
    }

    public int toInteger() {
        int value = 0;
        for (int i = 0; i < this.bits.length(); ++i) {
            value += this.bits.get(i) ? 1 << i : 0;
        }
        return value;
    }

    public boolean hasChanged() {
        int current = this.toInteger();
        boolean changed = this.previous != current;
        this.previous = current;
        return changed;
    }
}

