/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.network;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.network.DragonControlMessage;
import io.netty.channel.ChannelHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ChannelHandler.Sharable
public class DragonControlMessageHandler
implements IMessageHandler<DragonControlMessage, IMessage> {
    private static final Logger L = LogManager.getLogger();

    public IMessage onMessage(final DragonControlMessage message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            L.warn("DragonControlMessage received on wrong side:" + ctx.side);
            return null;
        }
        final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
        if (sendingPlayer == null) {
            L.warn("EntityPlayerMP was null when DragonControlMessage was received");
            return null;
        }
        WorldServer playerWorldServer = sendingPlayer.func_71121_q();
        playerWorldServer.func_152344_a(new Runnable(){

            @Override
            public void run() {
                DragonControlMessageHandler.this.processMessage(message, sendingPlayer);
            }
        });
        return null;
    }

    void processMessage(DragonControlMessage message, EntityPlayerMP sendingPlayer) {
        if (sendingPlayer.field_70154_o instanceof EntityTameableDragon) {
            EntityTameableDragon dragon = (EntityTameableDragon)sendingPlayer.field_70154_o;
            dragon.setControlFlags(message.getFlags());
        }
    }
}

