/*
 * Decompiled with CFR 0.152.
 */
package de.stuuupiiid.dungeonpack;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public abstract class DungeonGenerator {
    protected World world = MinecraftServer.func_71276_C().func_71218_a(0);

    public abstract boolean generate(Random var1, int var2, int var3, int var4);

    public boolean generateNether(Random var1, int var2, int var3, int var4) {
        this.world = MinecraftServer.func_71276_C().func_71218_a(-1);
        this.generate(var1, var2, var3, var4);
        this.world = MinecraftServer.func_71276_C().func_71218_a(0);
        return true;
    }

    public boolean generateEnd(Random var1, int var2, int var3, int var4) {
        this.world = MinecraftServer.func_71276_C().func_71218_a(1);
        this.generate(var1, var2, var3, var4);
        this.world = MinecraftServer.func_71276_C().func_71218_a(0);
        return true;
    }

    public void addBlock(int par1, int par2, int par3, int par4) {
        this.world.func_147465_d(par1, par2, par3, Block.func_149729_e((int)par4), 0, 2);
    }

    public void addBlockSecond(int par1, int par2, int par3, int par4) {
        this.world.func_147465_d(par1, par2, par3, Block.func_149729_e((int)par4), 0, 2);
    }

    public void setMetadata(int par1, int par2, int par3, int par4) {
        this.world.func_72921_c(par1, par2, par3, par4, 2);
    }

    public int getBlock(int par1, int par2, int par3) {
        return Block.func_149682_b((Block)this.world.func_147439_a(par1, par2, par3));
    }

    public void addBlockAndMetadata(int par1, int par2, int par3, int par4, int par5) {
        this.world.func_147465_d(par1, par2, par3, Block.func_149729_e((int)par4), par5, 2);
    }

    public int getMetadata(int par1, int par2, int par3) {
        return this.world.func_72805_g(par1, par2, par3);
    }

    public int getTop(int par1, int par2) {
        return this.world.func_72976_f(par1, par2);
    }

    public void addAir(int par1, int par2, int par3) {
        this.world.func_147468_f(par1, par2, par3);
    }

    public void addMobSpawner(int par1, int par2, int par3, String par4String) {
        this.addBlock(par1, par2, par3, 52);
        TileEntityMobSpawner mobSpawner = (TileEntityMobSpawner)this.world.func_147438_o(par1, par2, par3);
        if (mobSpawner != null) {
            mobSpawner.func_145881_a().func_98272_a(par4String);
        }
    }

    public void addChestWithDefaultLoot(Random random, int par1, int par2, int par3) {
        this.addBlock(par1, par2, par3, 54);
        TileEntityChest chest = (TileEntityChest)this.world.func_147438_o(par1, par2, par3);
        if (chest != null) {
            for (int var1 = 0; var1 < ChestGenHooks.getCount((String)"dungeonChest", (Random)random); ++var1) {
                ItemStack loot = ChestGenHooks.getOneItem((String)"dungeonChest", (Random)random);
                if (loot == null) continue;
                chest.func_70299_a(random.nextInt(chest.func_70302_i_()), loot);
            }
        }
    }

    public void addChestWithMagicalLoot(Random random, int par1, int par2, int par3) {
        this.addBlock(par1, par2, par3, 54);
        TileEntityChest chest = (TileEntityChest)this.world.func_147438_o(par1, par2, par3);
        if (chest != null) {
            for (int var1 = 0; var1 < ChestGenHooks.getCount((String)"dungeonChest", (Random)random); ++var1) {
                ItemStack loot = this.getMagicalLoot(random);
                if (loot == null) continue;
                chest.func_70299_a(random.nextInt(chest.func_70302_i_()), loot);
            }
        }
    }

    private ItemStack getMagicalLoot(Random random) {
        int var2 = random.nextInt(11);
        return var2 == 0 && random.nextBoolean() ? new ItemStack(Item.func_150899_d((int)379)) : (var2 == 1 ? new ItemStack(Item.func_150899_d((int)372), random.nextInt(3) + 1) : (var2 == 2 ? new ItemStack(Item.func_150899_d((int)340), random.nextInt(3) + 1) : (var2 == 3 ? new ItemStack(Item.func_150899_d((int)340), random.nextInt(3) + 1) : (var2 == 5 && random.nextBoolean() ? new ItemStack(Block.func_149729_e((int)47), random.nextInt(2) + 1) : (var2 == 6 ? new ItemStack(Item.func_150899_d((int)374), random.nextInt(3) + 1) : (var2 == 8 ? new ItemStack(Item.func_150899_d((int)374), random.nextInt(3) + 1) : (var2 == 7 && random.nextBoolean() ? new ItemStack(Item.func_150899_d((int)384), random.nextInt(3) + 1) : null)))))));
    }

    public void addChestWithCustomLoot(Random random, int par1, int par2, int par3, int[] par4, int par5) {
        this.addBlock(par1, par2, par3, 54);
        TileEntityChest chest = (TileEntityChest)this.world.func_147438_o(par1, par2, par3);
        if (chest != null) {
            for (int var1 = 0; var1 < par5; ++var1) {
                ItemStack customLoot = null;
                if (par4 != null) {
                    int v2 = par4[random.nextInt(par4.length)];
                    customLoot = v2 < 256 ? new ItemStack(Block.func_149729_e((int)par4[random.nextInt(par4.length)])) : new ItemStack(Item.func_150899_d((int)par4[random.nextInt(par4.length)]));
                }
                if (customLoot == null) continue;
                chest.func_70299_a(random.nextInt(chest.func_70302_i_()), customLoot);
            }
        }
    }

    public void addChestWithCustomLoot(Random random, int par1, int par2, int par3, int par4, int par5) {
        this.addBlock(par1, par2, par3, 54);
        TileEntityChest chest = (TileEntityChest)this.world.func_147438_o(par1, par2, par3);
        if (chest != null) {
            for (int var1 = 0; var1 < par5; ++var1) {
                ItemStack customLoot = null;
                if (par4 != 0) {
                    customLoot = par4 < 256 ? new ItemStack(Block.func_149729_e((int)par4)) : new ItemStack(Item.func_150899_d((int)par4));
                }
                if (customLoot == null) continue;
                chest.func_70299_a(random.nextInt(chest.func_70302_i_()), customLoot);
            }
        }
    }

    public boolean isAir(int par1, int par2, int par3) {
        return this.world.func_147437_c(par1, par2, par3);
    }

    public void spawnVillager(int par1, int par2, int par3, int par4, int par5) {
        for (int v1 = 0; v1 < par4; ++v1) {
            EntityVillager var1 = new EntityVillager(this.world, par5);
            var1.func_70080_a((double)par1 + 0.5, (double)par2, (double)par3 + 0.5, 0.0f, 0.0f);
            this.world.func_72838_d((Entity)var1);
        }
    }

    public void spawnCow(int par1, int par2, int par3) {
        EntityCow cow = new EntityCow(this.world);
        cow.func_70080_a((double)par1 + 0.5, (double)par2, (double)par3 + 0.5, 0.0f, 0.0f);
        this.world.func_72838_d((Entity)cow);
    }

    public void spawnPig(int par1, int par2, int par3) {
        EntityPig cow = new EntityPig(this.world);
        cow.func_70080_a((double)par1 + 0.5, (double)par2, (double)par3 + 0.5, 0.0f, 0.0f);
        this.world.func_72838_d((Entity)cow);
    }

    public void spawnSheep(int par1, int par2, int par3) {
        EntitySheep cow = new EntitySheep(this.world);
        cow.func_70080_a((double)par1 + 0.5, (double)par2, (double)par3 + 0.5, 0.0f, 0.0f);
        this.world.func_72838_d((Entity)cow);
    }

    public void spawnGolem(int par1, int par2, int par3) {
        EntityIronGolem cow = new EntityIronGolem(this.world);
        cow.func_70080_a((double)par1 + 0.5, (double)par2, (double)par3 + 0.5, 0.0f, 0.0f);
        this.world.func_72838_d((Entity)cow);
    }

    public void spawnWitch(int par1, int par2, int par3) {
        EntityCow cow = new EntityCow(this.world);
        cow.func_70080_a((double)par1 + 0.5, (double)par2, (double)par3 + 0.5, 0.0f, 0.0f);
        this.world.func_72838_d((Entity)cow);
    }

    public TileEntity getTileEntity(int par1, int par2, int par3) {
        return this.world.func_147438_o(par1, par2, par3);
    }

    public void addDispenserAndInv(Random random, int par1, int par2, int par3, int par4, int par5) {
        this.addBlock(par1, par2, par3, 23);
        TileEntityDispenser var1 = (TileEntityDispenser)this.getTileEntity(par1, par2, par3);
        if (par4 != 0 && par5 != 0) {
            ItemStack inv = par4 < 256 ? new ItemStack(Block.func_149729_e((int)par4), par5) : new ItemStack(Item.func_150899_d((int)par4), par5);
            var1.func_70299_a(random.nextInt(var1.func_70302_i_()), inv);
        }
    }
}

