/*
 * Decompiled with CFR 0.152.
 */
package de.stuuupiiid.dungeonpack;

import cpw.mods.fml.common.IWorldGenerator;
import de.stuuupiiid.dungeonpack.DungeonGenerator;
import de.stuuupiiid.dungeonpack.DungeonGeneratorBarn;
import de.stuuupiiid.dungeonpack.DungeonGeneratorCheat;
import de.stuuupiiid.dungeonpack.DungeonGeneratorCreeperColoss;
import de.stuuupiiid.dungeonpack.DungeonGeneratorFloatingIsland;
import de.stuuupiiid.dungeonpack.DungeonGeneratorFort;
import de.stuuupiiid.dungeonpack.DungeonGeneratorFortIce;
import de.stuuupiiid.dungeonpack.DungeonGeneratorGraveyard;
import de.stuuupiiid.dungeonpack.DungeonGeneratorHelpShip;
import de.stuuupiiid.dungeonpack.DungeonGeneratorIgloo;
import de.stuuupiiid.dungeonpack.DungeonGeneratorMystery;
import de.stuuupiiid.dungeonpack.DungeonGeneratorMysteryRooms;
import de.stuuupiiid.dungeonpack.DungeonGeneratorObsidianTower;
import de.stuuupiiid.dungeonpack.DungeonGeneratorPrison;
import de.stuuupiiid.dungeonpack.DungeonGeneratorPyramide;
import de.stuuupiiid.dungeonpack.DungeonGeneratorShip;
import de.stuuupiiid.dungeonpack.DungeonGeneratorSpiderBox;
import de.stuuupiiid.dungeonpack.DungeonGeneratorTempleDeath;
import de.stuuupiiid.dungeonpack.DungeonGeneratorTempleNether;
import de.stuuupiiid.dungeonpack.DungeonGeneratorTempleSmall;
import de.stuuupiiid.dungeonpack.DungeonGeneratorTempleSwamp;
import de.stuuupiiid.dungeonpack.DungeonGeneratorTreeHouse;
import de.stuuupiiid.dungeonpack.DungeonPack;
import de.stuuupiiid.dungeonpack.NPCFlyBase;
import de.stuuupiiid.dungeonpack.NPCTownBase;
import de.stuuupiiid.dungeonpack.Ship;
import de.stuuupiiid.dungeonpack.TemplePQ2;
import de.stuuupiiid.dungeonpack.TreasureBase;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class GeneratorRegistry
implements IWorldGenerator {
    public ArrayList plains = new ArrayList();
    public ArrayList icePlains = new ArrayList();
    public ArrayList forest = new ArrayList();
    public ArrayList desert = new ArrayList();
    public ArrayList beach = new ArrayList();
    public ArrayList swamp = new ArrayList();
    public ArrayList ocean = new ArrayList();
    public ArrayList river = new ArrayList();
    public ArrayList frozenOcean = new ArrayList();
    public ArrayList frozenRiver = new ArrayList();
    public ArrayList jungle = new ArrayList();
    public ArrayList mountain = new ArrayList();
    public ArrayList nether = new ArrayList();
    private int rarity;
    private int rarityB;
    private int rarityN;

    public GeneratorRegistry() {
        this.rarity = DungeonPack.instance.rarity;
        this.rarityB = DungeonPack.instance.rarityB;
        this.rarityN = DungeonPack.instance.rarityN;
    }

    public boolean spawnDungeon(World world, Random random, DungeonGenerator dungeon, int par1, int par3) {
        int par2 = world.func_72976_f(par1, par3);
        boolean v2 = false;
        Random rand = new Random();
        if (this.noLeafes(world, par1 += rand.nextInt(32) - 16, par2, par3 += rand.nextInt(32) - 16) && dungeon != null) {
            dungeon.generate(random, par1, par2, par3);
            if (DungeonPack.instance.cheat) {
                DungeonGeneratorCheat cheat = new DungeonGeneratorCheat();
                cheat.generate(random, par1, par2, par3);
            }
            return true;
        }
        for (int v1 = 0; v1 > 25; ++v1) {
            if (!this.noLeafes(world, par1, par2 - v1, par3) || dungeon == null) continue;
            dungeon.generate(random, par1, par2 - v1, par3);
            if (DungeonPack.instance.cheat) {
                DungeonGeneratorCheat cheat = new DungeonGeneratorCheat();
                cheat.generate(random, par1, par2, par3);
            }
            return true;
        }
        return false;
    }

    private boolean noLeafes(World world, int par1, int par2, int par3) {
        return true;
    }

    public void addDungeons() {
        if (DungeonPack.instance.igloo) {
            this.icePlains.add(new DungeonGeneratorIgloo());
            this.icePlains.add(new DungeonGeneratorIgloo());
            this.frozenOcean.add(new DungeonGeneratorIgloo());
            this.frozenOcean.add(new DungeonGeneratorIgloo());
        }
        if (DungeonPack.instance.smalltemple) {
            this.jungle.add(new DungeonGeneratorTempleSmall());
            this.jungle.add(new DungeonGeneratorTempleSmall());
        }
        if (DungeonPack.instance.swamptemple) {
            this.swamp.add(new DungeonGeneratorTempleSwamp());
            this.swamp.add(new DungeonGeneratorTempleSwamp());
        }
        if (DungeonPack.instance.barn) {
            this.plains.add(new DungeonGeneratorBarn());
            this.plains.add(new DungeonGeneratorBarn());
            this.icePlains.add(new DungeonGeneratorBarn());
            this.icePlains.add(new DungeonGeneratorBarn());
        }
        if (DungeonPack.instance.fort) {
            this.plains.add(new DungeonGeneratorFort());
            this.plains.add(new DungeonGeneratorFort());
            this.desert.add(new DungeonGeneratorFort());
            this.desert.add(new DungeonGeneratorFort());
            this.beach.add(new DungeonGeneratorFort());
            this.beach.add(new DungeonGeneratorFort());
        }
        if (DungeonPack.instance.graveyard) {
            this.plains.add(new DungeonGeneratorGraveyard());
            this.plains.add(new DungeonGeneratorGraveyard());
            this.icePlains.add(new DungeonGeneratorGraveyard());
            this.icePlains.add(new DungeonGeneratorGraveyard());
        }
        if (DungeonPack.instance.icefort) {
            this.icePlains.add(new DungeonGeneratorFortIce());
            this.icePlains.add(new DungeonGeneratorFortIce());
            this.frozenOcean.add(new DungeonGeneratorFortIce());
            this.frozenOcean.add(new DungeonGeneratorFortIce());
            this.frozenRiver.add(new DungeonGeneratorFortIce());
            this.frozenRiver.add(new DungeonGeneratorFortIce());
        }
        if (DungeonPack.instance.forestprison) {
            this.forest.add(new DungeonGeneratorPrison(17, 5, 85));
            this.forest.add(new DungeonGeneratorPrison(17, 5, 85));
        }
        if (DungeonPack.instance.mystery) {
            this.forest.add(new DungeonGeneratorMystery());
            this.forest.add(new DungeonGeneratorMystery());
        }
        if (DungeonPack.instance.deathtemple) {
            this.forest.add(new DungeonGeneratorTempleDeath());
            this.forest.add(new DungeonGeneratorTempleDeath());
            this.swamp.add(new DungeonGeneratorTempleDeath());
            this.swamp.add(new DungeonGeneratorTempleDeath());
        }
        if (DungeonPack.instance.creepercoloss) {
            this.desert.add(new DungeonGeneratorCreeperColoss());
            this.desert.add(new DungeonGeneratorCreeperColoss());
            this.beach.add(new DungeonGeneratorCreeperColoss());
            this.beach.add(new DungeonGeneratorCreeperColoss());
        }
        if (DungeonPack.instance.desertprison) {
            this.desert.add(new DungeonGeneratorPrison(121, 24, 102));
            this.desert.add(new DungeonGeneratorPrison(121, 24, 102));
        }
        if (DungeonPack.instance.pyramide) {
            this.desert.add(new DungeonGeneratorPyramide());
        }
        if (DungeonPack.instance.spiderbox) {
            this.swamp.add(new DungeonGeneratorSpiderBox());
            this.swamp.add(new DungeonGeneratorSpiderBox());
        }
        if (DungeonPack.instance.ship) {
            this.ocean.add(new DungeonGeneratorShip());
            this.ocean.add(new DungeonGeneratorShip());
        }
        if (DungeonPack.instance.helpship) {
            this.ocean.add(new DungeonGeneratorHelpShip());
            this.ocean.add(new DungeonGeneratorHelpShip());
        }
        if (DungeonPack.instance.obsidiantower) {
            this.ocean.add(new DungeonGeneratorObsidianTower());
            this.river.add(new DungeonGeneratorObsidianTower());
            this.river.add(new DungeonGeneratorObsidianTower());
            this.frozenOcean.add(new DungeonGeneratorObsidianTower());
        }
        if (DungeonPack.instance.treehouse) {
            this.jungle.add(new DungeonGeneratorTreeHouse());
            this.jungle.add(new DungeonGeneratorTreeHouse());
            this.mountain.add(new DungeonGeneratorTreeHouse());
        }
        if (DungeonPack.instance.mysteryrooms) {
            this.plains.add(new DungeonGeneratorMysteryRooms());
            this.icePlains.add(new DungeonGeneratorMysteryRooms());
            this.forest.add(new DungeonGeneratorMysteryRooms());
            this.desert.add(new DungeonGeneratorMysteryRooms());
            this.beach.add(new DungeonGeneratorMysteryRooms());
            this.swamp.add(new DungeonGeneratorMysteryRooms());
            this.ocean.add(new DungeonGeneratorMysteryRooms());
            this.river.add(new DungeonGeneratorMysteryRooms());
            this.frozenRiver.add(new DungeonGeneratorMysteryRooms());
            this.frozenOcean.add(new DungeonGeneratorMysteryRooms());
            this.jungle.add(new DungeonGeneratorMysteryRooms());
            this.mountain.add(new DungeonGeneratorMysteryRooms());
        }
        if (DungeonPack.instance.island) {
            this.plains.add(new DungeonGeneratorFloatingIsland());
            this.icePlains.add(new DungeonGeneratorFloatingIsland());
            this.forest.add(new DungeonGeneratorFloatingIsland());
            this.desert.add(new DungeonGeneratorFloatingIsland());
            this.beach.add(new DungeonGeneratorFloatingIsland());
            this.swamp.add(new DungeonGeneratorFloatingIsland());
            this.ocean.add(new DungeonGeneratorFloatingIsland());
            this.river.add(new DungeonGeneratorFloatingIsland());
            this.frozenRiver.add(new DungeonGeneratorFloatingIsland());
            this.frozenOcean.add(new DungeonGeneratorFloatingIsland());
            this.jungle.add(new DungeonGeneratorFloatingIsland());
            this.mountain.add(new DungeonGeneratorFloatingIsland());
        }
        if (DungeonPack.instance.netherprison) {
            this.nether.add(new DungeonGeneratorPrison(112, 87, 113));
        }
        if (DungeonPack.instance.nethertemple) {
            this.nether.add(new DungeonGeneratorTempleNether());
        }
    }

    private boolean temperatureRight(World world, int par1, int par3, float temperature) {
        return world.func_72807_a((int)par1, (int)par3).field_76750_F + 0.6f > temperature && world.func_72807_a((int)par1, (int)par3).field_76750_F - 0.6f < temperature;
    }

    private boolean plains(World world, Random random, int par1, int par2, int par3) {
        if (this.temperatureRight(world, par1, par3, BiomeGenBase.field_76772_c.field_76750_F) && this.plains.size() != 0) {
            return this.spawnDungeon(world, random, this.plains(random), par1, par3);
        }
        return false;
    }

    private boolean icePlains(World world, Random random, int par1, int par2, int par3) {
        if (this.temperatureRight(world, par1, par3, BiomeGenBase.field_76774_n.field_76750_F) && this.icePlains.size() != 0) {
            return this.spawnDungeon(world, random, this.icePlains(random), par1, par3);
        }
        return false;
    }

    private boolean forest(World world, Random random, int par1, int par2, int par3) {
        if (this.temperatureRight(world, par1, par3, BiomeGenBase.field_76767_f.field_76750_F) && this.forest.size() != 0) {
            return this.spawnDungeon(world, random, this.forest(random), par1, par3);
        }
        return false;
    }

    private boolean desert(World world, Random random, int par1, int par2, int par3) {
        if (this.temperatureRight(world, par1, par3, BiomeGenBase.field_76769_d.field_76750_F) && this.desert.size() != 0) {
            return this.spawnDungeon(world, random, this.desert(random), par1, par3);
        }
        return false;
    }

    private boolean beach(World world, Random random, int par1, int par2, int par3) {
        if (this.temperatureRight(world, par1, par3, BiomeGenBase.field_76787_r.field_76750_F) && this.beach.size() != 0) {
            return this.spawnDungeon(world, random, this.beach(random), par1, par3);
        }
        return false;
    }

    private boolean swamp(World world, Random random, int par1, int par2, int par3) {
        if (this.temperatureRight(world, par1, par3, BiomeGenBase.field_76780_h.field_76750_F) && this.swamp.size() != 0) {
            return this.spawnDungeon(world, random, this.swamp(random), par1, par3);
        }
        return false;
    }

    private boolean ocean(World world, Random random, int par1, int par2, int par3) {
        if (BiomeGenBase.field_76771_b == world.func_72807_a(par1, par3) && this.ocean.size() != 0) {
            return this.ocean(random).generate(random, par1, par2, par3);
        }
        return false;
    }

    private boolean river(World world, Random random, int par1, int par2, int par3) {
        if (BiomeGenBase.field_76781_i == world.func_72807_a(par1, par3) && this.river.size() != 0) {
            return this.river(random).generate(random, par1, par2, par3);
        }
        return false;
    }

    private boolean frozenOcean(World world, Random random, int par1, int par2, int par3) {
        if (BiomeGenBase.field_76776_l == world.func_72807_a(par1, par3) && this.frozenOcean.size() != 0) {
            return this.frozenOcean(random).generate(random, par1, par2, par3);
        }
        return false;
    }

    private boolean frozenRiver(World world, Random random, int par1, int par2, int par3) {
        if (BiomeGenBase.field_76777_m == world.func_72807_a(par1, par3) && this.frozenRiver.size() != 0) {
            return this.frozenRiver(random).generate(random, par1, par2, par3);
        }
        return false;
    }

    private boolean jungle(World world, Random random, int par1, int par2, int par3) {
        if (this.temperatureRight(world, par1, par3, BiomeGenBase.field_76782_w.field_76750_F) && this.jungle.size() != 0) {
            DungeonGenerator gen = this.jungle(random);
            if (gen instanceof DungeonGeneratorTreeHouse) {
                gen.generate(random, par1, par2, par3);
                return true;
            }
            return this.spawnDungeon(world, random, this.jungle(random), par1, par3);
        }
        return false;
    }

    private boolean mountain(World world, Random random, int par1, int par2, int par3) {
        if (this.temperatureRight(world, par1, par3, BiomeGenBase.field_76770_e.field_76750_F) && this.mountain.size() != 0) {
            return this.spawnDungeon(world, random, this.mountain(random), par1, par3);
        }
        return false;
    }

    private void nether(World world, Random random, int par1, int par2, int par3) {
        if (BiomeGenBase.field_76778_j == world.func_72807_a(par1, par3) && this.nether.size() != 0) {
            this.nether(random).generateNether(random, par1, par2, par3);
        }
    }

    private DungeonGenerator plains(Random random) {
        return (DungeonGenerator)this.plains.get(random.nextInt(this.plains.size()));
    }

    private DungeonGenerator icePlains(Random random) {
        return (DungeonGenerator)this.icePlains.get(random.nextInt(this.icePlains.size()));
    }

    private DungeonGenerator forest(Random random) {
        return (DungeonGenerator)this.forest.get(random.nextInt(this.forest.size()));
    }

    private DungeonGenerator desert(Random random) {
        return (DungeonGenerator)this.desert.get(random.nextInt(this.desert.size()));
    }

    private DungeonGenerator beach(Random random) {
        return (DungeonGenerator)this.beach.get(random.nextInt(this.beach.size()));
    }

    private DungeonGenerator swamp(Random random) {
        return (DungeonGenerator)this.swamp.get(random.nextInt(this.swamp.size()));
    }

    private DungeonGenerator ocean(Random random) {
        return (DungeonGenerator)this.ocean.get(random.nextInt(this.ocean.size()));
    }

    private DungeonGenerator river(Random random) {
        return (DungeonGenerator)this.river.get(random.nextInt(this.river.size()));
    }

    private DungeonGenerator frozenOcean(Random random) {
        return (DungeonGenerator)this.frozenOcean.get(random.nextInt(this.frozenOcean.size()));
    }

    private DungeonGenerator frozenRiver(Random random) {
        return (DungeonGenerator)this.frozenRiver.get(random.nextInt(this.frozenRiver.size()));
    }

    private DungeonGenerator jungle(Random random) {
        return (DungeonGenerator)this.jungle.get(random.nextInt(this.jungle.size()));
    }

    private DungeonGenerator mountain(Random random) {
        return (DungeonGenerator)this.mountain.get(random.nextInt(this.mountain.size()));
    }

    private DungeonGenerator nether(Random random) {
        return (DungeonGenerator)this.nether.get(random.nextInt(this.nether.size()));
    }

    private void generateTreasure(World world, Random random, int x, int z) {
        if (DungeonPack.instance.treasure) {
            TreasureBase treasure1 = new TreasureBase();
            treasure1.generate(random, x, 10, z);
            if (DungeonPack.instance.cheat) {
                DungeonGeneratorCheat treasure = new DungeonGeneratorCheat();
                treasure.generate(random, x, 10, z);
            }
        }
    }

    private void generateBosses(World world, Random random, int x, int z) {
        NPCFlyBase npcFly = new NPCFlyBase();
        NPCTownBase npcTown = new NPCTownBase();
        Ship ship = new Ship();
        TemplePQ2 pq2 = new TemplePQ2();
        int par2 = world.func_72976_f(x, z);
        BiomeGenBase biome = world.func_72807_a(x, z);
        if ((biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76774_n) && DungeonPack.instance.npctown) {
            if (npcTown.generate(random, x, par2, z) && DungeonPack.instance.cheat) {
                DungeonGeneratorCheat cheat = new DungeonGeneratorCheat();
                cheat.generate(random, x, par2, z);
            }
        } else if (biome == BiomeGenBase.field_76771_b && DungeonPack.instance.shipBoss) {
            if (ship.generateShip(random, x, par2 + 12, z) && DungeonPack.instance.cheat) {
                DungeonGeneratorCheat cheat = new DungeonGeneratorCheat();
                cheat.generate(random, x, par2, z);
            }
        } else if ((biome == BiomeGenBase.field_76780_h || biome == BiomeGenBase.field_76772_c) && DungeonPack.instance.pq2) {
            if (DungeonPack.instance.cheat) {
                DungeonGeneratorCheat cheat = new DungeonGeneratorCheat();
                cheat.generate(random, x, par2, z);
            }
            this.spawnDungeon(world, random, pq2, x, z);
        } else if (DungeonPack.instance.npcfly && npcFly.generate(random, x, 160, z) && DungeonPack.instance.cheat) {
            DungeonGeneratorCheat cheat = new DungeonGeneratorCheat();
            cheat.generate(random, x, par2, z);
        }
    }

    private void generateSimples(World world, Random random, int x, int z) {
        int par2 = world.func_72976_f(x, z);
        if (this.ocean(world, random, x, par2, z) || this.frozenOcean(world, random, x, par2, z) || this.river(world, random, x, par2, z) || this.frozenRiver(world, random, x, par2, z)) {
            return;
        }
        block20: for (int v1 = 0; v1 < 16; ++v1) {
            int rand = random.nextInt(8);
            switch (rand) {
                case 0: {
                    if (!this.plains(world, random, x, par2, z)) continue block20;
                    return;
                }
                case 1: {
                    if (!this.icePlains(world, random, x, par2, z)) continue block20;
                    return;
                }
                case 2: {
                    if (!this.forest(world, random, x, par2, z)) continue block20;
                    return;
                }
                case 3: {
                    if (!this.desert(world, random, x, par2, z)) continue block20;
                    return;
                }
                case 4: {
                    if (!this.beach(world, random, x, par2, z)) continue block20;
                    return;
                }
                case 5: {
                    if (!this.swamp(world, random, x, par2, z)) continue block20;
                    return;
                }
                case 6: {
                    if (!this.jungle(world, random, x, par2, z)) continue block20;
                    return;
                }
                case 7: {
                    if (!this.mountain(world, random, x, par2, z)) continue block20;
                    return;
                }
            }
        }
        block21: for (int rand = 0; rand < 9; ++rand) {
            switch (rand) {
                case 0: {
                    if (!this.plains(world, random, x, par2, z)) continue block21;
                    return;
                }
                case 1: {
                    if (!this.icePlains(world, random, x, par2, z)) continue block21;
                    return;
                }
                case 2: {
                    if (!this.forest(world, random, x, par2, z)) continue block21;
                    return;
                }
                case 3: {
                    if (!this.desert(world, random, x, par2, z)) continue block21;
                    return;
                }
                case 4: {
                    if (!this.beach(world, random, x, par2, z)) continue block21;
                    return;
                }
                case 5: {
                    if (!this.swamp(world, random, x, par2, z)) continue block21;
                    return;
                }
                case 6: {
                    if (!this.jungle(world, random, x, par2, z)) continue block21;
                    return;
                }
                case 7: {
                    if (!this.mountain(world, random, x, par2, z)) continue block21;
                    return;
                }
            }
        }
    }

    private void generateNether(World world, Random random, int x, int z) {
        if (random.nextInt(this.rarity) == 0) {
            int par2 = 40 + random.nextInt(20);
            this.nether(world, random, x, par2, z);
        }
    }

    private void generateEnd(World world, Random random, int x, int z) {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        try {
            switch (world.field_73011_w.field_76574_g) {
                case -1: {
                    this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case 0: {
                    try {
                        if (DungeonPack.instance.disabledBiomeIDs.contains(world.func_72807_a((int)(chunkX * 16), (int)(chunkZ * 16)).field_76756_M)) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (random.nextInt(this.rarityB) == 0) {
                        this.generateTreasure(world, random, chunkX * 16, chunkZ * 16);
                    }
                    if (random.nextInt(this.rarityN * 2) == 0) {
                        this.generateBosses(world, random, chunkX * 16, chunkZ * 16);
                        break;
                    }
                    if (random.nextInt(this.rarity) != 0) break;
                    this.generateSimples(world, random, chunkX * 16, chunkZ * 16);
                }
            }
        }
        catch (Exception var9) {
            System.err.println("DungeonPack ERROR REPORT");
            var9.printStackTrace();
            System.err.println("Please backup your world before going on!");
        }
    }
}

