/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.api;

import codechicken.core.ServerUtils;
import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.EnderStoragePlugin;
import codechicken.lib.config.ConfigFile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EnderStorageManager {
    private static EnderStorageManager serverManager;
    private static EnderStorageManager clientManager;
    private static ConfigFile config;
    private static HashMap<String, EnderStoragePlugin> plugins;
    private Map<String, AbstractEnderStorage> storageMap;
    private Map<String, List<AbstractEnderStorage>> storageList;
    public final boolean client;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private List<AbstractEnderStorage> dirtyStorage;
    private NBTTagCompound saveTag;

    public EnderStorageManager(boolean client, World world) {
        this.client = client;
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        for (String key : plugins.keySet()) {
            this.storageList.put(key, new ArrayList());
        }
        if (!client) {
            this.load(world);
        }
    }

    private void sendClientInfo(EntityPlayer player) {
        for (Map.Entry<String, EnderStoragePlugin> plugin : plugins.entrySet()) {
            plugin.getValue().sendClientInfo(player, this.storageList.get(plugin.getKey()));
        }
    }

    private void load(World world) {
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "EnderStorage");
        try {
            if (!this.saveDir.exists()) {
                this.saveDir.mkdirs();
            }
            this.saveFiles = new File[]{new File(this.saveDir, "data1.dat"), new File(this.saveDir, "data2.dat"), new File(this.saveDir, "lock.dat")};
            if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                this.saveTo = fin.read() ^ 1;
                fin.close();
                if (this.saveFiles[this.saveTo ^ 1].exists()) {
                    DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo ^ 1]));
                    this.saveTag = CompressedStreamTools.func_74796_a((InputStream)din);
                    din.close();
                } else {
                    this.saveTag = new NBTTagCompound();
                }
            } else {
                this.saveTag = new NBTTagCompound();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void save(boolean force) {
        if (!this.dirtyStorage.isEmpty() || force) {
            for (AbstractEnderStorage inv : this.dirtyStorage) {
                this.saveTag.func_74782_a(inv.freq + "|" + inv.owner + "|" + inv.type(), (NBTBase)inv.saveToTag());
                inv.setClean();
            }
            this.dirtyStorage.clear();
            try {
                File saveFile = this.saveFiles[this.saveTo];
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.saveTag, (OutputStream)dout);
                dout.close();
                FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
                fout.write(this.saveTo);
                fout.close();
                this.saveTo ^= 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reloadManager(boolean client, World world) {
        EnderStorageManager newManager = new EnderStorageManager(client, world);
        if (client) {
            clientManager = newManager;
        } else {
            serverManager = newManager;
        }
    }

    public File getSaveDir() {
        return this.saveDir;
    }

    public static EnderStorageManager instance(boolean client) {
        return client ? clientManager : serverManager;
    }

    public AbstractEnderStorage getStorage(String owner, int freq, String type) {
        String key;
        AbstractEnderStorage storage;
        if (owner == null) {
            owner = "global";
        }
        if ((storage = this.storageMap.get(key = freq + "|" + owner + "|" + type)) == null) {
            storage = plugins.get(type).createEnderStorage(this, owner, freq);
            if (!this.client && this.saveTag.func_74764_b(key)) {
                storage.loadFromTag(this.saveTag.func_74775_l(key));
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return storage;
    }

    public static int getFreqFromColours(int colour1, int colour2, int colour3) {
        return ((colour1 & 0xF) << 8) + ((colour2 & 0xF) << 4) + (colour3 & 0xF);
    }

    public static int getFreqFromColours(int[] colours) {
        return ((colours[0] & 0xF) << 8) + ((colours[1] & 0xF) << 4) + (colours[2] & 0xF);
    }

    public static int getColourFromFreq(int freq, int colour) {
        switch (colour) {
            case 0: {
                return freq >> 8 & 0xF;
            }
            case 1: {
                return freq >> 4 & 0xF;
            }
            case 2: {
                return freq & 0xF;
            }
        }
        return 0;
    }

    public static int[] getColoursFromFreq(int freq) {
        int[] ai = new int[]{freq >> 8 & 0xF, freq >> 4 & 0xF, freq & 0xF};
        return ai;
    }

    public static void loadConfig(ConfigFile config2) {
        config = config2;
        for (Map.Entry<String, EnderStoragePlugin> plugin : plugins.entrySet()) {
            plugin.getValue().loadConfig(config.getTag(plugin.getKey()));
        }
    }

    public static void registerPlugin(EnderStoragePlugin plugin) {
        plugins.put(plugin.identifer(), plugin);
        if (config != null) {
            plugin.loadConfig(config.getTag(plugin.identifer()));
        }
        if (serverManager != null) {
            EnderStorageManager.serverManager.storageList.put(plugin.identifer(), new ArrayList());
        }
        if (clientManager != null) {
            EnderStorageManager.clientManager.storageList.put(plugin.identifer(), new ArrayList());
        }
    }

    public void requestSave(AbstractEnderStorage storage) {
        this.dirtyStorage.add(storage);
    }

    static {
        plugins = new HashMap();
    }

    public static class EnderStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            EnderStorageManager manager = EnderStorageManager.instance(event.world.field_72995_K);
            if (event.world.field_72995_K) {
                EnderStorageManager.reloadManager(true, null);
            } else if (manager == null) {
                EnderStorageManager.reloadManager(false, event.world);
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (!event.world.field_72995_K && EnderStorageManager.instance(false) != null) {
                EnderStorageManager.instance(false).save(false);
            }
        }

        @SubscribeEvent
        public void onChunkDataLoad(ChunkDataEvent.Load event) {
            if (serverManager == null) {
                EnderStorageManager.reloadManager(false, event.world);
            }
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
            if (!event.world.field_72995_K && !ServerUtils.mc().func_71278_l()) {
                serverManager = null;
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            EnderStorageManager.instance(false).sendClientInfo(event.player);
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerLoggedOutEvent event) {
            EnderStorageManager.instance(false).sendClientInfo(event.player);
        }
    }
}

