/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.core.commands.CoreCommand;
import codechicken.core.commands.PlayerCommand;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.EnderStorageRecipe;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;

public class CommandEnderStorage
extends PlayerCommand {
    public String func_71517_b() {
        return "enderstorage";
    }

    public String func_71518_a(ICommandSender var1) {
        return StatCollector.func_74838_a((String)"enderstorage.command.usage");
    }

    public void handleCommand(WorldServer world, EntityPlayerMP player, String[] args) {
        int freq;
        CoreCommand.WCommandSender wrapped = new CoreCommand.WCommandSender((CoreCommand)this, (ICommandSender)player);
        if (args.length < 1 || args.length > 4) {
            wrapped.func_145747_a((IChatComponent)new ChatComponentTranslation("enderstorage.command.no_arguments", new Object[0]));
            return;
        }
        if (args.length <= 2) {
            try {
                freq = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                wrapped.func_145747_a((IChatComponent)new ChatComponentTranslation("enderstorage.command.no_freq", new Object[0]));
                return;
            }
            if (freq < 0 || freq >= 4096) {
                wrapped.func_145747_a((IChatComponent)new ChatComponentTranslation("enderstorage.command.no_freq", new Object[0]));
                return;
            }
        } else {
            int[] colours = new int[3];
            for (int i = 0; i < 3; ++i) {
                int d = EnderStorageRecipe.getDyeColour(args[i]);
                if (d < 0) {
                    wrapped.func_145747_a((IChatComponent)new ChatComponentTranslation("enderstorage.command.no_colour", new Object[]{args[i]}));
                    return;
                }
                colours[i] = d;
            }
            freq = EnderStorageManager.getFreqFromColours(colours);
        }
        String owner = args.length % 2 == 1 ? "global" : args[args.length - 1];
        ((EnderItemStorage)EnderStorageManager.instance(world.field_72995_K).getStorage(owner, freq, "item")).openSMPGui((EntityPlayer)player, "enderstorage.serverop");
    }

    public void printHelp(CoreCommand.WCommandSender listener) {
        listener.func_145747_a((IChatComponent)new ChatComponentText(this.func_71518_a((ICommandSender)listener)));
    }

    public boolean OPOnly() {
        return true;
    }

    public int minimumParameters() {
        return 0;
    }
}

