/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import codechicken.enderstorage.storage.item.TileEnderChest;
import codechicken.lib.render.SpriteSheetManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemEnderPouch
extends Item {
    @SideOnly(value=Side.CLIENT)
    private SpriteSheetManager.SpriteSheet spriteSheet;

    public ItemEnderPouch() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabs.field_78031_c);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        if (stack.func_77942_o() && !stack.func_77978_p().func_74779_i("owner").equals("global")) {
            list.add(stack.func_77978_p().func_74779_i("owner"));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEnderChest && player.func_70093_af()) {
            TileEnderChest chest = (TileEnderChest)tile;
            stack.func_77964_b(chest.freq);
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a("owner", chest.owner);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (world.field_72995_K || player.func_70093_af()) {
            return item;
        }
        ((EnderItemStorage)EnderStorageManager.instance(world.field_72995_K).getStorage(this.getOwner(item), item.func_77960_j() & 0xFFF, "item")).openSMPGui(player, item.func_77977_a() + ".name");
        return item;
    }

    public boolean func_46058_c() {
        return true;
    }

    public String getOwner(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74779_i("owner") : "global";
    }

    public int getRenderPasses(int metadata) {
        return 4;
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.spriteSheet.getSprite(this.getIconIndex(stack, renderPass));
    }

    public int getIconIndex(ItemStack stack, int renderPass) {
        if (renderPass == 0) {
            int i = 0;
            if (((EnderItemStorage)EnderStorageManager.instance(true).getStorage(this.getOwner(stack), stack.func_77960_j() & 0xFFF, "item")).openCount() > 0) {
                i |= 1;
            }
            if (!this.getOwner(stack).equals("global")) {
                i |= 2;
            }
            return i;
        }
        return renderPass * 16 + EnderStorageManager.getColourFromFreq(stack.func_77960_j() & 0xFFF, renderPass - 1);
    }

    public boolean func_77623_v() {
        return true;
    }

    public void func_94581_a(IIconRegister register) {
        this.spriteSheet = SpriteSheetManager.getSheet((ResourceLocation)new ResourceLocation("enderstorage", "textures/enderpouch.png"));
        this.spriteSheet.requestIndicies(new int[]{0, 1, 2, 3});
        int i = 16;
        while (i < 64) {
            this.spriteSheet.requestIndicies(new int[]{i++});
        }
        this.spriteSheet.registerIcons(register);
    }
}

