/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import extracells.item.ItemFluidPattern;
import extracells.registries.ItemEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.MutablePair;

public class FluidUtil {
    public static IAEFluidStack createAEFluidStack(Fluid fluid) {
        return FluidUtil.createAEFluidStack(new FluidStack(fluid, 1000));
    }

    public static IAEFluidStack createAEFluidStack(Fluid fluid, long amount) {
        return FluidUtil.createAEFluidStack(fluid.getID(), amount);
    }

    public static IAEFluidStack createAEFluidStack(FluidStack fluid) {
        return AEApi.instance().storage().createFluidStack(fluid);
    }

    public static IAEFluidStack createAEFluidStack(int fluidId, long amount) {
        return (IAEFluidStack)FluidUtil.createAEFluidStack(new FluidStack(FluidRegistry.getFluid((int)fluidId), 1)).setStackSize(amount);
    }

    public static MutablePair<Integer, ItemStack> drainStack(ItemStack itemStack, FluidStack fluid) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack drained = ((IFluidContainerItem)item).drain(itemStack, fluid.amount, true);
            int amountDrained = drained != null && drained.getFluid() == fluid.getFluid() ? drained.amount : 0;
            return new MutablePair((Object)amountDrained, (Object)itemStack);
        }
        if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
            FluidStack content = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
            int amountDrained = content != null && content.getFluid() == fluid.getFluid() ? content.amount : 0;
            return new MutablePair((Object)amountDrained, (Object)itemStack.func_77973_b().getContainerItem(itemStack));
        }
        return null;
    }

    public static MutablePair<Integer, ItemStack> fillStack(ItemStack itemStack, FluidStack fluid) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            int filled = ((IFluidContainerItem)item).fill(itemStack, fluid, true);
            return new MutablePair((Object)filled, (Object)itemStack);
        }
        if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
            FluidStack fluid2 = fluid.copy();
            fluid2.amount = Math.max(FluidContainerRegistry.getContainerCapacity((FluidStack)fluid, (ItemStack)itemStack), fluid.amount);
            ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)itemStack);
            FluidStack filled = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
            return new MutablePair((Object)(filled != null ? filled.amount : 0), (Object)filledContainer);
        }
        if (item == ItemEnum.FLUIDPATTERN.getItem()) {
            return new MutablePair((Object)0, (Object)ItemFluidPattern.getPatternForFluid(fluid.getFluid()));
        }
        return null;
    }

    public static int getCapacity(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)item).getCapacity(itemStack);
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data == null || !data.emptyContainer.func_77969_a(itemStack)) continue;
                FluidStack interior = data.fluid;
                return interior != null ? interior.amount : 0;
            }
        }
        return 0;
    }

    public static FluidStack getFluidFromContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemStack container = itemStack.func_77946_l();
        Item item = container.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)item).getFluid(container);
        }
        if (item == ItemEnum.FLUIDPATTERN.getItem()) {
            return new FluidStack(ItemFluidPattern.getFluid(itemStack), 0);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack content = ((IFluidContainerItem)item).getFluid(itemStack);
            return content == null || content.amount <= 0;
        }
        return item == ItemEnum.FLUIDPATTERN.getItem() || FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack);
    }

    public static boolean isFilled(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack content = ((IFluidContainerItem)item).getFluid(itemStack);
            return content != null && content.amount > 0;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack);
    }

    public static boolean isFluidContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof IFluidContainerItem || item == ItemEnum.FLUIDPATTERN.getItem() || FluidContainerRegistry.isContainer((ItemStack)itemStack);
    }
}

