/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.multiparts;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.ISidedBatteryProvider;
import buildcraft.api.mj.MjAPI;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.TMultiPart;
import cofh.api.energy.IEnergyHandler;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeEnergy;
import com.rwtema.extrautils.tileentity.transfernodes.multiparts.TransferNodePart;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeEnergy;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.mj.ISidedBatteryProvider", modid="BuildCraftAPI|power")})
public class TransferNodePartEnergy
extends TransferNodePart
implements INodeEnergy,
IEnergyHandler,
ISidedBatteryProvider {
    public TransferNodePartEnergy(TileEntityTransferNode node) {
        super(node);
    }

    public TransferNodePartEnergy() {
        super(new TileEntityTransferNodeEnergy());
    }

    public TransferNodePartEnergy(int meta, TileEntityTransferNodeEnergy node) {
        super(meta, node);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> s = new ArrayList<Cuboid6>();
        s.add(new Cuboid6(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125));
        return s;
    }

    @Override
    public TileEntityTransferNodeEnergy getNode() {
        return (TileEntityTransferNodeEnergy)this.node;
    }

    @Override
    public boolean occlusionTest(TMultiPart npart) {
        return super.occlusionTest(npart);
    }

    public String getType() {
        return "extrautils:transfer_node_energy";
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.isBlocked(from)) {
            return 0;
        }
        return this.getNode().receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.isBlocked(from)) {
            return 0;
        }
        return this.getNode().extractEnergy(from, maxExtract, simulate);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.isBlocked(from) && this.getNode().canConnectEnergy(from);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.isBlocked(from)) {
            return 0;
        }
        return this.getNode().getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.isBlocked(from)) {
            return 0;
        }
        return this.getNode().getMaxEnergyStored(from);
    }

    @Override
    public IBatteryObject getMjBattery(String kind, ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN || this.isBlocked(direction)) {
            return null;
        }
        return MjAPI.getMjBattery(this.getNode());
    }
}

