/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.block;

import cofh.api.block.IBlockAppearance;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ExtraUtilsProxy;
import com.rwtema.extrautils.block.BlockEnderLily;
import com.rwtema.extrautils.block.IconConnectedTexture;
import com.rwtema.extrautils.block.IconConnectedTextureFlipped;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDecoration
extends Block
implements IBlockAppearance {
    public static boolean gettingConnectedTextures = false;
    public String[][] texture = new String[16][6];
    public boolean[][] ctexture = new boolean[16][6];
    public int[] light = new int[16];
    public float[] hardness = new float[16];
    public boolean[] field_149787_q = new boolean[16];
    public int[] opacity = new int[16];
    public boolean[] flipTopBottom = new boolean[16];
    public float[] enchantBonus = new float[16];
    public boolean solid;
    public boolean[] isEnder = new boolean[16];
    private IIcon[][] icons = new IIcon[16][6];
    public String[] name = new String[16];
    private int numBlocks = 0;

    public BlockDecoration(boolean solid) {
        super(solid ? Material.field_151576_e : Material.field_151592_s);
        this.solid = solid;
        this.func_149647_a(ExtraUtils.creativeTabExtraUtils);
        this.func_149711_c(0.45f).func_149752_b(10.0f).func_149672_a(field_149769_e);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        return this.isEnder[world.func_72805_g(x, y, z)] && plant instanceof BlockEnderLily || super.canSustainPlant(world, x, y, z, direction, plant);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        if (world instanceof World && !((World)world).func_72899_e(x, y, z)) {
            return 0;
        }
        return this.opacity[world.func_72805_g(x, y, z)];
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null && block != this) {
            return block.getLightValue(world, x, y, z);
        }
        return this.light[world.func_72805_g(x, y, z)];
    }

    public float func_149712_f(World par1World, int par2, int par3, int par4) {
        if (par1World == null) {
            return this.field_149782_v;
        }
        return this.hardness[par1World.func_72805_g(par2, par3, par4)];
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        if (world == null) {
            return this.func_149638_a(par1Entity);
        }
        return this.hardness[world.func_72805_g(x, y, z)];
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_149662_c() {
        return this.solid;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return this.solid ? super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5) : !par1IBlockAccess.func_147439_a(par2, par3, par4).func_149662_c() && par1IBlockAccess.func_147439_a(par2, par3, par4) != this;
    }

    public boolean func_149686_d() {
        return this.solid;
    }

    public void addBlock(int id, String defaultname, String texture) {
        this.addBlock(id, defaultname, texture, false, true);
    }

    public void addBlock(int id, String defaultname, String texture, boolean connectedTexture, boolean opaque) {
        if (id >= 0 && id < 16) {
            this.name[id] = texture;
            for (int side = 0; side < 6; ++side) {
                this.texture[id][side] = texture;
                this.ctexture[id][side] = connectedTexture;
            }
            this.hardness[id] = this.field_149782_v;
            this.field_149787_q[id] = opaque;
            this.opacity[id] = this.solid ? 255 : 0;
            this.enchantBonus[id] = 0.0f;
            this.isEnder[id] = false;
        }
    }

    public float getEnchantPowerBonus(World world, int x, int y, int z) {
        return this.enchantBonus[world.func_72805_g(x, y, z)];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        if (par1 <= 1 && this.flipTopBottom[par2 & 0xF] && this.icons[par2 & 0xF][par1] instanceof IconConnectedTexture) {
            return new IconConnectedTextureFlipped((IconConnectedTexture)this.icons[par2 & 0xF][par1]);
        }
        return this.icons[par2 & 0xF][par1];
    }

    public int func_149692_a(int par1) {
        return par1 & 0xF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 16; ++i) {
            if (this.name[i] == null) continue;
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public int func_149645_b() {
        return ExtraUtilsProxy.connectedTextureID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IIconRegister) {
        for (int i = 0; i < 16; ++i) {
            for (int side = 0; side < 6; ++side) {
                if (this.texture[i][side] == null || this.texture[i][side].equals("")) continue;
                this.icons[i][side] = this.ctexture[i][side] ? new IconConnectedTexture(par1IIconRegister, this.texture[i][side]) : par1IIconRegister.func_94245_a(this.texture[i][side]);
            }
        }
    }

    @Override
    public Block getVisualBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this;
    }

    @Override
    public int getVisualMeta(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean supportsVisualConnections() {
        return true;
    }
}

