/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

public class GunAnimations {
    public static GunAnimations defaults = new GunAnimations();
    public float gunSlide = 0.0f;
    public float lastGunSlide = 0.0f;
    public int timeUntilPump = 0;
    public int timeToPumpFor = 0;
    public float pumped = -1.0f;
    public float lastPumped = -1.0f;
    public boolean pumping = false;
    public boolean reloading = false;
    public float reloadAnimationTime = 0.0f;
    public float reloadAnimationProgress = 0.0f;
    public float lastReloadAnimationProgress = 0.0f;
    public float minigunBarrelRotation = 0.0f;
    public float minigunBarrelRotationSpeed = 0.0f;
    public int meleeAnimationProgress = 0;
    public int meleeAnimationLength = 0;

    public void update() {
        this.lastPumped = this.pumped;
        if (this.timeUntilPump > 0) {
            --this.timeUntilPump;
            if (this.timeUntilPump == 0) {
                this.pumping = true;
                this.pumped = -1.0f;
                this.lastPumped = -1.0f;
            }
        }
        if (this.pumping) {
            this.pumped += 2.0f / (float)this.timeToPumpFor;
            if (this.pumped >= 0.999f) {
                this.pumping = false;
            }
        }
        this.lastGunSlide = this.gunSlide;
        if (this.gunSlide > 0.0f) {
            this.gunSlide *= 0.4f;
        }
        this.lastReloadAnimationProgress = this.reloadAnimationProgress;
        if (this.reloading) {
            this.reloadAnimationProgress += 1.0f / this.reloadAnimationTime;
        }
        if (this.reloading && this.reloadAnimationProgress >= 1.0f) {
            this.reloading = false;
        }
        this.minigunBarrelRotation += this.minigunBarrelRotationSpeed;
        this.minigunBarrelRotationSpeed *= 0.9f;
        if (this.meleeAnimationLength > 0) {
            ++this.meleeAnimationProgress;
            if (this.meleeAnimationProgress == this.meleeAnimationLength) {
                this.meleeAnimationLength = 0;
                this.meleeAnimationProgress = 0;
            }
        }
    }

    public void doShoot(int pumpDelay, int pumpTime) {
        this.minigunBarrelRotationSpeed += 2.0f;
        this.gunSlide = 1.0f;
        this.lastGunSlide = 1.0f;
        this.timeUntilPump = pumpDelay;
        this.timeToPumpFor = pumpTime;
    }

    public void doReload(int reloadTime, int pumpDelay, int pumpTime) {
        this.reloading = true;
        this.reloadAnimationProgress = 0.0f;
        this.lastReloadAnimationProgress = 0.0f;
        this.reloadAnimationTime = reloadTime;
        this.timeUntilPump = pumpDelay;
        this.timeToPumpFor = pumpTime;
    }

    public void doMelee(int meleeTime) {
        this.meleeAnimationLength = meleeTime;
    }
}

