/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class MultiModel
implements IModel {
    protected final IModel base;
    protected final IModelState baseState;
    protected final Map<String, Pair<IModel, IModelState>> parts;

    public MultiModel(IModel base, IModelState baseState, ImmutableMap<String, Pair<IModel, IModelState>> parts) {
        this.base = base;
        this.baseState = baseState;
        this.parts = parts;
    }

    public MultiModel(IModel base, IModelState baseState, Map<String, Pair<IModel, IModelState>> parts) {
        this(base, baseState, (ImmutableMap<String, Pair<IModel, IModelState>>)ImmutableMap.copyOf(parts));
    }

    @Override
    public Collection<oa> getDependencies() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.getDependencies());
        }
        for (Pair<IModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IModel)pair.getLeft()).getDependencies());
        }
        return deps;
    }

    @Override
    public Collection<oa> getTextures() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.getTextures());
        }
        for (Pair<IModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IModel)pair.getLeft()).getTextures());
        }
        return deps;
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, cus format, Function<oa, cue> bakedTextureGetter) {
        IFlexibleBakedModel bakedBase = null;
        if (this.base != null) {
            bakedBase = this.base.bake(this.baseState, format, bakedTextureGetter);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Pair<IModel, IModelState>> entry : this.parts.entrySet()) {
            Pair<IModel, IModelState> pair = entry.getValue();
            mapBuilder.put((Object)entry.getKey(), (Object)((IModel)pair.getLeft()).bake((IModelState)pair.getRight(), format, bakedTextureGetter));
        }
        return new Baked(bakedBase, (ImmutableMap<String, IFlexibleBakedModel>)mapBuilder.build());
    }

    @Override
    public IModelState getDefaultState() {
        return cxf.a;
    }

    public IModel getBaseModel() {
        return this.base;
    }

    public Map<String, Pair<IModel, IModelState>> getParts() {
        return this.parts;
    }

    public static class Baked
    implements IFlexibleBakedModel {
        protected final IFlexibleBakedModel base;
        protected final ImmutableMap<String, IFlexibleBakedModel> parts;
        protected final IFlexibleBakedModel internalBase;
        protected final ImmutableList<clt> general;
        protected final ImmutableMap<ej, ImmutableList<clt>> faces;

        public Baked(IFlexibleBakedModel base, ImmutableMap<String, IFlexibleBakedModel> parts) {
            this.base = base;
            this.parts = parts;
            if (base != null) {
                this.internalBase = base;
            } else {
                UnmodifiableIterator iter = parts.values().iterator();
                if (iter.hasNext()) {
                    this.internalBase = (IFlexibleBakedModel)iter.next();
                } else {
                    throw new RuntimeException("No base model or submodel provided for this MultiModel.Baked.");
                }
            }
            EnumMap faces = Maps.newEnumMap(ej.class);
            for (ej face : ej.values()) {
                ImmutableList.Builder faceQuads = ImmutableList.builder();
                if (base != null) {
                    faceQuads.addAll(base.a(face));
                }
                for (IFlexibleBakedModel bakedPart : parts.values()) {
                    faceQuads.addAll(bakedPart.a(face));
                }
                faces.put(face, faceQuads.build());
            }
            this.faces = Maps.immutableEnumMap((Map)faces);
            ImmutableList.Builder genQuads = ImmutableList.builder();
            if (base != null) {
                genQuads.addAll(base.a());
            }
            for (IFlexibleBakedModel bakedPart : parts.values()) {
                genQuads.addAll(bakedPart.a());
            }
            this.general = genQuads.build();
        }

        public boolean b() {
            return this.internalBase.b();
        }

        public boolean c() {
            return this.internalBase.c();
        }

        public boolean d() {
            return this.internalBase.d();
        }

        public cue e() {
            return this.internalBase.e();
        }

        public cmx f() {
            return this.internalBase.f();
        }

        @Override
        public List<clt> a(ej side) {
            return (List)this.faces.get((Object)side);
        }

        @Override
        public List<clt> a() {
            return this.general;
        }

        @Override
        public cus getFormat() {
            return this.internalBase.getFormat();
        }

        public IFlexibleBakedModel getBaseModel() {
            return this.base;
        }

        public Map<String, IFlexibleBakedModel> getParts() {
            return this.parts;
        }
    }
}

