/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Locale;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;

public class Fluid {
    protected final String fluidName;
    protected String unlocalizedName;
    protected cue stillIcon;
    protected cue flowingIcon;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 300;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected amx rarity = amx.a;
    protected atr block = null;

    public Fluid(String fluidName) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(atr block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else {
            FMLLog.warning("A mod has attempted to assign Block " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to the Block " + this.block + ". You may have duplicate Fluid Blocks as a result. It *may* be possible to configure your mods to avoid this.", new Object[0]);
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(amx rarity) {
        this.rarity = rarity;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final int getID() {
        return FluidRegistry.getFluidID(this.fluidName);
    }

    public final atr getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public String getLocalizedName(FluidStack stack) {
        return this.getLocalizedName();
    }

    @Deprecated
    public String getLocalizedName() {
        String s = this.getUnlocalizedName();
        return s == null ? "" : fi.a((String)s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getSpriteNumber() {
        return 0;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public amx getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    public final Fluid setStillIcon(cue stillIcon) {
        this.stillIcon = stillIcon;
        return this;
    }

    public final Fluid setFlowingIcon(cue flowingIcon) {
        this.flowingIcon = flowingIcon;
        return this;
    }

    public final Fluid setIcons(cue stillIcon, cue flowingIcon) {
        return this.setStillIcon(stillIcon).setFlowingIcon(flowingIcon);
    }

    public final Fluid setIcons(cue commonIcon) {
        return this.setStillIcon(commonIcon).setFlowingIcon(commonIcon);
    }

    public cue getIcon() {
        return this.getStillIcon();
    }

    public cue getStillIcon() {
        return this.stillIcon;
    }

    public cue getFlowingIcon() {
        return this.flowingIcon;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public amx getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public cue getIcon(FluidStack stack) {
        return this.getIcon();
    }

    public int getLuminosity(aqu world, dt pos) {
        return this.getLuminosity();
    }

    public int getDensity(aqu world, dt pos) {
        return this.getDensity();
    }

    public int getTemperature(aqu world, dt pos) {
        return this.getTemperature();
    }

    public int getViscosity(aqu world, dt pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(aqu world, dt pos) {
        return this.isGaseous();
    }

    public amx getRarity(aqu world, dt pos) {
        return this.getRarity();
    }

    public int getColor(aqu world, dt pos) {
        return this.getColor();
    }

    public cue getIcon(aqu world, dt pos) {
        return this.getIcon();
    }
}

