/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.registry;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;

public class RenderingRegistry {
    private static final RenderingRegistry INSTANCE = new RenderingRegistry();
    private List<EntityRendererInfo> entityRenderers = Lists.newArrayList();

    public static void registerEntityRenderingHandler(Class<? extends wv> entityClass, cpu renderer) {
        RenderingRegistry.INSTANCE.entityRenderers.add(new EntityRendererInfo(entityClass, renderer));
    }

    public static void loadEntityRenderers(Map<Class<? extends wv>, cpu> rendererMap) {
        for (EntityRendererInfo info : RenderingRegistry.INSTANCE.entityRenderers) {
            rendererMap.put(info.target, info.renderer);
        }
    }

    private static class EntityRendererInfo {
        private Class<? extends wv> target;
        private cpu renderer;

        public EntityRendererInfo(Class<? extends wv> target, cpu renderer) {
            this.target = target;
            this.renderer = renderer;
        }
    }
}

