/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class VillagerRegistry {
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private Map<Integer, oa> newVillagers;
    private boolean hasInit = false;
    private FMLControlledNamespacedRegistry<VillagerProfession> professions = GameData.createRegistry("villagerprofessions", VillagerProfession.class, 0, 1024);

    private VillagerRegistry() {
        this.init();
    }

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    @Deprecated
    public void registerVillagerId(int id2) {
        if (this.newVillagerIds.contains(id2)) {
            FMLLog.severe("Attempt to register duplicate villager id %d", id2);
            throw new RuntimeException();
        }
        this.newVillagerIds.add(id2);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public void registerVillagerSkin(int villagerId, oa villagerSkin) {
        if (this.newVillagers == null) {
            this.newVillagers = Maps.newHashMap();
        }
        this.newVillagers.put(villagerId, villagerSkin);
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static oa getVillagerSkin(int villagerType, oa defaultSkin) {
        if (VillagerRegistry.instance().newVillagers != null && VillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return VillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    @Deprecated
    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(VillagerRegistry.instance().newVillagerIds);
    }

    public static void addExtraVillageComponents(ArrayList components, Random random, int i) {
        ArrayList parts = components;
        for (IVillageCreationHandler handler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i));
        }
    }

    public static Object getVillageComponent(bne villagePiece, bnk startPiece, List pieces, Random random, int p1, int p2, int p3, ej facing, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.a).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    public void register(VillagerProfession prof) {
        this.register(prof, -1);
    }

    private void register(VillagerProfession prof, int id2) {
        this.professions.a(id2, prof.name, prof);
    }

    private void init() {
        if (this.hasInit) {
            return;
        }
        VillagerProfession prof = new VillagerProfession("minecraft:farmer", "minecraft:textures/entity/villager/farmer.png");
        this.register(prof, 0);
        new VillagerCareer(prof, "farmer").init(VanillaTrades.trades[0][0]);
        new VillagerCareer(prof, "fisherman").init(VanillaTrades.trades[0][1]);
        new VillagerCareer(prof, "shepherd").init(VanillaTrades.trades[0][2]);
        new VillagerCareer(prof, "fletcher").init(VanillaTrades.trades[0][3]);
        prof = new VillagerProfession("minecraft:librarian", "minecraft:textures/entity/villager/librarian.png");
        this.register(prof, 1);
        new VillagerCareer(prof, "librarian").init(VanillaTrades.trades[1][0]);
        prof = new VillagerProfession("minecraft:priest", "minecraft:textures/entity/villager/priest.png");
        this.register(prof, 2);
        new VillagerCareer(prof, "cleric").init(VanillaTrades.trades[2][0]);
        prof = new VillagerProfession("minecraft:smith", "minecraft:textures/entity/villager/smith.png");
        this.register(prof, 3);
        new VillagerCareer(prof, "armor").init(VanillaTrades.trades[3][0]);
        new VillagerCareer(prof, "weapon").init(VanillaTrades.trades[3][1]);
        new VillagerCareer(prof, "tool").init(VanillaTrades.trades[3][2]);
        prof = new VillagerProfession("minecraft:butcher", "minecraft:textures/entity/villager/butcher.png");
        this.register(prof, 4);
        new VillagerCareer(prof, "butcher").init(VanillaTrades.trades[4][0]);
        new VillagerCareer(prof, "leather").init(VanillaTrades.trades[4][1]);
    }

    public static void setRandomProfession(agp entity, Random rand) {
        Set entries = VillagerRegistry.INSTANCE.professions.c();
        int prof = rand.nextInt(entries.size());
        entity.r(rand.nextInt(5));
    }

    private static class VanillaTrades {
        private static final agw[][][][] trades = new agw[][][][]{{{{new agr(amk.O, new agx(18, 22)), new agr(amk.bS, new agx(15, 19)), new agr(amk.bR, new agx(15, 19)), new agv(amk.P, new agx(-4, -2))}, {new agr(alq.a((atr)aty.aU), new agx(8, 13)), new agv(amk.ca, new agx(-3, -2))}, {new agr(alq.a((atr)aty.bk), new agx(7, 12)), new agv(amk.e, new agx(-5, -7))}, {new agv(amk.bc, new agx(-6, -10)), new agv(amk.aZ, new agx(1, 1))}}, {{new agr(amk.F, new agx(15, 20)), new agr(amk.h, new agx(16, 24)), new agu(amk.aU, new agx(6, 6), amk.aV, new agx(6, 6))}, {new agt((alq)amk.aR, new agx(7, 8))}}, {{new agr(alq.a((atr)aty.L), new agx(16, 22)), new agv((alq)amk.be, new agx(3, 4))}, {new agv(new amj(aty.L, 1, 0), new agx(1, 2)), new agv(new amj(aty.L, 1, 1), new agx(1, 2)), new agv(new amj(aty.L, 1, 2), new agx(1, 2)), new agv(new amj(aty.L, 1, 3), new agx(1, 2)), new agv(new amj(aty.L, 1, 4), new agx(1, 2)), new agv(new amj(aty.L, 1, 5), new agx(1, 2)), new agv(new amj(aty.L, 1, 6), new agx(1, 2)), new agv(new amj(aty.L, 1, 7), new agx(1, 2)), new agv(new amj(aty.L, 1, 8), new agx(1, 2)), new agv(new amj(aty.L, 1, 9), new agx(1, 2)), new agv(new amj(aty.L, 1, 10), new agx(1, 2)), new agv(new amj(aty.L, 1, 11), new agx(1, 2)), new agv(new amj(aty.L, 1, 12), new agx(1, 2)), new agv(new amj(aty.L, 1, 13), new agx(1, 2)), new agv(new amj(aty.L, 1, 14), new agx(1, 2)), new agv(new amj(aty.L, 1, 15), new agx(1, 2))}}, {{new agr(amk.F, new agx(15, 20)), new agv(amk.g, new agx(-12, -8))}, {new agv((alq)amk.f, new agx(2, 3)), new agu(alq.a((atr)aty.n), new agx(10, 10), amk.ak, new agx(6, 10))}}}, {{{new agr(amk.aK, new agx(24, 36)), new ags()}, {new agr(amk.aL, new agx(8, 10)), new agv(amk.aQ, new agx(10, 12)), new agv(alq.a((atr)aty.X), new agx(3, 4))}, {new agr(amk.bN, new agx(2, 2)), new agv(amk.aS, new agx(10, 12)), new agv(alq.a((atr)aty.w), new agx(-5, -3))}, {new ags()}, {new ags()}, {new agv(amk.co, new agx(20, 22))}}}, {{{new agr(amk.bt, new agx(36, 40)), new agr(amk.k, new agx(8, 10))}, {new agv(amk.aC, new agx(-4, -1)), new agv(new amj(amk.aW, 1, akv.l.b()), new agx(-2, -1))}, {new agv(amk.bH, new agx(7, 11)), new agv(alq.a((atr)aty.aX), new agx(-3, -1))}, {new agv(amk.bK, new agx(3, 11))}}}, {{{new agr(amk.h, new agx(16, 24)), new agv((alq)amk.Y, new agx(4, 6))}, {new agr(amk.j, new agx(7, 9)), new agv((alq)amk.Z, new agx(10, 14))}, {new agr(amk.i, new agx(3, 4)), new agt((alq)amk.ad, new agx(16, 19))}, {new agv((alq)amk.X, new agx(5, 7)), new agv((alq)amk.W, new agx(9, 11)), new agv((alq)amk.U, new agx(5, 7)), new agv((alq)amk.V, new agx(11, 15))}}, {{new agr(amk.h, new agx(16, 24)), new agv(amk.c, new agx(6, 8))}, {new agr(amk.j, new agx(7, 9)), new agt(amk.l, new agx(9, 10))}, {new agr(amk.i, new agx(3, 4)), new agt(amk.u, new agx(12, 15)), new agt(amk.x, new agx(9, 12))}}, {{new agr(amk.h, new agx(16, 24)), new agt(amk.a, new agx(5, 7))}, {new agr(amk.j, new agx(7, 9)), new agt(amk.b, new agx(9, 11))}, {new agr(amk.i, new agx(3, 4)), new agt(amk.w, new agx(12, 15))}}}, {{{new agr(amk.al, new agx(14, 18)), new agr(amk.bk, new agx(14, 18))}, {new agr(amk.h, new agx(16, 24)), new agv(amk.am, new agx(-7, -5)), new agv(amk.bl, new agx(-8, -6))}}, {{new agr(amk.aF, new agx(9, 12)), new agv((alq)amk.S, new agx(2, 4))}, {new agt((alq)amk.R, new agx(7, 12))}, {new agv(amk.aA, new agx(8, 10))}}}};

        private VanillaTrades() {
        }
    }

    public static class VillagerCareer {
        private VillagerProfession profession;
        private String name;
        private int id;

        public VillagerCareer(VillagerProfession parent, String name) {
            this.profession = parent;
            this.name = name;
            parent.register(this);
        }

        private VillagerCareer init(agw[][] traids) {
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VillagerCareer)) {
                return false;
            }
            VillagerCareer oc = (VillagerCareer)o;
            return this.name.equals(oc.name) && this.profession == oc.profession;
        }
    }

    public static class VillagerProfession {
        private oa name;
        private oa texture;
        private List<VillagerCareer> careers = Lists.newArrayList();
        private RegistryDelegate<VillagerProfession> delegate = GameData.getRegistry("villagerprofessions", VillagerProfession.class).getDelegate(this, VillagerProfession.class);

        public VillagerProfession(String name, String texture) {
            this.name = new oa(name);
            this.texture = new oa(texture);
            ((RegistryDelegate.Delegate)this.delegate).setName(name);
        }

        private void register(VillagerCareer career) {
            Validate.isTrue((!this.careers.contains(career) ? 1 : 0) != 0, (String)"Attempted to register career that is already registered.", (Object[])new Object[0]);
            Validate.isTrue((career.profession == this ? 1 : 0) != 0, (String)"Attempted to register career for the wrong profession.", (Object[])new Object[0]);
            career.id = this.careers.size();
            this.careers.add(career);
        }
    }

    public static interface IVillageCreationHandler {
        public bne getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public Object buildComponent(bne var1, bnk var2, List var3, Random var4, int var5, int var6, int var7, ej var8, int var9);
    }
}

